/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CompareFacesRequest extends RekognitionRequest implements
        ToCopyableBuilder<CompareFacesRequest.Builder, CompareFacesRequest> {
    private final Image sourceImage;

    private final Image targetImage;

    private final Float similarityThreshold;

    private CompareFacesRequest(BuilderImpl builder) {
        super(builder);
        this.sourceImage = builder.sourceImage;
        this.targetImage = builder.targetImage;
        this.similarityThreshold = builder.similarityThreshold;
    }

    /**
     * <p>
     * The source image, either as bytes or as an S3 object.
     * </p>
     * 
     * @return The source image, either as bytes or as an S3 object.
     */
    public Image sourceImage() {
        return sourceImage;
    }

    /**
     * <p>
     * The target image, either as bytes or as an S3 object.
     * </p>
     * 
     * @return The target image, either as bytes or as an S3 object.
     */
    public Image targetImage() {
        return targetImage;
    }

    /**
     * <p>
     * The minimum level of confidence in the face matches that a match must meet to be included in the
     * <code>FaceMatches</code> array.
     * </p>
     * 
     * @return The minimum level of confidence in the face matches that a match must meet to be included in the
     *         <code>FaceMatches</code> array.
     */
    public Float similarityThreshold() {
        return similarityThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceImage());
        hashCode = 31 * hashCode + Objects.hashCode(targetImage());
        hashCode = 31 * hashCode + Objects.hashCode(similarityThreshold());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareFacesRequest)) {
            return false;
        }
        CompareFacesRequest other = (CompareFacesRequest) obj;
        return Objects.equals(sourceImage(), other.sourceImage()) && Objects.equals(targetImage(), other.targetImage())
                && Objects.equals(similarityThreshold(), other.similarityThreshold());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (sourceImage() != null) {
            sb.append("SourceImage: ").append(sourceImage()).append(",");
        }
        if (targetImage() != null) {
            sb.append("TargetImage: ").append(targetImage()).append(",");
        }
        if (similarityThreshold() != null) {
            sb.append("SimilarityThreshold: ").append(similarityThreshold()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceImage":
            return Optional.of(clazz.cast(sourceImage()));
        case "TargetImage":
            return Optional.of(clazz.cast(targetImage()));
        case "SimilarityThreshold":
            return Optional.of(clazz.cast(similarityThreshold()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends RekognitionRequest.Builder, CopyableBuilder<Builder, CompareFacesRequest> {
        /**
         * <p>
         * The source image, either as bytes or as an S3 object.
         * </p>
         * 
         * @param sourceImage
         *        The source image, either as bytes or as an S3 object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceImage(Image sourceImage);

        /**
         * <p>
         * The source image, either as bytes or as an S3 object.
         * </p>
         * This is a convenience that creates an instance of the {@link Image.Builder} avoiding the need to create one
         * manually via {@link Image#builder()}.
         *
         * When the {@link Consumer} completes, {@link Image.Builder#build()} is called immediately and its result is
         * passed to {@link #sourceImage(Image)}.
         * 
         * @param sourceImage
         *        a consumer that will call methods on {@link Image.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceImage(Image)
         */
        default Builder sourceImage(Consumer<Image.Builder> sourceImage) {
            return sourceImage(Image.builder().apply(sourceImage).build());
        }

        /**
         * <p>
         * The target image, either as bytes or as an S3 object.
         * </p>
         * 
         * @param targetImage
         *        The target image, either as bytes or as an S3 object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetImage(Image targetImage);

        /**
         * <p>
         * The target image, either as bytes or as an S3 object.
         * </p>
         * This is a convenience that creates an instance of the {@link Image.Builder} avoiding the need to create one
         * manually via {@link Image#builder()}.
         *
         * When the {@link Consumer} completes, {@link Image.Builder#build()} is called immediately and its result is
         * passed to {@link #targetImage(Image)}.
         * 
         * @param targetImage
         *        a consumer that will call methods on {@link Image.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetImage(Image)
         */
        default Builder targetImage(Consumer<Image.Builder> targetImage) {
            return targetImage(Image.builder().apply(targetImage).build());
        }

        /**
         * <p>
         * The minimum level of confidence in the face matches that a match must meet to be included in the
         * <code>FaceMatches</code> array.
         * </p>
         * 
         * @param similarityThreshold
         *        The minimum level of confidence in the face matches that a match must meet to be included in the
         *        <code>FaceMatches</code> array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder similarityThreshold(Float similarityThreshold);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private Image sourceImage;

        private Image targetImage;

        private Float similarityThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(CompareFacesRequest model) {
            sourceImage(model.sourceImage);
            targetImage(model.targetImage);
            similarityThreshold(model.similarityThreshold);
        }

        public final Image.Builder getSourceImage() {
            return sourceImage != null ? sourceImage.toBuilder() : null;
        }

        @Override
        public final Builder sourceImage(Image sourceImage) {
            this.sourceImage = sourceImage;
            return this;
        }

        public final void setSourceImage(Image.BuilderImpl sourceImage) {
            this.sourceImage = sourceImage != null ? sourceImage.build() : null;
        }

        public final Image.Builder getTargetImage() {
            return targetImage != null ? targetImage.toBuilder() : null;
        }

        @Override
        public final Builder targetImage(Image targetImage) {
            this.targetImage = targetImage;
            return this;
        }

        public final void setTargetImage(Image.BuilderImpl targetImage) {
            this.targetImage = targetImage != null ? targetImage.build() : null;
        }

        public final Float getSimilarityThreshold() {
            return similarityThreshold;
        }

        @Override
        public final Builder similarityThreshold(Float similarityThreshold) {
            this.similarityThreshold = similarityThreshold;
            return this;
        }

        public final void setSimilarityThreshold(Float similarityThreshold) {
            this.similarityThreshold = similarityThreshold;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CompareFacesRequest build() {
            return new CompareFacesRequest(this);
        }
    }
}
