/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.ComparedSourceImageFaceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Type that describes the face Amazon Rekognition chose to compare with the faces in the target. This contains a
 * bounding box for the selected face and confidence level that the bounding box contains a face. Note that Amazon
 * Rekognition selects the largest face in the source image for this comparison.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ComparedSourceImageFace implements StructuredPojo,
        ToCopyableBuilder<ComparedSourceImageFace.Builder, ComparedSourceImageFace> {
    private final BoundingBox boundingBox;

    private final Float confidence;

    private ComparedSourceImageFace(BuilderImpl builder) {
        this.boundingBox = builder.boundingBox;
        this.confidence = builder.confidence;
    }

    /**
     * <p>
     * Bounding box of the face.
     * </p>
     * 
     * @return Bounding box of the face.
     */
    public BoundingBox boundingBox() {
        return boundingBox;
    }

    /**
     * <p>
     * Confidence level that the selected bounding box contains a face.
     * </p>
     * 
     * @return Confidence level that the selected bounding box contains a face.
     */
    public Float confidence() {
        return confidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComparedSourceImageFace)) {
            return false;
        }
        ComparedSourceImageFace other = (ComparedSourceImageFace) obj;
        return Objects.equals(boundingBox(), other.boundingBox()) && Objects.equals(confidence(), other.confidence());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (boundingBox() != null) {
            sb.append("BoundingBox: ").append(boundingBox()).append(",");
        }
        if (confidence() != null) {
            sb.append("Confidence: ").append(confidence()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BoundingBox":
            return Optional.of(clazz.cast(boundingBox()));
        case "Confidence":
            return Optional.of(clazz.cast(confidence()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComparedSourceImageFaceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ComparedSourceImageFace> {
        /**
         * <p>
         * Bounding box of the face.
         * </p>
         * 
         * @param boundingBox
         *        Bounding box of the face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(BoundingBox boundingBox);

        /**
         * <p>
         * Bounding box of the face.
         * </p>
         * This is a convenience that creates an instance of the {@link BoundingBox.Builder} avoiding the need to create
         * one manually via {@link BoundingBox#builder()}.
         *
         * When the {@link Consumer} completes, {@link BoundingBox.Builder#build()} is called immediately and its result
         * is passed to {@link #boundingBox(BoundingBox)}.
         * 
         * @param boundingBox
         *        a consumer that will call methods on {@link BoundingBox.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #boundingBox(BoundingBox)
         */
        default Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return boundingBox(BoundingBox.builder().apply(boundingBox).build());
        }

        /**
         * <p>
         * Confidence level that the selected bounding box contains a face.
         * </p>
         * 
         * @param confidence
         *        Confidence level that the selected bounding box contains a face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);
    }

    static final class BuilderImpl implements Builder {
        private BoundingBox boundingBox;

        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(ComparedSourceImageFace model) {
            boundingBox(model.boundingBox);
            confidence(model.confidence);
        }

        public final BoundingBox.Builder getBoundingBox() {
            return boundingBox != null ? boundingBox.toBuilder() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        public final Float getConfidence() {
            return confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public ComparedSourceImageFace build() {
            return new ComparedSourceImageFace(this);
        }
    }
}
