/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DetectFacesRequest extends RekognitionRequest implements
        ToCopyableBuilder<DetectFacesRequest.Builder, DetectFacesRequest> {
    private final Image image;

    private final List<String> attributes;

    private DetectFacesRequest(BuilderImpl builder) {
        super(builder);
        this.image = builder.image;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The image in which you want to detect faces. You can specify a blob or an S3 object.
     * </p>
     * 
     * @return The image in which you want to detect faces. You can specify a blob or an S3 object.
     */
    public Image image() {
        return image;
    }

    /**
     * <p>
     * An array of facial attributes you want to be returned. This can be the default list of attributes or all
     * attributes. If you don't specify a value for <code>Attributes</code> or if you specify <code>["DEFAULT"]</code>,
     * the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>,
     * <code>Pose</code>, <code>Quality</code> and <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all
     * facial attributes are returned but the operation will take longer to complete.
     * </p>
     * <p>
     * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine which
     * attributes to return (in this case, all attributes).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of facial attributes you want to be returned. This can be the default list of attributes or all
     *         attributes. If you don't specify a value for <code>Attributes</code> or if you specify
     *         <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
     *         <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code> and
     *         <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned but the
     *         operation will take longer to complete.</p>
     *         <p>
     *         If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
     *         determine which attributes to return (in this case, all attributes).
     */
    public List<Attribute> attributes() {
        return TypeConverter.convert(attributes, Attribute::fromValue);
    }

    /**
     * <p>
     * An array of facial attributes you want to be returned. This can be the default list of attributes or all
     * attributes. If you don't specify a value for <code>Attributes</code> or if you specify <code>["DEFAULT"]</code>,
     * the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>,
     * <code>Pose</code>, <code>Quality</code> and <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all
     * facial attributes are returned but the operation will take longer to complete.
     * </p>
     * <p>
     * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine which
     * attributes to return (in this case, all attributes).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of facial attributes you want to be returned. This can be the default list of attributes or all
     *         attributes. If you don't specify a value for <code>Attributes</code> or if you specify
     *         <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
     *         <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code> and
     *         <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned but the
     *         operation will take longer to complete.</p>
     *         <p>
     *         If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
     *         determine which attributes to return (in this case, all attributes).
     */
    public List<String> attributesStrings() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(attributesStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectFacesRequest)) {
            return false;
        }
        DetectFacesRequest other = (DetectFacesRequest) obj;
        return Objects.equals(image(), other.image()) && Objects.equals(attributesStrings(), other.attributesStrings());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (image() != null) {
            sb.append("Image: ").append(image()).append(",");
        }
        if (attributesStrings() != null) {
            sb.append("Attributes: ").append(attributesStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Image":
            return Optional.of(clazz.cast(image()));
        case "Attributes":
            return Optional.of(clazz.cast(attributesStrings()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends RekognitionRequest.Builder, CopyableBuilder<Builder, DetectFacesRequest> {
        /**
         * <p>
         * The image in which you want to detect faces. You can specify a blob or an S3 object.
         * </p>
         * 
         * @param image
         *        The image in which you want to detect faces. You can specify a blob or an S3 object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(Image image);

        /**
         * <p>
         * The image in which you want to detect faces. You can specify a blob or an S3 object.
         * </p>
         * This is a convenience that creates an instance of the {@link Image.Builder} avoiding the need to create one
         * manually via {@link Image#builder()}.
         *
         * When the {@link Consumer} completes, {@link Image.Builder#build()} is called immediately and its result is
         * passed to {@link #image(Image)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link Image.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(Image)
         */
        default Builder image(Consumer<Image.Builder> image) {
            return image(Image.builder().apply(image).build());
        }

        /**
         * <p>
         * An array of facial attributes you want to be returned. This can be the default list of attributes or all
         * attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         * <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code> and <code>Landmarks</code>. If you provide
         * <code>["ALL"]</code>, all facial attributes are returned but the operation will take longer to complete.
         * </p>
         * <p>
         * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine
         * which attributes to return (in this case, all attributes).
         * </p>
         * 
         * @param attributes
         *        An array of facial attributes you want to be returned. This can be the default list of attributes or
         *        all attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         *        <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
         *        <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code> and
         *        <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned but
         *        the operation will take longer to complete.</p>
         *        <p>
         *        If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
         *        determine which attributes to return (in this case, all attributes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<String> attributes);

        /**
         * <p>
         * An array of facial attributes you want to be returned. This can be the default list of attributes or all
         * attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         * <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code> and <code>Landmarks</code>. If you provide
         * <code>["ALL"]</code>, all facial attributes are returned but the operation will take longer to complete.
         * </p>
         * <p>
         * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine
         * which attributes to return (in this case, all attributes).
         * </p>
         * 
         * @param attributes
         *        An array of facial attributes you want to be returned. This can be the default list of attributes or
         *        all attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         *        <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
         *        <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code> and
         *        <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned but
         *        the operation will take longer to complete.</p>
         *        <p>
         *        If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
         *        determine which attributes to return (in this case, all attributes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(String... attributes);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private Image image;

        private List<String> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectFacesRequest model) {
            image(model.image);
            attributes(model.attributes);
        }

        public final Image.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        public final Collection<String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Collection<String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(String... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DetectFacesRequest build() {
            return new DetectFacesRequest(this);
        }
    }
}
