/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DetectFacesResponse extends RekognitionResponse implements
        ToCopyableBuilder<DetectFacesResponse.Builder, DetectFacesResponse> {
    private final List<FaceDetail> faceDetails;

    private final String orientationCorrection;

    private DetectFacesResponse(BuilderImpl builder) {
        super(builder);
        this.faceDetails = builder.faceDetails;
        this.orientationCorrection = builder.orientationCorrection;
    }

    /**
     * <p>
     * Details of each face found in the image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Details of each face found in the image.
     */
    public List<FaceDetail> faceDetails() {
        return faceDetails;
    }

    /**
     * <p>
     * The orientation of the input image (counter-clockwise direction). If your application displays the image, you can
     * use this value to correct image orientation. The bounding box coordinates returned in <code>FaceDetails</code>
     * represent face locations before the image orientation is corrected.
     * </p>
     * <note>
     * <p>
     * If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes the
     * image's orientation. If so, and the Exif metadata for the input image populates the orientation field, the value
     * of <code>OrientationCorrection</code> is null and the <code>FaceDetails</code> bounding box coordinates represent
     * face locations after Exif metadata is used to correct the image orientation. Images in .png format don't contain
     * Exif metadata.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #orientationCorrection} will return {@link OrientationCorrection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #orientationCorrectionString}.
     * </p>
     * 
     * @return The orientation of the input image (counter-clockwise direction). If your application displays the image,
     *         you can use this value to correct image orientation. The bounding box coordinates returned in
     *         <code>FaceDetails</code> represent face locations before the image orientation is corrected. </p> <note>
     *         <p>
     *         If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes
     *         the image's orientation. If so, and the Exif metadata for the input image populates the orientation
     *         field, the value of <code>OrientationCorrection</code> is null and the <code>FaceDetails</code> bounding
     *         box coordinates represent face locations after Exif metadata is used to correct the image orientation.
     *         Images in .png format don't contain Exif metadata.
     *         </p>
     * @see OrientationCorrection
     */
    public OrientationCorrection orientationCorrection() {
        return OrientationCorrection.fromValue(orientationCorrection);
    }

    /**
     * <p>
     * The orientation of the input image (counter-clockwise direction). If your application displays the image, you can
     * use this value to correct image orientation. The bounding box coordinates returned in <code>FaceDetails</code>
     * represent face locations before the image orientation is corrected.
     * </p>
     * <note>
     * <p>
     * If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes the
     * image's orientation. If so, and the Exif metadata for the input image populates the orientation field, the value
     * of <code>OrientationCorrection</code> is null and the <code>FaceDetails</code> bounding box coordinates represent
     * face locations after Exif metadata is used to correct the image orientation. Images in .png format don't contain
     * Exif metadata.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #orientationCorrection} will return {@link OrientationCorrection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #orientationCorrectionString}.
     * </p>
     * 
     * @return The orientation of the input image (counter-clockwise direction). If your application displays the image,
     *         you can use this value to correct image orientation. The bounding box coordinates returned in
     *         <code>FaceDetails</code> represent face locations before the image orientation is corrected. </p> <note>
     *         <p>
     *         If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes
     *         the image's orientation. If so, and the Exif metadata for the input image populates the orientation
     *         field, the value of <code>OrientationCorrection</code> is null and the <code>FaceDetails</code> bounding
     *         box coordinates represent face locations after Exif metadata is used to correct the image orientation.
     *         Images in .png format don't contain Exif metadata.
     *         </p>
     * @see OrientationCorrection
     */
    public String orientationCorrectionString() {
        return orientationCorrection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(faceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(orientationCorrectionString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectFacesResponse)) {
            return false;
        }
        DetectFacesResponse other = (DetectFacesResponse) obj;
        return Objects.equals(faceDetails(), other.faceDetails())
                && Objects.equals(orientationCorrectionString(), other.orientationCorrectionString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (faceDetails() != null) {
            sb.append("FaceDetails: ").append(faceDetails()).append(",");
        }
        if (orientationCorrectionString() != null) {
            sb.append("OrientationCorrection: ").append(orientationCorrectionString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FaceDetails":
            return Optional.of(clazz.cast(faceDetails()));
        case "OrientationCorrection":
            return Optional.of(clazz.cast(orientationCorrectionString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends RekognitionResponse.Builder, CopyableBuilder<Builder, DetectFacesResponse> {
        /**
         * <p>
         * Details of each face found in the image.
         * </p>
         * 
         * @param faceDetails
         *        Details of each face found in the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceDetails(Collection<FaceDetail> faceDetails);

        /**
         * <p>
         * Details of each face found in the image.
         * </p>
         * 
         * @param faceDetails
         *        Details of each face found in the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceDetails(FaceDetail... faceDetails);

        /**
         * <p>
         * The orientation of the input image (counter-clockwise direction). If your application displays the image, you
         * can use this value to correct image orientation. The bounding box coordinates returned in
         * <code>FaceDetails</code> represent face locations before the image orientation is corrected.
         * </p>
         * <note>
         * <p>
         * If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes the
         * image's orientation. If so, and the Exif metadata for the input image populates the orientation field, the
         * value of <code>OrientationCorrection</code> is null and the <code>FaceDetails</code> bounding box coordinates
         * represent face locations after Exif metadata is used to correct the image orientation. Images in .png format
         * don't contain Exif metadata.
         * </p>
         * </note>
         * 
         * @param orientationCorrection
         *        The orientation of the input image (counter-clockwise direction). If your application displays the
         *        image, you can use this value to correct image orientation. The bounding box coordinates returned in
         *        <code>FaceDetails</code> represent face locations before the image orientation is corrected. </p>
         *        <note>
         *        <p>
         *        If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that
         *        includes the image's orientation. If so, and the Exif metadata for the input image populates the
         *        orientation field, the value of <code>OrientationCorrection</code> is null and the
         *        <code>FaceDetails</code> bounding box coordinates represent face locations after Exif metadata is used
         *        to correct the image orientation. Images in .png format don't contain Exif metadata.
         *        </p>
         * @see OrientationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder orientationCorrection(String orientationCorrection);

        /**
         * <p>
         * The orientation of the input image (counter-clockwise direction). If your application displays the image, you
         * can use this value to correct image orientation. The bounding box coordinates returned in
         * <code>FaceDetails</code> represent face locations before the image orientation is corrected.
         * </p>
         * <note>
         * <p>
         * If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes the
         * image's orientation. If so, and the Exif metadata for the input image populates the orientation field, the
         * value of <code>OrientationCorrection</code> is null and the <code>FaceDetails</code> bounding box coordinates
         * represent face locations after Exif metadata is used to correct the image orientation. Images in .png format
         * don't contain Exif metadata.
         * </p>
         * </note>
         * 
         * @param orientationCorrection
         *        The orientation of the input image (counter-clockwise direction). If your application displays the
         *        image, you can use this value to correct image orientation. The bounding box coordinates returned in
         *        <code>FaceDetails</code> represent face locations before the image orientation is corrected. </p>
         *        <note>
         *        <p>
         *        If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that
         *        includes the image's orientation. If so, and the Exif metadata for the input image populates the
         *        orientation field, the value of <code>OrientationCorrection</code> is null and the
         *        <code>FaceDetails</code> bounding box coordinates represent face locations after Exif metadata is used
         *        to correct the image orientation. Images in .png format don't contain Exif metadata.
         *        </p>
         * @see OrientationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder orientationCorrection(OrientationCorrection orientationCorrection);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<FaceDetail> faceDetails;

        private String orientationCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectFacesResponse model) {
            faceDetails(model.faceDetails);
            orientationCorrection(model.orientationCorrection);
        }

        public final Collection<FaceDetail.Builder> getFaceDetails() {
            return faceDetails != null ? faceDetails.stream().map(FaceDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder faceDetails(Collection<FaceDetail> faceDetails) {
            this.faceDetails = FaceDetailListCopier.copy(faceDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceDetails(FaceDetail... faceDetails) {
            faceDetails(Arrays.asList(faceDetails));
            return this;
        }

        public final void setFaceDetails(Collection<FaceDetail.BuilderImpl> faceDetails) {
            this.faceDetails = FaceDetailListCopier.copyFromBuilder(faceDetails);
        }

        public final String getOrientationCorrection() {
            return orientationCorrection;
        }

        @Override
        public final Builder orientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
            return this;
        }

        @Override
        public final Builder orientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection.toString());
            return this;
        }

        public final void setOrientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
        }

        @Override
        public DetectFacesResponse build() {
            return new DetectFacesResponse(this);
        }
    }
}
