/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.EyeOpenMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates whether or not the eyes on the face are open, and the confidence level in the determination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class EyeOpen implements StructuredPojo, ToCopyableBuilder<EyeOpen.Builder, EyeOpen> {
    private final Boolean value;

    private final Float confidence;

    private EyeOpen(BuilderImpl builder) {
        this.value = builder.value;
        this.confidence = builder.confidence;
    }

    /**
     * <p>
     * Boolean value that indicates whether the eyes on the face are open.
     * </p>
     * 
     * @return Boolean value that indicates whether the eyes on the face are open.
     */
    public Boolean value() {
        return value;
    }

    /**
     * <p>
     * Level of confidence in the determination.
     * </p>
     * 
     * @return Level of confidence in the determination.
     */
    public Float confidence() {
        return confidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EyeOpen)) {
            return false;
        }
        EyeOpen other = (EyeOpen) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(confidence(), other.confidence());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (value() != null) {
            sb.append("Value: ").append(value()).append(",");
        }
        if (confidence() != null) {
            sb.append("Confidence: ").append(confidence()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.of(clazz.cast(value()));
        case "Confidence":
            return Optional.of(clazz.cast(confidence()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EyeOpenMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, EyeOpen> {
        /**
         * <p>
         * Boolean value that indicates whether the eyes on the face are open.
         * </p>
         * 
         * @param value
         *        Boolean value that indicates whether the eyes on the face are open.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Boolean value);

        /**
         * <p>
         * Level of confidence in the determination.
         * </p>
         * 
         * @param confidence
         *        Level of confidence in the determination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);
    }

    static final class BuilderImpl implements Builder {
        private Boolean value;

        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(EyeOpen model) {
            value(model.value);
            confidence(model.confidence);
        }

        public final Boolean getValue() {
            return value;
        }

        @Override
        public final Builder value(Boolean value) {
            this.value = value;
            return this;
        }

        public final void setValue(Boolean value) {
            this.value = value;
        }

        public final Float getConfidence() {
            return confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public EyeOpen build() {
            return new EyeOpen(this);
        }
    }
}
