/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.rekognition.model.Attribute;
import software.amazon.awssdk.services.rekognition.model.AttributesCopier;
import software.amazon.awssdk.services.rekognition.model.Image;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DetectFacesRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, DetectFacesRequest> {
    private final Image image;
    private final List<String> attributes;

    private DetectFacesRequest(BuilderImpl builder) {
        super(builder);
        this.image = builder.image;
        this.attributes = builder.attributes;
    }

    public Image image() {
        return this.image;
    }

    public List<Attribute> attributes() {
        return TypeConverter.convert(this.attributes, Attribute::fromValue);
    }

    public List<String> attributesStrings() {
        return this.attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributesStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectFacesRequest)) {
            return false;
        }
        DetectFacesRequest other = (DetectFacesRequest)((Object)obj);
        return Objects.equals(this.image(), other.image()) && Objects.equals(this.attributesStrings(), other.attributesStrings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.image() != null) {
            sb.append("Image: ").append(this.image()).append(",");
        }
        if (this.attributesStrings() != null) {
            sb.append("Attributes: ").append(this.attributesStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Image": {
                return Optional.of(clazz.cast(this.image()));
            }
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributesStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private Image image;
        private List<String> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectFacesRequest model) {
            this.image(model.image);
            this.attributes(model.attributes);
        }

        public final Image.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        public final Collection<String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Collection<String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(String ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DetectFacesRequest build() {
            return new DetectFacesRequest(this);
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    CopyableBuilder<Builder, DetectFacesRequest> {
        public Builder image(Image var1);

        default public Builder image(Consumer<Image.Builder> image) {
            return this.image((Image)((Image.Builder)Image.builder().apply(image)).build());
        }

        public Builder attributes(Collection<String> var1);

        public Builder attributes(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

