/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.rekognition.model.FaceMatch;
import software.amazon.awssdk.services.rekognition.model.FaceMatchListCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SearchFacesResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, SearchFacesResponse> {
    private final String searchedFaceId;
    private final List<FaceMatch> faceMatches;

    private SearchFacesResponse(BuilderImpl builder) {
        super(builder);
        this.searchedFaceId = builder.searchedFaceId;
        this.faceMatches = builder.faceMatches;
    }

    public String searchedFaceId() {
        return this.searchedFaceId;
    }

    public List<FaceMatch> faceMatches() {
        return this.faceMatches;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.searchedFaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceMatches());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFacesResponse)) {
            return false;
        }
        SearchFacesResponse other = (SearchFacesResponse)((Object)obj);
        return Objects.equals(this.searchedFaceId(), other.searchedFaceId()) && Objects.equals(this.faceMatches(), other.faceMatches());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.searchedFaceId() != null) {
            sb.append("SearchedFaceId: ").append(this.searchedFaceId()).append(",");
        }
        if (this.faceMatches() != null) {
            sb.append("FaceMatches: ").append(this.faceMatches()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SearchedFaceId": {
                return Optional.of(clazz.cast(this.searchedFaceId()));
            }
            case "FaceMatches": {
                return Optional.of(clazz.cast(this.faceMatches()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private String searchedFaceId;
        private List<FaceMatch> faceMatches;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFacesResponse model) {
            this.searchedFaceId(model.searchedFaceId);
            this.faceMatches(model.faceMatches);
        }

        public final String getSearchedFaceId() {
            return this.searchedFaceId;
        }

        @Override
        public final Builder searchedFaceId(String searchedFaceId) {
            this.searchedFaceId = searchedFaceId;
            return this;
        }

        public final void setSearchedFaceId(String searchedFaceId) {
            this.searchedFaceId = searchedFaceId;
        }

        public final Collection<FaceMatch.Builder> getFaceMatches() {
            return this.faceMatches != null ? (Collection)this.faceMatches.stream().map(FaceMatch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder faceMatches(Collection<FaceMatch> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copy(faceMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(FaceMatch ... faceMatches) {
            this.faceMatches(Arrays.asList(faceMatches));
            return this;
        }

        public final void setFaceMatches(Collection<FaceMatch.BuilderImpl> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copyFromBuilder(faceMatches);
        }

        @Override
        public SearchFacesResponse build() {
            return new SearchFacesResponse(this);
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    CopyableBuilder<Builder, SearchFacesResponse> {
        public Builder searchedFaceId(String var1);

        public Builder faceMatches(Collection<FaceMatch> var1);

        public Builder faceMatches(FaceMatch ... var1);
    }
}

