/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.rekognition.model.Eyeglasses;

@SdkInternalApi
public class EyeglassesMarshaller {
    private static final MarshallingInfo<Boolean> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final MarshallingInfo<Float> CONFIDENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Confidence").build();
    private static final EyeglassesMarshaller INSTANCE = new EyeglassesMarshaller();

    public static EyeglassesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Eyeglasses eyeglasses, ProtocolMarshaller protocolMarshaller) {
        if (eyeglasses == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)eyeglasses.value(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)eyeglasses.confidence(), CONFIDENCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

