/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.rekognition.model.Landmark;

@SdkInternalApi
public class LandmarkMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<Float> X_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("X").build();
    private static final MarshallingInfo<Float> Y_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Y").build();
    private static final LandmarkMarshaller INSTANCE = new LandmarkMarshaller();

    public static LandmarkMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Landmark landmark, ProtocolMarshaller protocolMarshaller) {
        if (landmark == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)landmark.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)landmark.x(), X_BINDING);
            protocolMarshaller.marshall((Object)landmark.y(), Y_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

