/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteFacesRequest extends RekognitionRequest implements
        ToCopyableBuilder<DeleteFacesRequest.Builder, DeleteFacesRequest> {
    private final String collectionId;

    private final List<String> faceIds;

    private DeleteFacesRequest(BuilderImpl builder) {
        super(builder);
        this.collectionId = builder.collectionId;
        this.faceIds = builder.faceIds;
    }

    /**
     * <p>
     * Collection from which to remove the specific faces.
     * </p>
     * 
     * @return Collection from which to remove the specific faces.
     */
    public String collectionId() {
        return collectionId;
    }

    /**
     * <p>
     * An array of face IDs to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of face IDs to delete.
     */
    public List<String> faceIds() {
        return faceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(faceIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFacesRequest)) {
            return false;
        }
        DeleteFacesRequest other = (DeleteFacesRequest) obj;
        return Objects.equals(collectionId(), other.collectionId()) && Objects.equals(faceIds(), other.faceIds());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteFacesRequest").add("CollectionId", collectionId()).add("FaceIds", faceIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionId":
            return Optional.of(clazz.cast(collectionId()));
        case "FaceIds":
            return Optional.of(clazz.cast(faceIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends RekognitionRequest.Builder, CopyableBuilder<Builder, DeleteFacesRequest> {
        /**
         * <p>
         * Collection from which to remove the specific faces.
         * </p>
         * 
         * @param collectionId
         *        Collection from which to remove the specific faces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionId(String collectionId);

        /**
         * <p>
         * An array of face IDs to delete.
         * </p>
         * 
         * @param faceIds
         *        An array of face IDs to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceIds(Collection<String> faceIds);

        /**
         * <p>
         * An array of face IDs to delete.
         * </p>
         * 
         * @param faceIds
         *        An array of face IDs to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceIds(String... faceIds);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String collectionId;

        private List<String> faceIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFacesRequest model) {
            collectionId(model.collectionId);
            faceIds(model.faceIds);
        }

        public final String getCollectionId() {
            return collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        public final Collection<String> getFaceIds() {
            return faceIds;
        }

        @Override
        public final Builder faceIds(Collection<String> faceIds) {
            this.faceIds = FaceIdListCopier.copy(faceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceIds(String... faceIds) {
            faceIds(Arrays.asList(faceIds));
            return this;
        }

        public final void setFaceIds(Collection<String> faceIds) {
            this.faceIds = FaceIdListCopier.copy(faceIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteFacesRequest build() {
            return new DeleteFacesRequest(this);
        }
    }
}
