/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class IndexFacesRequest extends RekognitionRequest implements
        ToCopyableBuilder<IndexFacesRequest.Builder, IndexFacesRequest> {
    private final String collectionId;

    private final Image image;

    private final String externalImageId;

    private final List<String> detectionAttributes;

    private IndexFacesRequest(BuilderImpl builder) {
        super(builder);
        this.collectionId = builder.collectionId;
        this.image = builder.image;
        this.externalImageId = builder.externalImageId;
        this.detectionAttributes = builder.detectionAttributes;
    }

    /**
     * <p>
     * The ID of an existing collection to which you want to add the faces that are detected in the input images.
     * </p>
     * 
     * @return The ID of an existing collection to which you want to add the faces that are detected in the input
     *         images.
     */
    public String collectionId() {
        return collectionId;
    }

    /**
     * <p>
     * The input image as bytes or an S3 object.
     * </p>
     * 
     * @return The input image as bytes or an S3 object.
     */
    public Image image() {
        return image;
    }

    /**
     * <p>
     * ID you want to assign to all the faces detected in the image.
     * </p>
     * 
     * @return ID you want to assign to all the faces detected in the image.
     */
    public String externalImageId() {
        return externalImageId;
    }

    /**
     * <p>
     * An array of facial attributes that you want to be returned. This can be the default list of attributes or all
     * attributes. If you don't specify a value for <code>Attributes</code> or if you specify <code>["DEFAULT"]</code>,
     * the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>,
     * <code>Pose</code>, <code>Quality</code> and <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all
     * facial attributes are returned but the operation will take longer to complete.
     * </p>
     * <p>
     * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine which
     * attributes to return (in this case, all attributes).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of facial attributes that you want to be returned. This can be the default list of attributes or
     *         all attributes. If you don't specify a value for <code>Attributes</code> or if you specify
     *         <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
     *         <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code> and
     *         <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned but the
     *         operation will take longer to complete.</p>
     *         <p>
     *         If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
     *         determine which attributes to return (in this case, all attributes).
     */
    public List<Attribute> detectionAttributes() {
        return TypeConverter.convert(detectionAttributes, Attribute::fromValue);
    }

    /**
     * <p>
     * An array of facial attributes that you want to be returned. This can be the default list of attributes or all
     * attributes. If you don't specify a value for <code>Attributes</code> or if you specify <code>["DEFAULT"]</code>,
     * the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>,
     * <code>Pose</code>, <code>Quality</code> and <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all
     * facial attributes are returned but the operation will take longer to complete.
     * </p>
     * <p>
     * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine which
     * attributes to return (in this case, all attributes).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of facial attributes that you want to be returned. This can be the default list of attributes or
     *         all attributes. If you don't specify a value for <code>Attributes</code> or if you specify
     *         <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
     *         <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code> and
     *         <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned but the
     *         operation will take longer to complete.</p>
     *         <p>
     *         If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
     *         determine which attributes to return (in this case, all attributes).
     */
    public List<String> detectionAttributesStrings() {
        return detectionAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(externalImageId());
        hashCode = 31 * hashCode + Objects.hashCode(detectionAttributesStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexFacesRequest)) {
            return false;
        }
        IndexFacesRequest other = (IndexFacesRequest) obj;
        return Objects.equals(collectionId(), other.collectionId()) && Objects.equals(image(), other.image())
                && Objects.equals(externalImageId(), other.externalImageId())
                && Objects.equals(detectionAttributesStrings(), other.detectionAttributesStrings());
    }

    @Override
    public String toString() {
        return ToString.builder("IndexFacesRequest").add("CollectionId", collectionId()).add("Image", image())
                .add("ExternalImageId", externalImageId()).add("DetectionAttributes", detectionAttributesStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionId":
            return Optional.of(clazz.cast(collectionId()));
        case "Image":
            return Optional.of(clazz.cast(image()));
        case "ExternalImageId":
            return Optional.of(clazz.cast(externalImageId()));
        case "DetectionAttributes":
            return Optional.of(clazz.cast(detectionAttributesStrings()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends RekognitionRequest.Builder, CopyableBuilder<Builder, IndexFacesRequest> {
        /**
         * <p>
         * The ID of an existing collection to which you want to add the faces that are detected in the input images.
         * </p>
         * 
         * @param collectionId
         *        The ID of an existing collection to which you want to add the faces that are detected in the input
         *        images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionId(String collectionId);

        /**
         * <p>
         * The input image as bytes or an S3 object.
         * </p>
         * 
         * @param image
         *        The input image as bytes or an S3 object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(Image image);

        /**
         * <p>
         * The input image as bytes or an S3 object.
         * </p>
         * This is a convenience that creates an instance of the {@link Image.Builder} avoiding the need to create one
         * manually via {@link Image#builder()}.
         *
         * When the {@link Consumer} completes, {@link Image.Builder#build()} is called immediately and its result is
         * passed to {@link #image(Image)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link Image.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(Image)
         */
        default Builder image(Consumer<Image.Builder> image) {
            return image(Image.builder().apply(image).build());
        }

        /**
         * <p>
         * ID you want to assign to all the faces detected in the image.
         * </p>
         * 
         * @param externalImageId
         *        ID you want to assign to all the faces detected in the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalImageId(String externalImageId);

        /**
         * <p>
         * An array of facial attributes that you want to be returned. This can be the default list of attributes or all
         * attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         * <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code> and <code>Landmarks</code>. If you provide
         * <code>["ALL"]</code>, all facial attributes are returned but the operation will take longer to complete.
         * </p>
         * <p>
         * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine
         * which attributes to return (in this case, all attributes).
         * </p>
         * 
         * @param detectionAttributes
         *        An array of facial attributes that you want to be returned. This can be the default list of attributes
         *        or all attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         *        <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
         *        <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code> and
         *        <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned but
         *        the operation will take longer to complete.</p>
         *        <p>
         *        If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
         *        determine which attributes to return (in this case, all attributes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectionAttributes(Collection<String> detectionAttributes);

        /**
         * <p>
         * An array of facial attributes that you want to be returned. This can be the default list of attributes or all
         * attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         * <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code> and <code>Landmarks</code>. If you provide
         * <code>["ALL"]</code>, all facial attributes are returned but the operation will take longer to complete.
         * </p>
         * <p>
         * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine
         * which attributes to return (in this case, all attributes).
         * </p>
         * 
         * @param detectionAttributes
         *        An array of facial attributes that you want to be returned. This can be the default list of attributes
         *        or all attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         *        <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
         *        <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code> and
         *        <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned but
         *        the operation will take longer to complete.</p>
         *        <p>
         *        If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
         *        determine which attributes to return (in this case, all attributes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectionAttributes(String... detectionAttributes);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String collectionId;

        private Image image;

        private String externalImageId;

        private List<String> detectionAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexFacesRequest model) {
            collectionId(model.collectionId);
            image(model.image);
            externalImageId(model.externalImageId);
            detectionAttributes(model.detectionAttributes);
        }

        public final String getCollectionId() {
            return collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        public final Image.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        public final String getExternalImageId() {
            return externalImageId;
        }

        @Override
        public final Builder externalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
            return this;
        }

        public final void setExternalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
        }

        public final Collection<String> getDetectionAttributes() {
            return detectionAttributes;
        }

        @Override
        public final Builder detectionAttributes(Collection<String> detectionAttributes) {
            this.detectionAttributes = AttributesCopier.copy(detectionAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectionAttributes(String... detectionAttributes) {
            detectionAttributes(Arrays.asList(detectionAttributes));
            return this;
        }

        public final void setDetectionAttributes(Collection<String> detectionAttributes) {
            this.detectionAttributes = AttributesCopier.copy(detectionAttributes);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public IndexFacesRequest build() {
            return new IndexFacesRequest(this);
        }
    }
}
