/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.LandmarkMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates the location of the landmark on the face.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Landmark implements StructuredPojo, ToCopyableBuilder<Landmark.Builder, Landmark> {
    private final String type;

    private final Float x;

    private final Float y;

    private Landmark(BuilderImpl builder) {
        this.type = builder.type;
        this.x = builder.x;
        this.y = builder.y;
    }

    /**
     * <p>
     * Type of the landmark.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LandmarkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return Type of the landmark.
     * @see LandmarkType
     */
    public LandmarkType type() {
        return LandmarkType.fromValue(type);
    }

    /**
     * <p>
     * Type of the landmark.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LandmarkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return Type of the landmark.
     * @see LandmarkType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * x-coordinate from the top left of the landmark expressed as the ratio of the width of the image. For example, if
     * the images is 700x200 and the x-coordinate of the landmark is at 350 pixels, this value is 0.5.
     * </p>
     * 
     * @return x-coordinate from the top left of the landmark expressed as the ratio of the width of the image. For
     *         example, if the images is 700x200 and the x-coordinate of the landmark is at 350 pixels, this value is
     *         0.5.
     */
    public Float x() {
        return x;
    }

    /**
     * <p>
     * y-coordinate from the top left of the landmark expressed as the ratio of the height of the image. For example, if
     * the images is 700x200 and the y-coordinate of the landmark is at 100 pixels, this value is 0.5.
     * </p>
     * 
     * @return y-coordinate from the top left of the landmark expressed as the ratio of the height of the image. For
     *         example, if the images is 700x200 and the y-coordinate of the landmark is at 100 pixels, this value is
     *         0.5.
     */
    public Float y() {
        return y;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeString());
        hashCode = 31 * hashCode + Objects.hashCode(x());
        hashCode = 31 * hashCode + Objects.hashCode(y());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Landmark)) {
            return false;
        }
        Landmark other = (Landmark) obj;
        return Objects.equals(typeString(), other.typeString()) && Objects.equals(x(), other.x())
                && Objects.equals(y(), other.y());
    }

    @Override
    public String toString() {
        return ToString.builder("Landmark").add("Type", typeString()).add("X", x()).add("Y", y()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.of(clazz.cast(typeString()));
        case "X":
            return Optional.of(clazz.cast(x()));
        case "Y":
            return Optional.of(clazz.cast(y()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LandmarkMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Landmark> {
        /**
         * <p>
         * Type of the landmark.
         * </p>
         * 
         * @param type
         *        Type of the landmark.
         * @see LandmarkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LandmarkType
         */
        Builder type(String type);

        /**
         * <p>
         * Type of the landmark.
         * </p>
         * 
         * @param type
         *        Type of the landmark.
         * @see LandmarkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LandmarkType
         */
        Builder type(LandmarkType type);

        /**
         * <p>
         * x-coordinate from the top left of the landmark expressed as the ratio of the width of the image. For example,
         * if the images is 700x200 and the x-coordinate of the landmark is at 350 pixels, this value is 0.5.
         * </p>
         * 
         * @param x
         *        x-coordinate from the top left of the landmark expressed as the ratio of the width of the image. For
         *        example, if the images is 700x200 and the x-coordinate of the landmark is at 350 pixels, this value is
         *        0.5.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder x(Float x);

        /**
         * <p>
         * y-coordinate from the top left of the landmark expressed as the ratio of the height of the image. For
         * example, if the images is 700x200 and the y-coordinate of the landmark is at 100 pixels, this value is 0.5.
         * </p>
         * 
         * @param y
         *        y-coordinate from the top left of the landmark expressed as the ratio of the height of the image. For
         *        example, if the images is 700x200 and the y-coordinate of the landmark is at 100 pixels, this value is
         *        0.5.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder y(Float y);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Float x;

        private Float y;

        private BuilderImpl() {
        }

        private BuilderImpl(Landmark model) {
            type(model.type);
            x(model.x);
            y(model.y);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LandmarkType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Float getX() {
            return x;
        }

        @Override
        public final Builder x(Float x) {
            this.x = x;
            return this;
        }

        public final void setX(Float x) {
            this.x = x;
        }

        public final Float getY() {
            return y;
        }

        @Override
        public final Builder y(Float y) {
            this.y = y;
            return this;
        }

        public final void setY(Float y) {
            this.y = y;
        }

        @Override
        public Landmark build() {
            return new Landmark(this);
        }
    }
}
