/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListFacesRequest extends RekognitionRequest implements ToCopyableBuilder<ListFacesRequest.Builder, ListFacesRequest> {
    private final String collectionId;

    private final String nextToken;

    private final Integer maxResults;

    private ListFacesRequest(BuilderImpl builder) {
        super(builder);
        this.collectionId = builder.collectionId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * ID of the collection from which to list the faces.
     * </p>
     * 
     * @return ID of the collection from which to list the faces.
     */
    public String collectionId() {
        return collectionId;
    }

    /**
     * <p>
     * If the previous response was incomplete (because there is more data to retrieve), Amazon Rekognition returns a
     * pagination token in the response. You can use this pagination token to retrieve the next set of faces.
     * </p>
     * 
     * @return If the previous response was incomplete (because there is more data to retrieve), Amazon Rekognition
     *         returns a pagination token in the response. You can use this pagination token to retrieve the next set of
     *         faces.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Maximum number of faces to return.
     * </p>
     * 
     * @return Maximum number of faces to return.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFacesRequest)) {
            return false;
        }
        ListFacesRequest other = (ListFacesRequest) obj;
        return Objects.equals(collectionId(), other.collectionId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    @Override
    public String toString() {
        return ToString.builder("ListFacesRequest").add("CollectionId", collectionId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionId":
            return Optional.of(clazz.cast(collectionId()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends RekognitionRequest.Builder, CopyableBuilder<Builder, ListFacesRequest> {
        /**
         * <p>
         * ID of the collection from which to list the faces.
         * </p>
         * 
         * @param collectionId
         *        ID of the collection from which to list the faces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionId(String collectionId);

        /**
         * <p>
         * If the previous response was incomplete (because there is more data to retrieve), Amazon Rekognition returns
         * a pagination token in the response. You can use this pagination token to retrieve the next set of faces.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was incomplete (because there is more data to retrieve), Amazon Rekognition
         *        returns a pagination token in the response. You can use this pagination token to retrieve the next set
         *        of faces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Maximum number of faces to return.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of faces to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String collectionId;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFacesRequest model) {
            collectionId(model.collectionId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getCollectionId() {
            return collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListFacesRequest build() {
            return new ListFacesRequest(this);
        }
    }
}
