/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.GenderMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Gender of the face and the confidence level in the determination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Gender implements StructuredPojo, ToCopyableBuilder<Gender.Builder, Gender> {
    private final String value;

    private final Float confidence;

    private Gender(BuilderImpl builder) {
        this.value = builder.value;
        this.confidence = builder.confidence;
    }

    /**
     * <p>
     * Gender of the face.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #value} will return
     * {@link GenderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #valueString}.
     * </p>
     * 
     * @return Gender of the face.
     * @see GenderType
     */
    public GenderType value() {
        return GenderType.fromValue(value);
    }

    /**
     * <p>
     * Gender of the face.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #value} will return
     * {@link GenderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #valueString}.
     * </p>
     * 
     * @return Gender of the face.
     * @see GenderType
     */
    public String valueString() {
        return value;
    }

    /**
     * <p>
     * Level of confidence in the determination.
     * </p>
     * 
     * @return Level of confidence in the determination.
     */
    public Float confidence() {
        return confidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(valueString());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Gender)) {
            return false;
        }
        Gender other = (Gender) obj;
        return Objects.equals(valueString(), other.valueString()) && Objects.equals(confidence(), other.confidence());
    }

    @Override
    public String toString() {
        return ToString.builder("Gender").add("Value", valueString()).add("Confidence", confidence()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.of(clazz.cast(valueString()));
        case "Confidence":
            return Optional.of(clazz.cast(confidence()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GenderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Gender> {
        /**
         * <p>
         * Gender of the face.
         * </p>
         * 
         * @param value
         *        Gender of the face.
         * @see GenderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GenderType
         */
        Builder value(String value);

        /**
         * <p>
         * Gender of the face.
         * </p>
         * 
         * @param value
         *        Gender of the face.
         * @see GenderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GenderType
         */
        Builder value(GenderType value);

        /**
         * <p>
         * Level of confidence in the determination.
         * </p>
         * 
         * @param confidence
         *        Level of confidence in the determination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);
    }

    static final class BuilderImpl implements Builder {
        private String value;

        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(Gender model) {
            value(model.value);
            confidence(model.confidence);
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public final Builder value(GenderType value) {
            this.value(value.toString());
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Float getConfidence() {
            return confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public Gender build() {
            return new Gender(this);
        }
    }
}
