/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SearchFacesResponse extends RekognitionResponse implements
        ToCopyableBuilder<SearchFacesResponse.Builder, SearchFacesResponse> {
    private final String searchedFaceId;

    private final List<FaceMatch> faceMatches;

    private SearchFacesResponse(BuilderImpl builder) {
        super(builder);
        this.searchedFaceId = builder.searchedFaceId;
        this.faceMatches = builder.faceMatches;
    }

    /**
     * <p>
     * ID of the face that was searched for matches in a collection.
     * </p>
     * 
     * @return ID of the face that was searched for matches in a collection.
     */
    public String searchedFaceId() {
        return searchedFaceId;
    }

    /**
     * <p>
     * An array of faces that matched the input face, along with the confidence in the match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of faces that matched the input face, along with the confidence in the match.
     */
    public List<FaceMatch> faceMatches() {
        return faceMatches;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(searchedFaceId());
        hashCode = 31 * hashCode + Objects.hashCode(faceMatches());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFacesResponse)) {
            return false;
        }
        SearchFacesResponse other = (SearchFacesResponse) obj;
        return Objects.equals(searchedFaceId(), other.searchedFaceId()) && Objects.equals(faceMatches(), other.faceMatches());
    }

    @Override
    public String toString() {
        return ToString.builder("SearchFacesResponse").add("SearchedFaceId", searchedFaceId()).add("FaceMatches", faceMatches())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SearchedFaceId":
            return Optional.of(clazz.cast(searchedFaceId()));
        case "FaceMatches":
            return Optional.of(clazz.cast(faceMatches()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends RekognitionResponse.Builder, CopyableBuilder<Builder, SearchFacesResponse> {
        /**
         * <p>
         * ID of the face that was searched for matches in a collection.
         * </p>
         * 
         * @param searchedFaceId
         *        ID of the face that was searched for matches in a collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchedFaceId(String searchedFaceId);

        /**
         * <p>
         * An array of faces that matched the input face, along with the confidence in the match.
         * </p>
         * 
         * @param faceMatches
         *        An array of faces that matched the input face, along with the confidence in the match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceMatches(Collection<FaceMatch> faceMatches);

        /**
         * <p>
         * An array of faces that matched the input face, along with the confidence in the match.
         * </p>
         * 
         * @param faceMatches
         *        An array of faces that matched the input face, along with the confidence in the match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceMatches(FaceMatch... faceMatches);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private String searchedFaceId;

        private List<FaceMatch> faceMatches;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFacesResponse model) {
            searchedFaceId(model.searchedFaceId);
            faceMatches(model.faceMatches);
        }

        public final String getSearchedFaceId() {
            return searchedFaceId;
        }

        @Override
        public final Builder searchedFaceId(String searchedFaceId) {
            this.searchedFaceId = searchedFaceId;
            return this;
        }

        public final void setSearchedFaceId(String searchedFaceId) {
            this.searchedFaceId = searchedFaceId;
        }

        public final Collection<FaceMatch.Builder> getFaceMatches() {
            return faceMatches != null ? faceMatches.stream().map(FaceMatch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder faceMatches(Collection<FaceMatch> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copy(faceMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(FaceMatch... faceMatches) {
            faceMatches(Arrays.asList(faceMatches));
            return this;
        }

        public final void setFaceMatches(Collection<FaceMatch.BuilderImpl> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copyFromBuilder(faceMatches);
        }

        @Override
        public SearchFacesResponse build() {
            return new SearchFacesResponse(this);
        }
    }
}
