/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.ComparedFace;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ComparedFaceMarshaller {
    private static final MarshallingInfo<StructuredPojo> BOUNDINGBOX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BoundingBox").isBinary(false).build();
    private static final MarshallingInfo<Float> CONFIDENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Confidence").isBinary(false).build();
    private static final MarshallingInfo<List> LANDMARKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Landmarks").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> POSE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Pose").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> QUALITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Quality").isBinary(false).build();
    private static final ComparedFaceMarshaller INSTANCE = new ComparedFaceMarshaller();

    private ComparedFaceMarshaller() {
    }

    public static ComparedFaceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ComparedFace comparedFace, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)comparedFace, (String)"comparedFace");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)comparedFace.boundingBox(), BOUNDINGBOX_BINDING);
            protocolMarshaller.marshall((Object)comparedFace.confidence(), CONFIDENCE_BINDING);
            protocolMarshaller.marshall(comparedFace.landmarks(), LANDMARKS_BINDING);
            protocolMarshaller.marshall((Object)comparedFace.pose(), POSE_BINDING);
            protocolMarshaller.marshall((Object)comparedFace.quality(), QUALITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

