/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.Face;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FaceMarshaller {
    private static final MarshallingInfo<String> FACEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FaceId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> BOUNDINGBOX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BoundingBox").isBinary(false).build();
    private static final MarshallingInfo<String> IMAGEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageId").isBinary(false).build();
    private static final MarshallingInfo<String> EXTERNALIMAGEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExternalImageId").isBinary(false).build();
    private static final MarshallingInfo<Float> CONFIDENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Confidence").isBinary(false).build();
    private static final FaceMarshaller INSTANCE = new FaceMarshaller();

    private FaceMarshaller() {
    }

    public static FaceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Face face, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)face, (String)"face");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)face.faceId(), FACEID_BINDING);
            protocolMarshaller.marshall((Object)face.boundingBox(), BOUNDINGBOX_BINDING);
            protocolMarshaller.marshall((Object)face.imageId(), IMAGEID_BINDING);
            protocolMarshaller.marshall((Object)face.externalImageId(), EXTERNALIMAGEID_BINDING);
            protocolMarshaller.marshall((Object)face.confidence(), CONFIDENCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

