/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import java.nio.ByteBuffer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.Image;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ImageMarshaller {
    private static final MarshallingInfo<ByteBuffer> BYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Bytes").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> S3OBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Object").isBinary(false).build();
    private static final ImageMarshaller INSTANCE = new ImageMarshaller();

    private ImageMarshaller() {
    }

    public static ImageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Image image, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)image, (String)"image");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)image.bytes(), BYTES_BINDING);
            protocolMarshaller.marshall((Object)image.s3Object(), S3OBJECT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

