/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.IndexFacesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class IndexFacesRequestModelMarshaller {
    private static final MarshallingInfo<String> COLLECTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CollectionId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> IMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Image").isBinary(false).build();
    private static final MarshallingInfo<String> EXTERNALIMAGEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExternalImageId").isBinary(false).build();
    private static final MarshallingInfo<List> DETECTIONATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DetectionAttributes").isBinary(false).build();
    private static final IndexFacesRequestModelMarshaller INSTANCE = new IndexFacesRequestModelMarshaller();

    private IndexFacesRequestModelMarshaller() {
    }

    public static IndexFacesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(IndexFacesRequest indexFacesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)indexFacesRequest), (String)"indexFacesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)indexFacesRequest.collectionId(), COLLECTIONID_BINDING);
            protocolMarshaller.marshall((Object)indexFacesRequest.image(), IMAGE_BINDING);
            protocolMarshaller.marshall((Object)indexFacesRequest.externalImageId(), EXTERNALIMAGEID_BINDING);
            protocolMarshaller.marshall(indexFacesRequest.detectionAttributesStrings(), DETECTIONATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

