/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.rekognition.model.Pose;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PoseMarshaller {
    private static final MarshallingInfo<Float> ROLL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Roll").isBinary(false).build();
    private static final MarshallingInfo<Float> YAW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Yaw").isBinary(false).build();
    private static final MarshallingInfo<Float> PITCH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Pitch").isBinary(false).build();
    private static final PoseMarshaller INSTANCE = new PoseMarshaller();

    private PoseMarshaller() {
    }

    public static PoseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Pose pose, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)pose, (String)"pose");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)pose.roll(), ROLL_BINDING);
            protocolMarshaller.marshall((Object)pose.yaw(), YAW_BINDING);
            protocolMarshaller.marshall((Object)pose.pitch(), PITCH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

