/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.SearchFacesByImageRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SearchFacesByImageRequestModelMarshaller {
    private static final MarshallingInfo<String> COLLECTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CollectionId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> IMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Image").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXFACES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxFaces").isBinary(false).build();
    private static final MarshallingInfo<Float> FACEMATCHTHRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FaceMatchThreshold").isBinary(false).build();
    private static final SearchFacesByImageRequestModelMarshaller INSTANCE = new SearchFacesByImageRequestModelMarshaller();

    private SearchFacesByImageRequestModelMarshaller() {
    }

    public static SearchFacesByImageRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SearchFacesByImageRequest searchFacesByImageRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)searchFacesByImageRequest), (String)"searchFacesByImageRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)searchFacesByImageRequest.collectionId(), COLLECTIONID_BINDING);
            protocolMarshaller.marshall((Object)searchFacesByImageRequest.image(), IMAGE_BINDING);
            protocolMarshaller.marshall((Object)searchFacesByImageRequest.maxFaces(), MAXFACES_BINDING);
            protocolMarshaller.marshall((Object)searchFacesByImageRequest.faceMatchThreshold(), FACEMATCHTHRESHOLD_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

