/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.rekognition.model.CompareFacesRequest;
import software.amazon.awssdk.services.rekognition.model.CompareFacesResponse;
import software.amazon.awssdk.services.rekognition.model.CreateCollectionRequest;
import software.amazon.awssdk.services.rekognition.model.CreateCollectionResponse;
import software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteCollectionRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteCollectionResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteFacesRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteFacesResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.DescribeCollectionRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeCollectionResponse;
import software.amazon.awssdk.services.rekognition.model.DescribeStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.DetectFacesRequest;
import software.amazon.awssdk.services.rekognition.model.DetectFacesResponse;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsResponse;
import software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsRequest;
import software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsResponse;
import software.amazon.awssdk.services.rekognition.model.DetectTextRequest;
import software.amazon.awssdk.services.rekognition.model.DetectTextResponse;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoRequest;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoResponse;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionRequest;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionResponse;
import software.amazon.awssdk.services.rekognition.model.GetContentModerationRequest;
import software.amazon.awssdk.services.rekognition.model.GetContentModerationResponse;
import software.amazon.awssdk.services.rekognition.model.GetFaceDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.GetFaceDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.GetFaceSearchRequest;
import software.amazon.awssdk.services.rekognition.model.GetFaceSearchResponse;
import software.amazon.awssdk.services.rekognition.model.GetLabelDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.GetLabelDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.GetPersonTrackingRequest;
import software.amazon.awssdk.services.rekognition.model.GetPersonTrackingResponse;
import software.amazon.awssdk.services.rekognition.model.IndexFacesRequest;
import software.amazon.awssdk.services.rekognition.model.IndexFacesResponse;
import software.amazon.awssdk.services.rekognition.model.ListCollectionsRequest;
import software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse;
import software.amazon.awssdk.services.rekognition.model.ListFacesRequest;
import software.amazon.awssdk.services.rekognition.model.ListFacesResponse;
import software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsRequest;
import software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsResponse;
import software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesRequest;
import software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesResponse;
import software.amazon.awssdk.services.rekognition.model.SearchFacesByImageRequest;
import software.amazon.awssdk.services.rekognition.model.SearchFacesByImageResponse;
import software.amazon.awssdk.services.rekognition.model.SearchFacesRequest;
import software.amazon.awssdk.services.rekognition.model.SearchFacesResponse;
import software.amazon.awssdk.services.rekognition.model.StartCelebrityRecognitionRequest;
import software.amazon.awssdk.services.rekognition.model.StartCelebrityRecognitionResponse;
import software.amazon.awssdk.services.rekognition.model.StartContentModerationRequest;
import software.amazon.awssdk.services.rekognition.model.StartContentModerationResponse;
import software.amazon.awssdk.services.rekognition.model.StartFaceDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.StartFaceDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.StartFaceSearchRequest;
import software.amazon.awssdk.services.rekognition.model.StartFaceSearchResponse;
import software.amazon.awssdk.services.rekognition.model.StartLabelDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.StartLabelDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.StartPersonTrackingRequest;
import software.amazon.awssdk.services.rekognition.model.StartPersonTrackingResponse;
import software.amazon.awssdk.services.rekognition.model.StartStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.StartStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.StopStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.StopStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.paginators.GetCelebrityRecognitionPublisher;
import software.amazon.awssdk.services.rekognition.paginators.GetContentModerationPublisher;
import software.amazon.awssdk.services.rekognition.paginators.GetFaceDetectionPublisher;
import software.amazon.awssdk.services.rekognition.paginators.GetFaceSearchPublisher;
import software.amazon.awssdk.services.rekognition.paginators.GetLabelDetectionPublisher;
import software.amazon.awssdk.services.rekognition.paginators.GetPersonTrackingPublisher;
import software.amazon.awssdk.services.rekognition.paginators.ListCollectionsPublisher;
import software.amazon.awssdk.services.rekognition.paginators.ListFacesPublisher;
import software.amazon.awssdk.services.rekognition.paginators.ListStreamProcessorsPublisher;

/**
 * Service client for accessing Amazon Rekognition asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * This is the Amazon Rekognition API reference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface RekognitionAsyncClient extends SdkClient {
    String SERVICE_NAME = "rekognition";

    /**
     * Create a {@link RekognitionAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static RekognitionAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link RekognitionAsyncClient}.
     */
    static RekognitionAsyncClientBuilder builder() {
        return new DefaultRekognitionAsyncClientBuilder();
    }

    /**
     * <p>
     * Compares a face in the <i>source</i> input image with each of the 100 largest faces detected in the <i>target</i>
     * input image.
     * </p>
     * <note>
     * <p>
     * If the source image contains multiple faces, the service detects the largest face and compares it with each face
     * detected in the target image.
     * </p>
     * </note>
     * <p>
     * You pass the input and target images either as base64-encoded image bytes or as references to images in an Amazon
     * S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes isn't supported. The
     * image must be formatted as a PNG or JPEG file.
     * </p>
     * <p>
     * In response, the operation returns an array of face matches ordered by similarity score in descending order. For
     * each face match, the response provides a bounding box of the face, facial landmarks, pose details (pitch, role,
     * and yaw), quality (brightness and sharpness), and confidence value (indicating the level of confidence that the
     * bounding box contains a face). The response also provides a similarity score, which indicates how closely the
     * faces match.
     * </p>
     * <note>
     * <p>
     * By default, only faces with a similarity score of greater than or equal to 80% are returned in the response. You
     * can change this value by specifying the <code>SimilarityThreshold</code> parameter.
     * </p>
     * </note>
     * <p>
     * <code>CompareFaces</code> also returns an array of faces that don't match the source image. For each face, it
     * returns a bounding box, confidence value, landmarks, pose details, and quality. The response also returns
     * information about the face in the source image, including the bounding box of the face and confidence value.
     * </p>
     * <p>
     * If the image doesn't contain Exif metadata, <code>CompareFaces</code> returns orientation information for the
     * source and target images. Use these values to display the images with the correct image orientation.
     * </p>
     * <p>
     * If no faces are detected in the source or target images, <code>CompareFaces</code> returns an
     * <code>InvalidParameterException</code> error.
     * </p>
     * <note>
     * <p>
     * This is a stateless API operation. That is, data returned by this operation doesn't persist.
     * </p>
     * </note>
     * <p>
     * For an example, see Comparing Faces in Images in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:CompareFaces</code> action.
     * </p>
     *
     * @param compareFacesRequest
     * @return A Java Future containing the result of the CompareFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. For more information, see
     *         Limits in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.CompareFaces
     */
    default CompletableFuture<CompareFacesResponse> compareFaces(CompareFacesRequest compareFacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Compares a face in the <i>source</i> input image with each of the 100 largest faces detected in the <i>target</i>
     * input image.
     * </p>
     * <note>
     * <p>
     * If the source image contains multiple faces, the service detects the largest face and compares it with each face
     * detected in the target image.
     * </p>
     * </note>
     * <p>
     * You pass the input and target images either as base64-encoded image bytes or as references to images in an Amazon
     * S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes isn't supported. The
     * image must be formatted as a PNG or JPEG file.
     * </p>
     * <p>
     * In response, the operation returns an array of face matches ordered by similarity score in descending order. For
     * each face match, the response provides a bounding box of the face, facial landmarks, pose details (pitch, role,
     * and yaw), quality (brightness and sharpness), and confidence value (indicating the level of confidence that the
     * bounding box contains a face). The response also provides a similarity score, which indicates how closely the
     * faces match.
     * </p>
     * <note>
     * <p>
     * By default, only faces with a similarity score of greater than or equal to 80% are returned in the response. You
     * can change this value by specifying the <code>SimilarityThreshold</code> parameter.
     * </p>
     * </note>
     * <p>
     * <code>CompareFaces</code> also returns an array of faces that don't match the source image. For each face, it
     * returns a bounding box, confidence value, landmarks, pose details, and quality. The response also returns
     * information about the face in the source image, including the bounding box of the face and confidence value.
     * </p>
     * <p>
     * If the image doesn't contain Exif metadata, <code>CompareFaces</code> returns orientation information for the
     * source and target images. Use these values to display the images with the correct image orientation.
     * </p>
     * <p>
     * If no faces are detected in the source or target images, <code>CompareFaces</code> returns an
     * <code>InvalidParameterException</code> error.
     * </p>
     * <note>
     * <p>
     * This is a stateless API operation. That is, data returned by this operation doesn't persist.
     * </p>
     * </note>
     * <p>
     * For an example, see Comparing Faces in Images in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:CompareFaces</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CompareFacesRequest.Builder} avoiding the need to
     * create one manually via {@link CompareFacesRequest#builder()}
     * </p>
     *
     * @param compareFacesRequest
     *        A {@link Consumer} that will call methods on {@link CompareFacesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CompareFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. For more information, see
     *         Limits in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.CompareFaces
     */
    default CompletableFuture<CompareFacesResponse> compareFaces(Consumer<CompareFacesRequest.Builder> compareFacesRequest) {
        return compareFaces(CompareFacesRequest.builder().applyMutation(compareFacesRequest).build());
    }

    /**
     * <p>
     * Creates a collection in an AWS Region. You can add faces to the collection using the operation.
     * </p>
     * <p>
     * For example, you might create collections, one for each of your application users. A user can then index faces
     * using the <code>IndexFaces</code> operation and persist results in a specific collection. Then, a user can search
     * the collection for faces in the user-specific container.
     * </p>
     * <note>
     * <p>
     * Collection names are case-sensitive.
     * </p>
     * </note>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:CreateCollection</code> action.
     * </p>
     *
     * @param createCollectionRequest
     * @return A Java Future containing the result of the CreateCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceAlreadyExistsException A collection with the specified ID already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.CreateCollection
     */
    default CompletableFuture<CreateCollectionResponse> createCollection(CreateCollectionRequest createCollectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a collection in an AWS Region. You can add faces to the collection using the operation.
     * </p>
     * <p>
     * For example, you might create collections, one for each of your application users. A user can then index faces
     * using the <code>IndexFaces</code> operation and persist results in a specific collection. Then, a user can search
     * the collection for faces in the user-specific container.
     * </p>
     * <note>
     * <p>
     * Collection names are case-sensitive.
     * </p>
     * </note>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:CreateCollection</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCollectionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateCollectionRequest#builder()}
     * </p>
     *
     * @param createCollectionRequest
     *        A {@link Consumer} that will call methods on {@link CreateCollectionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceAlreadyExistsException A collection with the specified ID already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.CreateCollection
     */
    default CompletableFuture<CreateCollectionResponse> createCollection(
            Consumer<CreateCollectionRequest.Builder> createCollectionRequest) {
        return createCollection(CreateCollectionRequest.builder().applyMutation(createCollectionRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Rekognition stream processor that you can use to detect and recognize faces in a streaming
     * video.
     * </p>
     * <p>
     * Amazon Rekognition Video is a consumer of live video from Amazon Kinesis Video Streams. Amazon Rekognition Video
     * sends analysis results to Amazon Kinesis Data Streams.
     * </p>
     * <p>
     * You provide as input a Kinesis video stream (<code>Input</code>) and a Kinesis data stream (<code>Output</code>)
     * stream. You also specify the face recognition criteria in <code>Settings</code>. For example, the collection
     * containing faces that you want to recognize. Use <code>Name</code> to assign an identifier for the stream
     * processor. You use <code>Name</code> to manage the stream processor. For example, you can start processing the
     * source video by calling with the <code>Name</code> field.
     * </p>
     * <p>
     * After you have finished analyzing a streaming video, use to stop processing. You can delete the stream processor
     * by calling .
     * </p>
     *
     * @param createStreamProcessorRequest
     * @return A Java Future containing the result of the CreateStreamProcessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many Amazon Rekognition Video jobs concurrently, calls to start operations (
     *         <code>StartLabelDetection</code>, for example) will raise a <code>LimitExceededException</code> exception
     *         (HTTP status code: 400) until the number of concurrently running jobs is below the Amazon Rekognition
     *         service limit.</li>
     *         <li>ResourceInUseException</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.CreateStreamProcessor
     */
    default CompletableFuture<CreateStreamProcessorResponse> createStreamProcessor(
            CreateStreamProcessorRequest createStreamProcessorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Rekognition stream processor that you can use to detect and recognize faces in a streaming
     * video.
     * </p>
     * <p>
     * Amazon Rekognition Video is a consumer of live video from Amazon Kinesis Video Streams. Amazon Rekognition Video
     * sends analysis results to Amazon Kinesis Data Streams.
     * </p>
     * <p>
     * You provide as input a Kinesis video stream (<code>Input</code>) and a Kinesis data stream (<code>Output</code>)
     * stream. You also specify the face recognition criteria in <code>Settings</code>. For example, the collection
     * containing faces that you want to recognize. Use <code>Name</code> to assign an identifier for the stream
     * processor. You use <code>Name</code> to manage the stream processor. For example, you can start processing the
     * source video by calling with the <code>Name</code> field.
     * </p>
     * <p>
     * After you have finished analyzing a streaming video, use to stop processing. You can delete the stream processor
     * by calling .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStreamProcessorRequest.Builder} avoiding the
     * need to create one manually via {@link CreateStreamProcessorRequest#builder()}
     * </p>
     *
     * @param createStreamProcessorRequest
     *        A {@link Consumer} that will call methods on {@link CreateStreamProcessorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateStreamProcessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many Amazon Rekognition Video jobs concurrently, calls to start operations (
     *         <code>StartLabelDetection</code>, for example) will raise a <code>LimitExceededException</code> exception
     *         (HTTP status code: 400) until the number of concurrently running jobs is below the Amazon Rekognition
     *         service limit.</li>
     *         <li>ResourceInUseException</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.CreateStreamProcessor
     */
    default CompletableFuture<CreateStreamProcessorResponse> createStreamProcessor(
            Consumer<CreateStreamProcessorRequest.Builder> createStreamProcessorRequest) {
        return createStreamProcessor(CreateStreamProcessorRequest.builder().applyMutation(createStreamProcessorRequest).build());
    }

    /**
     * <p>
     * Deletes the specified collection. Note that this operation removes all faces in the collection. For an example,
     * see <a>delete-collection-procedure</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DeleteCollection</code> action.
     * </p>
     *
     * @param deleteCollectionRequest
     * @return A Java Future containing the result of the DeleteCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DeleteCollection
     */
    default CompletableFuture<DeleteCollectionResponse> deleteCollection(DeleteCollectionRequest deleteCollectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified collection. Note that this operation removes all faces in the collection. For an example,
     * see <a>delete-collection-procedure</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DeleteCollection</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCollectionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteCollectionRequest#builder()}
     * </p>
     *
     * @param deleteCollectionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCollectionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DeleteCollection
     */
    default CompletableFuture<DeleteCollectionResponse> deleteCollection(
            Consumer<DeleteCollectionRequest.Builder> deleteCollectionRequest) {
        return deleteCollection(DeleteCollectionRequest.builder().applyMutation(deleteCollectionRequest).build());
    }

    /**
     * <p>
     * Deletes faces from a collection. You specify a collection ID and an array of face IDs to remove from the
     * collection.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DeleteFaces</code> action.
     * </p>
     *
     * @param deleteFacesRequest
     * @return A Java Future containing the result of the DeleteFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DeleteFaces
     */
    default CompletableFuture<DeleteFacesResponse> deleteFaces(DeleteFacesRequest deleteFacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes faces from a collection. You specify a collection ID and an array of face IDs to remove from the
     * collection.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DeleteFaces</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFacesRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFacesRequest#builder()}
     * </p>
     *
     * @param deleteFacesRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFacesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DeleteFaces
     */
    default CompletableFuture<DeleteFacesResponse> deleteFaces(Consumer<DeleteFacesRequest.Builder> deleteFacesRequest) {
        return deleteFaces(DeleteFacesRequest.builder().applyMutation(deleteFacesRequest).build());
    }

    /**
     * <p>
     * Deletes the stream processor identified by <code>Name</code>. You assign the value for <code>Name</code> when you
     * create the stream processor with . You might not be able to use the same name for a stream processor for a few
     * seconds after calling <code>DeleteStreamProcessor</code>.
     * </p>
     *
     * @param deleteStreamProcessorRequest
     * @return A Java Future containing the result of the DeleteStreamProcessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ResourceInUseException</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DeleteStreamProcessor
     */
    default CompletableFuture<DeleteStreamProcessorResponse> deleteStreamProcessor(
            DeleteStreamProcessorRequest deleteStreamProcessorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the stream processor identified by <code>Name</code>. You assign the value for <code>Name</code> when you
     * create the stream processor with . You might not be able to use the same name for a stream processor for a few
     * seconds after calling <code>DeleteStreamProcessor</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStreamProcessorRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteStreamProcessorRequest#builder()}
     * </p>
     *
     * @param deleteStreamProcessorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStreamProcessorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteStreamProcessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ResourceInUseException</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DeleteStreamProcessor
     */
    default CompletableFuture<DeleteStreamProcessorResponse> deleteStreamProcessor(
            Consumer<DeleteStreamProcessorRequest.Builder> deleteStreamProcessorRequest) {
        return deleteStreamProcessor(DeleteStreamProcessorRequest.builder().applyMutation(deleteStreamProcessorRequest).build());
    }

    /**
     * <p>
     * Describes the specified collection. You can use <code>DescribeCollection</code> to get information, such as the
     * number of faces indexed into a collection and the version of the model used by the collection for face detection.
     * </p>
     * <p>
     * For more information, see Describing a Collection in the Amazon Rekognition Developer Guide.
     * </p>
     *
     * @param describeCollectionRequest
     * @return A Java Future containing the result of the DescribeCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DescribeCollection
     */
    default CompletableFuture<DescribeCollectionResponse> describeCollection(DescribeCollectionRequest describeCollectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified collection. You can use <code>DescribeCollection</code> to get information, such as the
     * number of faces indexed into a collection and the version of the model used by the collection for face detection.
     * </p>
     * <p>
     * For more information, see Describing a Collection in the Amazon Rekognition Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCollectionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCollectionRequest#builder()}
     * </p>
     *
     * @param describeCollectionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCollectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DescribeCollection
     */
    default CompletableFuture<DescribeCollectionResponse> describeCollection(
            Consumer<DescribeCollectionRequest.Builder> describeCollectionRequest) {
        return describeCollection(DescribeCollectionRequest.builder().applyMutation(describeCollectionRequest).build());
    }

    /**
     * <p>
     * Provides information about a stream processor created by . You can get information about the input and output
     * streams, the input parameters for the face recognition being performed, and the current status of the stream
     * processor.
     * </p>
     *
     * @param describeStreamProcessorRequest
     * @return A Java Future containing the result of the DescribeStreamProcessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DescribeStreamProcessor
     */
    default CompletableFuture<DescribeStreamProcessorResponse> describeStreamProcessor(
            DescribeStreamProcessorRequest describeStreamProcessorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about a stream processor created by . You can get information about the input and output
     * streams, the input parameters for the face recognition being performed, and the current status of the stream
     * processor.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStreamProcessorRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeStreamProcessorRequest#builder()}
     * </p>
     *
     * @param describeStreamProcessorRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStreamProcessorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeStreamProcessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DescribeStreamProcessor
     */
    default CompletableFuture<DescribeStreamProcessorResponse> describeStreamProcessor(
            Consumer<DescribeStreamProcessorRequest.Builder> describeStreamProcessorRequest) {
        return describeStreamProcessor(DescribeStreamProcessorRequest.builder().applyMutation(describeStreamProcessorRequest)
                .build());
    }

    /**
     * <p>
     * Detects faces within an image that is provided as input.
     * </p>
     * <p>
     * <code>DetectFaces</code> detects the 100 largest faces in the image. For each face detected, the operation
     * returns face details. These details include a bounding box of the face, a confidence value (that the bounding box
     * contains a face), and a fixed set of attributes such as facial landmarks (for example, coordinates of eye and
     * mouth), gender, presence of beard, sunglasses, and so on.
     * </p>
     * <p>
     * The face-detection algorithm is most effective on frontal faces. For non-frontal or obscured faces, the algorithm
     * might not detect the faces or might detect faces with lower confidence.
     * </p>
     * <p>
     * You pass the input image either as base64-encoded image bytes or as a reference to an image in an Amazon S3
     * bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The
     * image must be either a PNG or JPEG formatted file.
     * </p>
     * <note>
     * <p>
     * This is a stateless API operation. That is, the operation does not persist any data.
     * </p>
     * </note>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DetectFaces</code> action.
     * </p>
     *
     * @param detectFacesRequest
     * @return A Java Future containing the result of the DetectFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. For more information, see
     *         Limits in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DetectFaces
     */
    default CompletableFuture<DetectFacesResponse> detectFaces(DetectFacesRequest detectFacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detects faces within an image that is provided as input.
     * </p>
     * <p>
     * <code>DetectFaces</code> detects the 100 largest faces in the image. For each face detected, the operation
     * returns face details. These details include a bounding box of the face, a confidence value (that the bounding box
     * contains a face), and a fixed set of attributes such as facial landmarks (for example, coordinates of eye and
     * mouth), gender, presence of beard, sunglasses, and so on.
     * </p>
     * <p>
     * The face-detection algorithm is most effective on frontal faces. For non-frontal or obscured faces, the algorithm
     * might not detect the faces or might detect faces with lower confidence.
     * </p>
     * <p>
     * You pass the input image either as base64-encoded image bytes or as a reference to an image in an Amazon S3
     * bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The
     * image must be either a PNG or JPEG formatted file.
     * </p>
     * <note>
     * <p>
     * This is a stateless API operation. That is, the operation does not persist any data.
     * </p>
     * </note>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DetectFaces</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectFacesRequest.Builder} avoiding the need to
     * create one manually via {@link DetectFacesRequest#builder()}
     * </p>
     *
     * @param detectFacesRequest
     *        A {@link Consumer} that will call methods on {@link DetectFacesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DetectFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. For more information, see
     *         Limits in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DetectFaces
     */
    default CompletableFuture<DetectFacesResponse> detectFaces(Consumer<DetectFacesRequest.Builder> detectFacesRequest) {
        return detectFaces(DetectFacesRequest.builder().applyMutation(detectFacesRequest).build());
    }

    /**
     * <p>
     * Detects instances of real-world entities within an image (JPEG or PNG) provided as input. This includes objects
     * like flower, tree, and table; events like wedding, graduation, and birthday party; and concepts like landscape,
     * evening, and nature.
     * </p>
     * <p>
     * For an example, see Analyzing Images Stored in an Amazon S3 Bucket in the Amazon Rekognition Developer Guide.
     * </p>
     * <note>
     * <p>
     * <code>DetectLabels</code> does not support the detection of activities. However, activity detection is supported
     * for label detection in videos. For more information, see StartLabelDetection in the Amazon Rekognition Developer
     * Guide.
     * </p>
     * </note>
     * <p>
     * You pass the input image as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. If
     * you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The image must
     * be either a PNG or JPEG formatted file.
     * </p>
     * <p>
     * For each object, scene, and concept the API returns one or more labels. Each label provides the object name, and
     * the level of confidence that the image contains the object. For example, suppose the input image has a
     * lighthouse, the sea, and a rock. The response includes all three labels, one for each object.
     * </p>
     * <p>
     * <code>{Name: lighthouse, Confidence: 98.4629}</code>
     * </p>
     * <p>
     * <code>{Name: rock,Confidence: 79.2097}</code>
     * </p>
     * <p>
     * <code> {Name: sea,Confidence: 75.061}</code>
     * </p>
     * <p>
     * In the preceding example, the operation returns one label for each of the three objects. The operation can also
     * return multiple labels for the same object in the image. For example, if the input image shows a flower (for
     * example, a tulip), the operation might return the following three labels.
     * </p>
     * <p>
     * <code>{Name: flower,Confidence: 99.0562}</code>
     * </p>
     * <p>
     * <code>{Name: plant,Confidence: 99.0562}</code>
     * </p>
     * <p>
     * <code>{Name: tulip,Confidence: 99.0562}</code>
     * </p>
     * <p>
     * In this example, the detection algorithm more precisely identifies the flower as a tulip.
     * </p>
     * <p>
     * In response, the API returns an array of labels. In addition, the response also includes the orientation
     * correction. Optionally, you can specify <code>MinConfidence</code> to control the confidence threshold for the
     * labels returned. The default is 50%. You can also add the <code>MaxLabels</code> parameter to limit the number of
     * labels returned.
     * </p>
     * <note>
     * <p>
     * If the object detected is a person, the operation doesn't provide the same facial details that the
     * <a>DetectFaces</a> operation provides.
     * </p>
     * </note>
     * <p>
     * <code>DetectLabels</code> returns bounding boxes for instances of common object labels in an array of objects. An
     * <code>Instance</code> object contains a object, for the location of the label on the image. It also includes the
     * confidence by which the bounding box was detected.
     * </p>
     * <p>
     * <code>DetectLabels</code> also returns a hierarchical taxonomy of detected labels. For example, a detected car
     * might be assigned the label <i>car</i>. The label <i>car</i> has two parent labels: <i>Vehicle</i> (its parent)
     * and <i>Transportation</i> (its grandparent). The response returns the entire list of ancestors for a label. Each
     * ancestor is a unique label in the response. In the previous example, <i>Car</i>, <i>Vehicle</i>, and
     * <i>Transportation</i> are returned as unique labels in the response.
     * </p>
     * <p>
     * This is a stateless API operation. That is, the operation does not persist any data.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DetectLabels</code> action.
     * </p>
     *
     * @param detectLabelsRequest
     * @return A Java Future containing the result of the DetectLabels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. For more information, see
     *         Limits in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DetectLabels
     */
    default CompletableFuture<DetectLabelsResponse> detectLabels(DetectLabelsRequest detectLabelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detects instances of real-world entities within an image (JPEG or PNG) provided as input. This includes objects
     * like flower, tree, and table; events like wedding, graduation, and birthday party; and concepts like landscape,
     * evening, and nature.
     * </p>
     * <p>
     * For an example, see Analyzing Images Stored in an Amazon S3 Bucket in the Amazon Rekognition Developer Guide.
     * </p>
     * <note>
     * <p>
     * <code>DetectLabels</code> does not support the detection of activities. However, activity detection is supported
     * for label detection in videos. For more information, see StartLabelDetection in the Amazon Rekognition Developer
     * Guide.
     * </p>
     * </note>
     * <p>
     * You pass the input image as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. If
     * you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The image must
     * be either a PNG or JPEG formatted file.
     * </p>
     * <p>
     * For each object, scene, and concept the API returns one or more labels. Each label provides the object name, and
     * the level of confidence that the image contains the object. For example, suppose the input image has a
     * lighthouse, the sea, and a rock. The response includes all three labels, one for each object.
     * </p>
     * <p>
     * <code>{Name: lighthouse, Confidence: 98.4629}</code>
     * </p>
     * <p>
     * <code>{Name: rock,Confidence: 79.2097}</code>
     * </p>
     * <p>
     * <code> {Name: sea,Confidence: 75.061}</code>
     * </p>
     * <p>
     * In the preceding example, the operation returns one label for each of the three objects. The operation can also
     * return multiple labels for the same object in the image. For example, if the input image shows a flower (for
     * example, a tulip), the operation might return the following three labels.
     * </p>
     * <p>
     * <code>{Name: flower,Confidence: 99.0562}</code>
     * </p>
     * <p>
     * <code>{Name: plant,Confidence: 99.0562}</code>
     * </p>
     * <p>
     * <code>{Name: tulip,Confidence: 99.0562}</code>
     * </p>
     * <p>
     * In this example, the detection algorithm more precisely identifies the flower as a tulip.
     * </p>
     * <p>
     * In response, the API returns an array of labels. In addition, the response also includes the orientation
     * correction. Optionally, you can specify <code>MinConfidence</code> to control the confidence threshold for the
     * labels returned. The default is 50%. You can also add the <code>MaxLabels</code> parameter to limit the number of
     * labels returned.
     * </p>
     * <note>
     * <p>
     * If the object detected is a person, the operation doesn't provide the same facial details that the
     * <a>DetectFaces</a> operation provides.
     * </p>
     * </note>
     * <p>
     * <code>DetectLabels</code> returns bounding boxes for instances of common object labels in an array of objects. An
     * <code>Instance</code> object contains a object, for the location of the label on the image. It also includes the
     * confidence by which the bounding box was detected.
     * </p>
     * <p>
     * <code>DetectLabels</code> also returns a hierarchical taxonomy of detected labels. For example, a detected car
     * might be assigned the label <i>car</i>. The label <i>car</i> has two parent labels: <i>Vehicle</i> (its parent)
     * and <i>Transportation</i> (its grandparent). The response returns the entire list of ancestors for a label. Each
     * ancestor is a unique label in the response. In the previous example, <i>Car</i>, <i>Vehicle</i>, and
     * <i>Transportation</i> are returned as unique labels in the response.
     * </p>
     * <p>
     * This is a stateless API operation. That is, the operation does not persist any data.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DetectLabels</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectLabelsRequest.Builder} avoiding the need to
     * create one manually via {@link DetectLabelsRequest#builder()}
     * </p>
     *
     * @param detectLabelsRequest
     *        A {@link Consumer} that will call methods on {@link DetectLabelsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DetectLabels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. For more information, see
     *         Limits in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DetectLabels
     */
    default CompletableFuture<DetectLabelsResponse> detectLabels(Consumer<DetectLabelsRequest.Builder> detectLabelsRequest) {
        return detectLabels(DetectLabelsRequest.builder().applyMutation(detectLabelsRequest).build());
    }

    /**
     * <p>
     * Detects explicit or suggestive adult content in a specified JPEG or PNG format image. Use
     * <code>DetectModerationLabels</code> to moderate images depending on your requirements. For example, you might
     * want to filter images that contain nudity, but not images containing suggestive content.
     * </p>
     * <p>
     * To filter images, use the labels returned by <code>DetectModerationLabels</code> to determine which types of
     * content are appropriate.
     * </p>
     * <p>
     * For information about moderation labels, see Detecting Unsafe Content in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * You pass the input image either as base64-encoded image bytes or as a reference to an image in an Amazon S3
     * bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The
     * image must be either a PNG or JPEG formatted file.
     * </p>
     *
     * @param detectModerationLabelsRequest
     * @return A Java Future containing the result of the DetectModerationLabels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. For more information, see
     *         Limits in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DetectModerationLabels
     */
    default CompletableFuture<DetectModerationLabelsResponse> detectModerationLabels(
            DetectModerationLabelsRequest detectModerationLabelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detects explicit or suggestive adult content in a specified JPEG or PNG format image. Use
     * <code>DetectModerationLabels</code> to moderate images depending on your requirements. For example, you might
     * want to filter images that contain nudity, but not images containing suggestive content.
     * </p>
     * <p>
     * To filter images, use the labels returned by <code>DetectModerationLabels</code> to determine which types of
     * content are appropriate.
     * </p>
     * <p>
     * For information about moderation labels, see Detecting Unsafe Content in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * You pass the input image either as base64-encoded image bytes or as a reference to an image in an Amazon S3
     * bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The
     * image must be either a PNG or JPEG formatted file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectModerationLabelsRequest.Builder} avoiding the
     * need to create one manually via {@link DetectModerationLabelsRequest#builder()}
     * </p>
     *
     * @param detectModerationLabelsRequest
     *        A {@link Consumer} that will call methods on {@link DetectModerationLabelsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DetectModerationLabels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. For more information, see
     *         Limits in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DetectModerationLabels
     */
    default CompletableFuture<DetectModerationLabelsResponse> detectModerationLabels(
            Consumer<DetectModerationLabelsRequest.Builder> detectModerationLabelsRequest) {
        return detectModerationLabels(DetectModerationLabelsRequest.builder().applyMutation(detectModerationLabelsRequest)
                .build());
    }

    /**
     * <p>
     * Detects text in the input image and converts it into machine-readable text.
     * </p>
     * <p>
     * Pass the input image as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. If you
     * use the AWS CLI to call Amazon Rekognition operations, you must pass it as a reference to an image in an Amazon
     * S3 bucket. For the AWS CLI, passing image bytes is not supported. The image must be either a .png or .jpeg
     * formatted file.
     * </p>
     * <p>
     * The <code>DetectText</code> operation returns text in an array of elements, <code>TextDetections</code>. Each
     * <code>TextDetection</code> element provides information about a single word or line of text that was detected in
     * the image.
     * </p>
     * <p>
     * A word is one or more ISO basic latin script characters that are not separated by spaces. <code>DetectText</code>
     * can detect up to 50 words in an image.
     * </p>
     * <p>
     * A line is a string of equally spaced words. A line isn't necessarily a complete sentence. For example, a driver's
     * license number is detected as a line. A line ends when there is no aligned text after it. Also, a line ends when
     * there is a large gap between words, relative to the length of the words. This means, depending on the gap between
     * words, Amazon Rekognition may detect multiple lines in text aligned in the same direction. Periods don't
     * represent the end of a line. If a sentence spans multiple lines, the <code>DetectText</code> operation returns
     * multiple lines.
     * </p>
     * <p>
     * To determine whether a <code>TextDetection</code> element is a line of text or a word, use the
     * <code>TextDetection</code> object <code>Type</code> field.
     * </p>
     * <p>
     * To be detected, text must be within +/- 90 degrees orientation of the horizontal axis.
     * </p>
     * <p>
     * For more information, see DetectText in the Amazon Rekognition Developer Guide.
     * </p>
     *
     * @param detectTextRequest
     * @return A Java Future containing the result of the DetectText operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. For more information, see
     *         Limits in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DetectText
     */
    default CompletableFuture<DetectTextResponse> detectText(DetectTextRequest detectTextRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detects text in the input image and converts it into machine-readable text.
     * </p>
     * <p>
     * Pass the input image as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. If you
     * use the AWS CLI to call Amazon Rekognition operations, you must pass it as a reference to an image in an Amazon
     * S3 bucket. For the AWS CLI, passing image bytes is not supported. The image must be either a .png or .jpeg
     * formatted file.
     * </p>
     * <p>
     * The <code>DetectText</code> operation returns text in an array of elements, <code>TextDetections</code>. Each
     * <code>TextDetection</code> element provides information about a single word or line of text that was detected in
     * the image.
     * </p>
     * <p>
     * A word is one or more ISO basic latin script characters that are not separated by spaces. <code>DetectText</code>
     * can detect up to 50 words in an image.
     * </p>
     * <p>
     * A line is a string of equally spaced words. A line isn't necessarily a complete sentence. For example, a driver's
     * license number is detected as a line. A line ends when there is no aligned text after it. Also, a line ends when
     * there is a large gap between words, relative to the length of the words. This means, depending on the gap between
     * words, Amazon Rekognition may detect multiple lines in text aligned in the same direction. Periods don't
     * represent the end of a line. If a sentence spans multiple lines, the <code>DetectText</code> operation returns
     * multiple lines.
     * </p>
     * <p>
     * To determine whether a <code>TextDetection</code> element is a line of text or a word, use the
     * <code>TextDetection</code> object <code>Type</code> field.
     * </p>
     * <p>
     * To be detected, text must be within +/- 90 degrees orientation of the horizontal axis.
     * </p>
     * <p>
     * For more information, see DetectText in the Amazon Rekognition Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectTextRequest.Builder} avoiding the need to
     * create one manually via {@link DetectTextRequest#builder()}
     * </p>
     *
     * @param detectTextRequest
     *        A {@link Consumer} that will call methods on {@link DetectTextRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DetectText operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. For more information, see
     *         Limits in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DetectText
     */
    default CompletableFuture<DetectTextResponse> detectText(Consumer<DetectTextRequest.Builder> detectTextRequest) {
        return detectText(DetectTextRequest.builder().applyMutation(detectTextRequest).build());
    }

    /**
     * <p>
     * Gets the name and additional information about a celebrity based on his or her Amazon Rekognition ID. The
     * additional information is returned as an array of URLs. If there is no additional information about the
     * celebrity, this list is empty.
     * </p>
     * <p>
     * For more information, see Recognizing Celebrities in an Image in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:GetCelebrityInfo</code> action.
     * </p>
     *
     * @param getCelebrityInfoRequest
     * @return A Java Future containing the result of the GetCelebrityInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetCelebrityInfo
     */
    default CompletableFuture<GetCelebrityInfoResponse> getCelebrityInfo(GetCelebrityInfoRequest getCelebrityInfoRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the name and additional information about a celebrity based on his or her Amazon Rekognition ID. The
     * additional information is returned as an array of URLs. If there is no additional information about the
     * celebrity, this list is empty.
     * </p>
     * <p>
     * For more information, see Recognizing Celebrities in an Image in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:GetCelebrityInfo</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCelebrityInfoRequest.Builder} avoiding the need
     * to create one manually via {@link GetCelebrityInfoRequest#builder()}
     * </p>
     *
     * @param getCelebrityInfoRequest
     *        A {@link Consumer} that will call methods on {@link GetCelebrityInfoRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCelebrityInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetCelebrityInfo
     */
    default CompletableFuture<GetCelebrityInfoResponse> getCelebrityInfo(
            Consumer<GetCelebrityInfoRequest.Builder> getCelebrityInfoRequest) {
        return getCelebrityInfo(GetCelebrityInfoRequest.builder().applyMutation(getCelebrityInfoRequest).build());
    }

    /**
     * <p>
     * Gets the celebrity recognition results for a Amazon Rekognition Video analysis started by .
     * </p>
     * <p>
     * Celebrity recognition in a video is an asynchronous operation. Analysis is started by a call to which returns a
     * job identifier (<code>JobId</code>). When the celebrity recognition operation finishes, Amazon Rekognition Video
     * publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to
     * <code>StartCelebrityRecognition</code>. To get the results of the celebrity recognition analysis, first check
     * that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call
     * <code>GetCelebrityDetection</code> and pass the job identifier (<code>JobId</code>) from the initial call to
     * <code>StartCelebrityDetection</code>.
     * </p>
     * <p>
     * For more information, see Working With Stored Videos in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * <code>GetCelebrityRecognition</code> returns detected celebrities and the time(s) they are detected in an array (
     * <code>Celebrities</code>) of objects. Each <code>CelebrityRecognition</code> contains information about the
     * celebrity in a object and the time, <code>Timestamp</code>, the celebrity was detected.
     * </p>
     * <note>
     * <p>
     * <code>GetCelebrityRecognition</code> only returns the default facial attributes (<code>BoundingBox</code>,
     * <code>Confidence</code>, <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>). The other facial
     * attributes listed in the <code>Face</code> object of the following response syntax are not returned. For more
     * information, see FaceDetail in the Amazon Rekognition Developer Guide.
     * </p>
     * </note>
     * <p>
     * By default, the <code>Celebrities</code> array is sorted by time (milliseconds from the start of the video). You
     * can also sort the array by celebrity by specifying the value <code>ID</code> in the <code>SortBy</code> input
     * parameter.
     * </p>
     * <p>
     * The <code>CelebrityDetail</code> object includes the celebrity identifer and additional information urls. If you
     * don't store the additional information urls, you can get them later by calling with the celebrity identifer.
     * </p>
     * <p>
     * No information is returned for faces not recognized as celebrities.
     * </p>
     * <p>
     * Use MaxResults parameter to limit the number of labels returned. If there are more results than specified in
     * <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination
     * token for getting the next set of results. To get the next page of results, call
     * <code>GetCelebrityDetection</code> and populate the <code>NextToken</code> request parameter with the token value
     * returned from the previous call to <code>GetCelebrityRecognition</code>.
     * </p>
     *
     * @param getCelebrityRecognitionRequest
     * @return A Java Future containing the result of the GetCelebrityRecognition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetCelebrityRecognition
     */
    default CompletableFuture<GetCelebrityRecognitionResponse> getCelebrityRecognition(
            GetCelebrityRecognitionRequest getCelebrityRecognitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the celebrity recognition results for a Amazon Rekognition Video analysis started by .
     * </p>
     * <p>
     * Celebrity recognition in a video is an asynchronous operation. Analysis is started by a call to which returns a
     * job identifier (<code>JobId</code>). When the celebrity recognition operation finishes, Amazon Rekognition Video
     * publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to
     * <code>StartCelebrityRecognition</code>. To get the results of the celebrity recognition analysis, first check
     * that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call
     * <code>GetCelebrityDetection</code> and pass the job identifier (<code>JobId</code>) from the initial call to
     * <code>StartCelebrityDetection</code>.
     * </p>
     * <p>
     * For more information, see Working With Stored Videos in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * <code>GetCelebrityRecognition</code> returns detected celebrities and the time(s) they are detected in an array (
     * <code>Celebrities</code>) of objects. Each <code>CelebrityRecognition</code> contains information about the
     * celebrity in a object and the time, <code>Timestamp</code>, the celebrity was detected.
     * </p>
     * <note>
     * <p>
     * <code>GetCelebrityRecognition</code> only returns the default facial attributes (<code>BoundingBox</code>,
     * <code>Confidence</code>, <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>). The other facial
     * attributes listed in the <code>Face</code> object of the following response syntax are not returned. For more
     * information, see FaceDetail in the Amazon Rekognition Developer Guide.
     * </p>
     * </note>
     * <p>
     * By default, the <code>Celebrities</code> array is sorted by time (milliseconds from the start of the video). You
     * can also sort the array by celebrity by specifying the value <code>ID</code> in the <code>SortBy</code> input
     * parameter.
     * </p>
     * <p>
     * The <code>CelebrityDetail</code> object includes the celebrity identifer and additional information urls. If you
     * don't store the additional information urls, you can get them later by calling with the celebrity identifer.
     * </p>
     * <p>
     * No information is returned for faces not recognized as celebrities.
     * </p>
     * <p>
     * Use MaxResults parameter to limit the number of labels returned. If there are more results than specified in
     * <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination
     * token for getting the next set of results. To get the next page of results, call
     * <code>GetCelebrityDetection</code> and populate the <code>NextToken</code> request parameter with the token value
     * returned from the previous call to <code>GetCelebrityRecognition</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCelebrityRecognitionRequest.Builder} avoiding
     * the need to create one manually via {@link GetCelebrityRecognitionRequest#builder()}
     * </p>
     *
     * @param getCelebrityRecognitionRequest
     *        A {@link Consumer} that will call methods on {@link GetCelebrityRecognitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCelebrityRecognition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetCelebrityRecognition
     */
    default CompletableFuture<GetCelebrityRecognitionResponse> getCelebrityRecognition(
            Consumer<GetCelebrityRecognitionRequest.Builder> getCelebrityRecognitionRequest) {
        return getCelebrityRecognition(GetCelebrityRecognitionRequest.builder().applyMutation(getCelebrityRecognitionRequest)
                .build());
    }

    /**
     * <p>
     * Gets the celebrity recognition results for a Amazon Rekognition Video analysis started by .
     * </p>
     * <p>
     * Celebrity recognition in a video is an asynchronous operation. Analysis is started by a call to which returns a
     * job identifier (<code>JobId</code>). When the celebrity recognition operation finishes, Amazon Rekognition Video
     * publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to
     * <code>StartCelebrityRecognition</code>. To get the results of the celebrity recognition analysis, first check
     * that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call
     * <code>GetCelebrityDetection</code> and pass the job identifier (<code>JobId</code>) from the initial call to
     * <code>StartCelebrityDetection</code>.
     * </p>
     * <p>
     * For more information, see Working With Stored Videos in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * <code>GetCelebrityRecognition</code> returns detected celebrities and the time(s) they are detected in an array (
     * <code>Celebrities</code>) of objects. Each <code>CelebrityRecognition</code> contains information about the
     * celebrity in a object and the time, <code>Timestamp</code>, the celebrity was detected.
     * </p>
     * <note>
     * <p>
     * <code>GetCelebrityRecognition</code> only returns the default facial attributes (<code>BoundingBox</code>,
     * <code>Confidence</code>, <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>). The other facial
     * attributes listed in the <code>Face</code> object of the following response syntax are not returned. For more
     * information, see FaceDetail in the Amazon Rekognition Developer Guide.
     * </p>
     * </note>
     * <p>
     * By default, the <code>Celebrities</code> array is sorted by time (milliseconds from the start of the video). You
     * can also sort the array by celebrity by specifying the value <code>ID</code> in the <code>SortBy</code> input
     * parameter.
     * </p>
     * <p>
     * The <code>CelebrityDetail</code> object includes the celebrity identifer and additional information urls. If you
     * don't store the additional information urls, you can get them later by calling with the celebrity identifer.
     * </p>
     * <p>
     * No information is returned for faces not recognized as celebrities.
     * </p>
     * <p>
     * Use MaxResults parameter to limit the number of labels returned. If there are more results than specified in
     * <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination
     * token for getting the next set of results. To get the next page of results, call
     * <code>GetCelebrityDetection</code> and populate the <code>NextToken</code> request parameter with the token value
     * returned from the previous call to <code>GetCelebrityRecognition</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCelebrityRecognition(software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetCelebrityRecognitionPublisher publisher = client.getCelebrityRecognitionPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetCelebrityRecognitionPublisher publisher = client.getCelebrityRecognitionPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCelebrityRecognition(software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCelebrityRecognitionRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetCelebrityRecognition
     */
    default GetCelebrityRecognitionPublisher getCelebrityRecognitionPaginator(
            GetCelebrityRecognitionRequest getCelebrityRecognitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the celebrity recognition results for a Amazon Rekognition Video analysis started by .
     * </p>
     * <p>
     * Celebrity recognition in a video is an asynchronous operation. Analysis is started by a call to which returns a
     * job identifier (<code>JobId</code>). When the celebrity recognition operation finishes, Amazon Rekognition Video
     * publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to
     * <code>StartCelebrityRecognition</code>. To get the results of the celebrity recognition analysis, first check
     * that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call
     * <code>GetCelebrityDetection</code> and pass the job identifier (<code>JobId</code>) from the initial call to
     * <code>StartCelebrityDetection</code>.
     * </p>
     * <p>
     * For more information, see Working With Stored Videos in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * <code>GetCelebrityRecognition</code> returns detected celebrities and the time(s) they are detected in an array (
     * <code>Celebrities</code>) of objects. Each <code>CelebrityRecognition</code> contains information about the
     * celebrity in a object and the time, <code>Timestamp</code>, the celebrity was detected.
     * </p>
     * <note>
     * <p>
     * <code>GetCelebrityRecognition</code> only returns the default facial attributes (<code>BoundingBox</code>,
     * <code>Confidence</code>, <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>). The other facial
     * attributes listed in the <code>Face</code> object of the following response syntax are not returned. For more
     * information, see FaceDetail in the Amazon Rekognition Developer Guide.
     * </p>
     * </note>
     * <p>
     * By default, the <code>Celebrities</code> array is sorted by time (milliseconds from the start of the video). You
     * can also sort the array by celebrity by specifying the value <code>ID</code> in the <code>SortBy</code> input
     * parameter.
     * </p>
     * <p>
     * The <code>CelebrityDetail</code> object includes the celebrity identifer and additional information urls. If you
     * don't store the additional information urls, you can get them later by calling with the celebrity identifer.
     * </p>
     * <p>
     * No information is returned for faces not recognized as celebrities.
     * </p>
     * <p>
     * Use MaxResults parameter to limit the number of labels returned. If there are more results than specified in
     * <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination
     * token for getting the next set of results. To get the next page of results, call
     * <code>GetCelebrityDetection</code> and populate the <code>NextToken</code> request parameter with the token value
     * returned from the previous call to <code>GetCelebrityRecognition</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCelebrityRecognition(software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetCelebrityRecognitionPublisher publisher = client.getCelebrityRecognitionPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetCelebrityRecognitionPublisher publisher = client.getCelebrityRecognitionPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCelebrityRecognition(software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCelebrityRecognitionRequest.Builder} avoiding
     * the need to create one manually via {@link GetCelebrityRecognitionRequest#builder()}
     * </p>
     *
     * @param getCelebrityRecognitionRequest
     *        A {@link Consumer} that will call methods on {@link GetCelebrityRecognitionRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetCelebrityRecognition
     */
    default GetCelebrityRecognitionPublisher getCelebrityRecognitionPaginator(
            Consumer<GetCelebrityRecognitionRequest.Builder> getCelebrityRecognitionRequest) {
        return getCelebrityRecognitionPaginator(GetCelebrityRecognitionRequest.builder()
                .applyMutation(getCelebrityRecognitionRequest).build());
    }

    /**
     * <p>
     * Gets the content moderation analysis results for a Amazon Rekognition Video analysis started by .
     * </p>
     * <p>
     * Content moderation analysis of a video is an asynchronous operation. You start analysis by calling . which
     * returns a job identifier (<code>JobId</code>). When analysis finishes, Amazon Rekognition Video publishes a
     * completion status to the Amazon Simple Notification Service topic registered in the initial call to
     * <code>StartContentModeration</code>. To get the results of the content moderation analysis, first check that the
     * status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call
     * <code>GetCelebrityDetection</code> and pass the job identifier (<code>JobId</code>) from the initial call to
     * <code>StartCelebrityDetection</code>.
     * </p>
     * <p>
     * For more information, see Working with Stored Videos in the Amazon Rekognition Devlopers Guide.
     * </p>
     * <p>
     * <code>GetContentModeration</code> returns detected content moderation labels, and the time they are detected, in
     * an array, <code>ModerationLabels</code>, of objects.
     * </p>
     * <p>
     * By default, the moderated labels are returned sorted by time, in milliseconds from the start of the video. You
     * can also sort them by moderated label by specifying <code>NAME</code> for the <code>SortBy</code> input
     * parameter.
     * </p>
     * <p>
     * Since video analysis can return a large number of results, use the <code>MaxResults</code> parameter to limit the
     * number of labels returned in a single call to <code>GetContentModeration</code>. If there are more results than
     * specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a
     * pagination token for getting the next set of results. To get the next page of results, call
     * <code>GetContentModeration</code> and populate the <code>NextToken</code> request parameter with the value of
     * <code>NextToken</code> returned from the previous call to <code>GetContentModeration</code>.
     * </p>
     * <p>
     * For more information, see Detecting Unsafe Content in the Amazon Rekognition Developer Guide.
     * </p>
     *
     * @param getContentModerationRequest
     * @return A Java Future containing the result of the GetContentModeration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetContentModeration
     */
    default CompletableFuture<GetContentModerationResponse> getContentModeration(
            GetContentModerationRequest getContentModerationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the content moderation analysis results for a Amazon Rekognition Video analysis started by .
     * </p>
     * <p>
     * Content moderation analysis of a video is an asynchronous operation. You start analysis by calling . which
     * returns a job identifier (<code>JobId</code>). When analysis finishes, Amazon Rekognition Video publishes a
     * completion status to the Amazon Simple Notification Service topic registered in the initial call to
     * <code>StartContentModeration</code>. To get the results of the content moderation analysis, first check that the
     * status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call
     * <code>GetCelebrityDetection</code> and pass the job identifier (<code>JobId</code>) from the initial call to
     * <code>StartCelebrityDetection</code>.
     * </p>
     * <p>
     * For more information, see Working with Stored Videos in the Amazon Rekognition Devlopers Guide.
     * </p>
     * <p>
     * <code>GetContentModeration</code> returns detected content moderation labels, and the time they are detected, in
     * an array, <code>ModerationLabels</code>, of objects.
     * </p>
     * <p>
     * By default, the moderated labels are returned sorted by time, in milliseconds from the start of the video. You
     * can also sort them by moderated label by specifying <code>NAME</code> for the <code>SortBy</code> input
     * parameter.
     * </p>
     * <p>
     * Since video analysis can return a large number of results, use the <code>MaxResults</code> parameter to limit the
     * number of labels returned in a single call to <code>GetContentModeration</code>. If there are more results than
     * specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a
     * pagination token for getting the next set of results. To get the next page of results, call
     * <code>GetContentModeration</code> and populate the <code>NextToken</code> request parameter with the value of
     * <code>NextToken</code> returned from the previous call to <code>GetContentModeration</code>.
     * </p>
     * <p>
     * For more information, see Detecting Unsafe Content in the Amazon Rekognition Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContentModerationRequest.Builder} avoiding the
     * need to create one manually via {@link GetContentModerationRequest#builder()}
     * </p>
     *
     * @param getContentModerationRequest
     *        A {@link Consumer} that will call methods on {@link GetContentModerationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetContentModeration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetContentModeration
     */
    default CompletableFuture<GetContentModerationResponse> getContentModeration(
            Consumer<GetContentModerationRequest.Builder> getContentModerationRequest) {
        return getContentModeration(GetContentModerationRequest.builder().applyMutation(getContentModerationRequest).build());
    }

    /**
     * <p>
     * Gets the content moderation analysis results for a Amazon Rekognition Video analysis started by .
     * </p>
     * <p>
     * Content moderation analysis of a video is an asynchronous operation. You start analysis by calling . which
     * returns a job identifier (<code>JobId</code>). When analysis finishes, Amazon Rekognition Video publishes a
     * completion status to the Amazon Simple Notification Service topic registered in the initial call to
     * <code>StartContentModeration</code>. To get the results of the content moderation analysis, first check that the
     * status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call
     * <code>GetCelebrityDetection</code> and pass the job identifier (<code>JobId</code>) from the initial call to
     * <code>StartCelebrityDetection</code>.
     * </p>
     * <p>
     * For more information, see Working with Stored Videos in the Amazon Rekognition Devlopers Guide.
     * </p>
     * <p>
     * <code>GetContentModeration</code> returns detected content moderation labels, and the time they are detected, in
     * an array, <code>ModerationLabels</code>, of objects.
     * </p>
     * <p>
     * By default, the moderated labels are returned sorted by time, in milliseconds from the start of the video. You
     * can also sort them by moderated label by specifying <code>NAME</code> for the <code>SortBy</code> input
     * parameter.
     * </p>
     * <p>
     * Since video analysis can return a large number of results, use the <code>MaxResults</code> parameter to limit the
     * number of labels returned in a single call to <code>GetContentModeration</code>. If there are more results than
     * specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a
     * pagination token for getting the next set of results. To get the next page of results, call
     * <code>GetContentModeration</code> and populate the <code>NextToken</code> request parameter with the value of
     * <code>NextToken</code> returned from the previous call to <code>GetContentModeration</code>.
     * </p>
     * <p>
     * For more information, see Detecting Unsafe Content in the Amazon Rekognition Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getContentModeration(software.amazon.awssdk.services.rekognition.model.GetContentModerationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetContentModerationPublisher publisher = client.getContentModerationPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetContentModerationPublisher publisher = client.getContentModerationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rekognition.model.GetContentModerationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rekognition.model.GetContentModerationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getContentModeration(software.amazon.awssdk.services.rekognition.model.GetContentModerationRequest)}
     * operation.</b>
     * </p>
     *
     * @param getContentModerationRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetContentModeration
     */
    default GetContentModerationPublisher getContentModerationPaginator(GetContentModerationRequest getContentModerationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the content moderation analysis results for a Amazon Rekognition Video analysis started by .
     * </p>
     * <p>
     * Content moderation analysis of a video is an asynchronous operation. You start analysis by calling . which
     * returns a job identifier (<code>JobId</code>). When analysis finishes, Amazon Rekognition Video publishes a
     * completion status to the Amazon Simple Notification Service topic registered in the initial call to
     * <code>StartContentModeration</code>. To get the results of the content moderation analysis, first check that the
     * status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call
     * <code>GetCelebrityDetection</code> and pass the job identifier (<code>JobId</code>) from the initial call to
     * <code>StartCelebrityDetection</code>.
     * </p>
     * <p>
     * For more information, see Working with Stored Videos in the Amazon Rekognition Devlopers Guide.
     * </p>
     * <p>
     * <code>GetContentModeration</code> returns detected content moderation labels, and the time they are detected, in
     * an array, <code>ModerationLabels</code>, of objects.
     * </p>
     * <p>
     * By default, the moderated labels are returned sorted by time, in milliseconds from the start of the video. You
     * can also sort them by moderated label by specifying <code>NAME</code> for the <code>SortBy</code> input
     * parameter.
     * </p>
     * <p>
     * Since video analysis can return a large number of results, use the <code>MaxResults</code> parameter to limit the
     * number of labels returned in a single call to <code>GetContentModeration</code>. If there are more results than
     * specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a
     * pagination token for getting the next set of results. To get the next page of results, call
     * <code>GetContentModeration</code> and populate the <code>NextToken</code> request parameter with the value of
     * <code>NextToken</code> returned from the previous call to <code>GetContentModeration</code>.
     * </p>
     * <p>
     * For more information, see Detecting Unsafe Content in the Amazon Rekognition Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getContentModeration(software.amazon.awssdk.services.rekognition.model.GetContentModerationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetContentModerationPublisher publisher = client.getContentModerationPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetContentModerationPublisher publisher = client.getContentModerationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rekognition.model.GetContentModerationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rekognition.model.GetContentModerationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getContentModeration(software.amazon.awssdk.services.rekognition.model.GetContentModerationRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContentModerationRequest.Builder} avoiding the
     * need to create one manually via {@link GetContentModerationRequest#builder()}
     * </p>
     *
     * @param getContentModerationRequest
     *        A {@link Consumer} that will call methods on {@link GetContentModerationRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetContentModeration
     */
    default GetContentModerationPublisher getContentModerationPaginator(
            Consumer<GetContentModerationRequest.Builder> getContentModerationRequest) {
        return getContentModerationPaginator(GetContentModerationRequest.builder().applyMutation(getContentModerationRequest)
                .build());
    }

    /**
     * <p>
     * Gets face detection results for a Amazon Rekognition Video analysis started by .
     * </p>
     * <p>
     * Face detection with Amazon Rekognition Video is an asynchronous operation. You start face detection by calling
     * which returns a job identifier (<code>JobId</code>). When the face detection operation finishes, Amazon
     * Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic registered in the
     * initial call to <code>StartFaceDetection</code>. To get the results of the face detection operation, first check
     * that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call and pass the job
     * identifier (<code>JobId</code>) from the initial call to <code>StartFaceDetection</code>.
     * </p>
     * <p>
     * <code>GetFaceDetection</code> returns an array of detected faces (<code>Faces</code>) sorted by the time the
     * faces were detected.
     * </p>
     * <p>
     * Use MaxResults parameter to limit the number of labels returned. If there are more results than specified in
     * <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination
     * token for getting the next set of results. To get the next page of results, call <code>GetFaceDetection</code>
     * and populate the <code>NextToken</code> request parameter with the token value returned from the previous call to
     * <code>GetFaceDetection</code>.
     * </p>
     *
     * @param getFaceDetectionRequest
     * @return A Java Future containing the result of the GetFaceDetection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetFaceDetection
     */
    default CompletableFuture<GetFaceDetectionResponse> getFaceDetection(GetFaceDetectionRequest getFaceDetectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets face detection results for a Amazon Rekognition Video analysis started by .
     * </p>
     * <p>
     * Face detection with Amazon Rekognition Video is an asynchronous operation. You start face detection by calling
     * which returns a job identifier (<code>JobId</code>). When the face detection operation finishes, Amazon
     * Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic registered in the
     * initial call to <code>StartFaceDetection</code>. To get the results of the face detection operation, first check
     * that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call and pass the job
     * identifier (<code>JobId</code>) from the initial call to <code>StartFaceDetection</code>.
     * </p>
     * <p>
     * <code>GetFaceDetection</code> returns an array of detected faces (<code>Faces</code>) sorted by the time the
     * faces were detected.
     * </p>
     * <p>
     * Use MaxResults parameter to limit the number of labels returned. If there are more results than specified in
     * <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination
     * token for getting the next set of results. To get the next page of results, call <code>GetFaceDetection</code>
     * and populate the <code>NextToken</code> request parameter with the token value returned from the previous call to
     * <code>GetFaceDetection</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFaceDetectionRequest.Builder} avoiding the need
     * to create one manually via {@link GetFaceDetectionRequest#builder()}
     * </p>
     *
     * @param getFaceDetectionRequest
     *        A {@link Consumer} that will call methods on {@link GetFaceDetectionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFaceDetection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetFaceDetection
     */
    default CompletableFuture<GetFaceDetectionResponse> getFaceDetection(
            Consumer<GetFaceDetectionRequest.Builder> getFaceDetectionRequest) {
        return getFaceDetection(GetFaceDetectionRequest.builder().applyMutation(getFaceDetectionRequest).build());
    }

    /**
     * <p>
     * Gets face detection results for a Amazon Rekognition Video analysis started by .
     * </p>
     * <p>
     * Face detection with Amazon Rekognition Video is an asynchronous operation. You start face detection by calling
     * which returns a job identifier (<code>JobId</code>). When the face detection operation finishes, Amazon
     * Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic registered in the
     * initial call to <code>StartFaceDetection</code>. To get the results of the face detection operation, first check
     * that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call and pass the job
     * identifier (<code>JobId</code>) from the initial call to <code>StartFaceDetection</code>.
     * </p>
     * <p>
     * <code>GetFaceDetection</code> returns an array of detected faces (<code>Faces</code>) sorted by the time the
     * faces were detected.
     * </p>
     * <p>
     * Use MaxResults parameter to limit the number of labels returned. If there are more results than specified in
     * <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination
     * token for getting the next set of results. To get the next page of results, call <code>GetFaceDetection</code>
     * and populate the <code>NextToken</code> request parameter with the token value returned from the previous call to
     * <code>GetFaceDetection</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getFaceDetection(software.amazon.awssdk.services.rekognition.model.GetFaceDetectionRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetFaceDetectionPublisher publisher = client.getFaceDetectionPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetFaceDetectionPublisher publisher = client.getFaceDetectionPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rekognition.model.GetFaceDetectionResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rekognition.model.GetFaceDetectionResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFaceDetection(software.amazon.awssdk.services.rekognition.model.GetFaceDetectionRequest)}
     * operation.</b>
     * </p>
     *
     * @param getFaceDetectionRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetFaceDetection
     */
    default GetFaceDetectionPublisher getFaceDetectionPaginator(GetFaceDetectionRequest getFaceDetectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets face detection results for a Amazon Rekognition Video analysis started by .
     * </p>
     * <p>
     * Face detection with Amazon Rekognition Video is an asynchronous operation. You start face detection by calling
     * which returns a job identifier (<code>JobId</code>). When the face detection operation finishes, Amazon
     * Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic registered in the
     * initial call to <code>StartFaceDetection</code>. To get the results of the face detection operation, first check
     * that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call and pass the job
     * identifier (<code>JobId</code>) from the initial call to <code>StartFaceDetection</code>.
     * </p>
     * <p>
     * <code>GetFaceDetection</code> returns an array of detected faces (<code>Faces</code>) sorted by the time the
     * faces were detected.
     * </p>
     * <p>
     * Use MaxResults parameter to limit the number of labels returned. If there are more results than specified in
     * <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination
     * token for getting the next set of results. To get the next page of results, call <code>GetFaceDetection</code>
     * and populate the <code>NextToken</code> request parameter with the token value returned from the previous call to
     * <code>GetFaceDetection</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getFaceDetection(software.amazon.awssdk.services.rekognition.model.GetFaceDetectionRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetFaceDetectionPublisher publisher = client.getFaceDetectionPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetFaceDetectionPublisher publisher = client.getFaceDetectionPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rekognition.model.GetFaceDetectionResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rekognition.model.GetFaceDetectionResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFaceDetection(software.amazon.awssdk.services.rekognition.model.GetFaceDetectionRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFaceDetectionRequest.Builder} avoiding the need
     * to create one manually via {@link GetFaceDetectionRequest#builder()}
     * </p>
     *
     * @param getFaceDetectionRequest
     *        A {@link Consumer} that will call methods on {@link GetFaceDetectionRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetFaceDetection
     */
    default GetFaceDetectionPublisher getFaceDetectionPaginator(Consumer<GetFaceDetectionRequest.Builder> getFaceDetectionRequest) {
        return getFaceDetectionPaginator(GetFaceDetectionRequest.builder().applyMutation(getFaceDetectionRequest).build());
    }

    /**
     * <p>
     * Gets the face search results for Amazon Rekognition Video face search started by . The search returns faces in a
     * collection that match the faces of persons detected in a video. It also includes the time(s) that faces are
     * matched in the video.
     * </p>
     * <p>
     * Face search in a video is an asynchronous operation. You start face search by calling to which returns a job
     * identifier (<code>JobId</code>). When the search operation finishes, Amazon Rekognition Video publishes a
     * completion status to the Amazon Simple Notification Service topic registered in the initial call to
     * <code>StartFaceSearch</code>. To get the search results, first check that the status value published to the
     * Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetFaceSearch</code> and pass the job identifier (
     * <code>JobId</code>) from the initial call to <code>StartFaceSearch</code>.
     * </p>
     * <p>
     * For more information, see Searching Faces in a Collection in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * The search results are retured in an array, <code>Persons</code>, of objects. Each<code>PersonMatch</code>
     * element contains details about the matching faces in the input collection, person information (facial attributes,
     * bounding boxes, and person identifer) for the matched person, and the time the person was matched in the video.
     * </p>
     * <note>
     * <p>
     * <code>GetFaceSearch</code> only returns the default facial attributes (<code>BoundingBox</code>,
     * <code>Confidence</code>, <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>). The other facial
     * attributes listed in the <code>Face</code> object of the following response syntax are not returned. For more
     * information, see FaceDetail in the Amazon Rekognition Developer Guide.
     * </p>
     * </note>
     * <p>
     * By default, the <code>Persons</code> array is sorted by the time, in milliseconds from the start of the video,
     * persons are matched. You can also sort by persons by specifying <code>INDEX</code> for the <code>SORTBY</code>
     * input parameter.
     * </p>
     *
     * @param getFaceSearchRequest
     * @return A Java Future containing the result of the GetFaceSearch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetFaceSearch
     */
    default CompletableFuture<GetFaceSearchResponse> getFaceSearch(GetFaceSearchRequest getFaceSearchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the face search results for Amazon Rekognition Video face search started by . The search returns faces in a
     * collection that match the faces of persons detected in a video. It also includes the time(s) that faces are
     * matched in the video.
     * </p>
     * <p>
     * Face search in a video is an asynchronous operation. You start face search by calling to which returns a job
     * identifier (<code>JobId</code>). When the search operation finishes, Amazon Rekognition Video publishes a
     * completion status to the Amazon Simple Notification Service topic registered in the initial call to
     * <code>StartFaceSearch</code>. To get the search results, first check that the status value published to the
     * Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetFaceSearch</code> and pass the job identifier (
     * <code>JobId</code>) from the initial call to <code>StartFaceSearch</code>.
     * </p>
     * <p>
     * For more information, see Searching Faces in a Collection in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * The search results are retured in an array, <code>Persons</code>, of objects. Each<code>PersonMatch</code>
     * element contains details about the matching faces in the input collection, person information (facial attributes,
     * bounding boxes, and person identifer) for the matched person, and the time the person was matched in the video.
     * </p>
     * <note>
     * <p>
     * <code>GetFaceSearch</code> only returns the default facial attributes (<code>BoundingBox</code>,
     * <code>Confidence</code>, <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>). The other facial
     * attributes listed in the <code>Face</code> object of the following response syntax are not returned. For more
     * information, see FaceDetail in the Amazon Rekognition Developer Guide.
     * </p>
     * </note>
     * <p>
     * By default, the <code>Persons</code> array is sorted by the time, in milliseconds from the start of the video,
     * persons are matched. You can also sort by persons by specifying <code>INDEX</code> for the <code>SORTBY</code>
     * input parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFaceSearchRequest.Builder} avoiding the need to
     * create one manually via {@link GetFaceSearchRequest#builder()}
     * </p>
     *
     * @param getFaceSearchRequest
     *        A {@link Consumer} that will call methods on {@link GetFaceSearchRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFaceSearch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetFaceSearch
     */
    default CompletableFuture<GetFaceSearchResponse> getFaceSearch(Consumer<GetFaceSearchRequest.Builder> getFaceSearchRequest) {
        return getFaceSearch(GetFaceSearchRequest.builder().applyMutation(getFaceSearchRequest).build());
    }

    /**
     * <p>
     * Gets the face search results for Amazon Rekognition Video face search started by . The search returns faces in a
     * collection that match the faces of persons detected in a video. It also includes the time(s) that faces are
     * matched in the video.
     * </p>
     * <p>
     * Face search in a video is an asynchronous operation. You start face search by calling to which returns a job
     * identifier (<code>JobId</code>). When the search operation finishes, Amazon Rekognition Video publishes a
     * completion status to the Amazon Simple Notification Service topic registered in the initial call to
     * <code>StartFaceSearch</code>. To get the search results, first check that the status value published to the
     * Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetFaceSearch</code> and pass the job identifier (
     * <code>JobId</code>) from the initial call to <code>StartFaceSearch</code>.
     * </p>
     * <p>
     * For more information, see Searching Faces in a Collection in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * The search results are retured in an array, <code>Persons</code>, of objects. Each<code>PersonMatch</code>
     * element contains details about the matching faces in the input collection, person information (facial attributes,
     * bounding boxes, and person identifer) for the matched person, and the time the person was matched in the video.
     * </p>
     * <note>
     * <p>
     * <code>GetFaceSearch</code> only returns the default facial attributes (<code>BoundingBox</code>,
     * <code>Confidence</code>, <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>). The other facial
     * attributes listed in the <code>Face</code> object of the following response syntax are not returned. For more
     * information, see FaceDetail in the Amazon Rekognition Developer Guide.
     * </p>
     * </note>
     * <p>
     * By default, the <code>Persons</code> array is sorted by the time, in milliseconds from the start of the video,
     * persons are matched. You can also sort by persons by specifying <code>INDEX</code> for the <code>SORTBY</code>
     * input parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getFaceSearch(software.amazon.awssdk.services.rekognition.model.GetFaceSearchRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetFaceSearchPublisher publisher = client.getFaceSearchPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetFaceSearchPublisher publisher = client.getFaceSearchPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rekognition.model.GetFaceSearchResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rekognition.model.GetFaceSearchResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFaceSearch(software.amazon.awssdk.services.rekognition.model.GetFaceSearchRequest)} operation.</b>
     * </p>
     *
     * @param getFaceSearchRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetFaceSearch
     */
    default GetFaceSearchPublisher getFaceSearchPaginator(GetFaceSearchRequest getFaceSearchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the face search results for Amazon Rekognition Video face search started by . The search returns faces in a
     * collection that match the faces of persons detected in a video. It also includes the time(s) that faces are
     * matched in the video.
     * </p>
     * <p>
     * Face search in a video is an asynchronous operation. You start face search by calling to which returns a job
     * identifier (<code>JobId</code>). When the search operation finishes, Amazon Rekognition Video publishes a
     * completion status to the Amazon Simple Notification Service topic registered in the initial call to
     * <code>StartFaceSearch</code>. To get the search results, first check that the status value published to the
     * Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetFaceSearch</code> and pass the job identifier (
     * <code>JobId</code>) from the initial call to <code>StartFaceSearch</code>.
     * </p>
     * <p>
     * For more information, see Searching Faces in a Collection in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * The search results are retured in an array, <code>Persons</code>, of objects. Each<code>PersonMatch</code>
     * element contains details about the matching faces in the input collection, person information (facial attributes,
     * bounding boxes, and person identifer) for the matched person, and the time the person was matched in the video.
     * </p>
     * <note>
     * <p>
     * <code>GetFaceSearch</code> only returns the default facial attributes (<code>BoundingBox</code>,
     * <code>Confidence</code>, <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>). The other facial
     * attributes listed in the <code>Face</code> object of the following response syntax are not returned. For more
     * information, see FaceDetail in the Amazon Rekognition Developer Guide.
     * </p>
     * </note>
     * <p>
     * By default, the <code>Persons</code> array is sorted by the time, in milliseconds from the start of the video,
     * persons are matched. You can also sort by persons by specifying <code>INDEX</code> for the <code>SORTBY</code>
     * input parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getFaceSearch(software.amazon.awssdk.services.rekognition.model.GetFaceSearchRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetFaceSearchPublisher publisher = client.getFaceSearchPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetFaceSearchPublisher publisher = client.getFaceSearchPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rekognition.model.GetFaceSearchResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rekognition.model.GetFaceSearchResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFaceSearch(software.amazon.awssdk.services.rekognition.model.GetFaceSearchRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFaceSearchRequest.Builder} avoiding the need to
     * create one manually via {@link GetFaceSearchRequest#builder()}
     * </p>
     *
     * @param getFaceSearchRequest
     *        A {@link Consumer} that will call methods on {@link GetFaceSearchRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetFaceSearch
     */
    default GetFaceSearchPublisher getFaceSearchPaginator(Consumer<GetFaceSearchRequest.Builder> getFaceSearchRequest) {
        return getFaceSearchPaginator(GetFaceSearchRequest.builder().applyMutation(getFaceSearchRequest).build());
    }

    /**
     * <p>
     * Gets the label detection results of a Amazon Rekognition Video analysis started by .
     * </p>
     * <p>
     * The label detection operation is started by a call to which returns a job identifier (<code>JobId</code>). When
     * the label detection operation finishes, Amazon Rekognition publishes a completion status to the Amazon Simple
     * Notification Service topic registered in the initial call to <code>StartlabelDetection</code>. To get the results
     * of the label detection operation, first check that the status value published to the Amazon SNS topic is
     * <code>SUCCEEDED</code>. If so, call and pass the job identifier (<code>JobId</code>) from the initial call to
     * <code>StartLabelDetection</code>.
     * </p>
     * <p>
     * <code>GetLabelDetection</code> returns an array of detected labels (<code>Labels</code>) sorted by the time the
     * labels were detected. You can also sort by the label name by specifying <code>NAME</code> for the
     * <code>SortBy</code> input parameter.
     * </p>
     * <p>
     * The labels returned include the label name, the percentage confidence in the accuracy of the detected label, and
     * the time the label was detected in the video.
     * </p>
     * <p>
     * Use MaxResults parameter to limit the number of labels returned. If there are more results than specified in
     * <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination
     * token for getting the next set of results. To get the next page of results, call <code>GetlabelDetection</code>
     * and populate the <code>NextToken</code> request parameter with the token value returned from the previous call to
     * <code>GetLabelDetection</code>.
     * </p>
     * <note>
     * <p>
     * <code>GetLabelDetection</code> doesn't return a hierarchical taxonomy, or bounding box information, for detected
     * labels. <code>GetLabelDetection</code> returns <code>null</code> for the <code>Parents</code> and
     * <code>Instances</code> attributes of the object which is returned in the <code>Labels</code> array.
     * </p>
     * </note>
     *
     * @param getLabelDetectionRequest
     * @return A Java Future containing the result of the GetLabelDetection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetLabelDetection
     */
    default CompletableFuture<GetLabelDetectionResponse> getLabelDetection(GetLabelDetectionRequest getLabelDetectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the label detection results of a Amazon Rekognition Video analysis started by .
     * </p>
     * <p>
     * The label detection operation is started by a call to which returns a job identifier (<code>JobId</code>). When
     * the label detection operation finishes, Amazon Rekognition publishes a completion status to the Amazon Simple
     * Notification Service topic registered in the initial call to <code>StartlabelDetection</code>. To get the results
     * of the label detection operation, first check that the status value published to the Amazon SNS topic is
     * <code>SUCCEEDED</code>. If so, call and pass the job identifier (<code>JobId</code>) from the initial call to
     * <code>StartLabelDetection</code>.
     * </p>
     * <p>
     * <code>GetLabelDetection</code> returns an array of detected labels (<code>Labels</code>) sorted by the time the
     * labels were detected. You can also sort by the label name by specifying <code>NAME</code> for the
     * <code>SortBy</code> input parameter.
     * </p>
     * <p>
     * The labels returned include the label name, the percentage confidence in the accuracy of the detected label, and
     * the time the label was detected in the video.
     * </p>
     * <p>
     * Use MaxResults parameter to limit the number of labels returned. If there are more results than specified in
     * <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination
     * token for getting the next set of results. To get the next page of results, call <code>GetlabelDetection</code>
     * and populate the <code>NextToken</code> request parameter with the token value returned from the previous call to
     * <code>GetLabelDetection</code>.
     * </p>
     * <note>
     * <p>
     * <code>GetLabelDetection</code> doesn't return a hierarchical taxonomy, or bounding box information, for detected
     * labels. <code>GetLabelDetection</code> returns <code>null</code> for the <code>Parents</code> and
     * <code>Instances</code> attributes of the object which is returned in the <code>Labels</code> array.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLabelDetectionRequest.Builder} avoiding the need
     * to create one manually via {@link GetLabelDetectionRequest#builder()}
     * </p>
     *
     * @param getLabelDetectionRequest
     *        A {@link Consumer} that will call methods on {@link GetLabelDetectionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetLabelDetection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetLabelDetection
     */
    default CompletableFuture<GetLabelDetectionResponse> getLabelDetection(
            Consumer<GetLabelDetectionRequest.Builder> getLabelDetectionRequest) {
        return getLabelDetection(GetLabelDetectionRequest.builder().applyMutation(getLabelDetectionRequest).build());
    }

    /**
     * <p>
     * Gets the label detection results of a Amazon Rekognition Video analysis started by .
     * </p>
     * <p>
     * The label detection operation is started by a call to which returns a job identifier (<code>JobId</code>). When
     * the label detection operation finishes, Amazon Rekognition publishes a completion status to the Amazon Simple
     * Notification Service topic registered in the initial call to <code>StartlabelDetection</code>. To get the results
     * of the label detection operation, first check that the status value published to the Amazon SNS topic is
     * <code>SUCCEEDED</code>. If so, call and pass the job identifier (<code>JobId</code>) from the initial call to
     * <code>StartLabelDetection</code>.
     * </p>
     * <p>
     * <code>GetLabelDetection</code> returns an array of detected labels (<code>Labels</code>) sorted by the time the
     * labels were detected. You can also sort by the label name by specifying <code>NAME</code> for the
     * <code>SortBy</code> input parameter.
     * </p>
     * <p>
     * The labels returned include the label name, the percentage confidence in the accuracy of the detected label, and
     * the time the label was detected in the video.
     * </p>
     * <p>
     * Use MaxResults parameter to limit the number of labels returned. If there are more results than specified in
     * <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination
     * token for getting the next set of results. To get the next page of results, call <code>GetlabelDetection</code>
     * and populate the <code>NextToken</code> request parameter with the token value returned from the previous call to
     * <code>GetLabelDetection</code>.
     * </p>
     * <note>
     * <p>
     * <code>GetLabelDetection</code> doesn't return a hierarchical taxonomy, or bounding box information, for detected
     * labels. <code>GetLabelDetection</code> returns <code>null</code> for the <code>Parents</code> and
     * <code>Instances</code> attributes of the object which is returned in the <code>Labels</code> array.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getLabelDetection(software.amazon.awssdk.services.rekognition.model.GetLabelDetectionRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetLabelDetectionPublisher publisher = client.getLabelDetectionPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetLabelDetectionPublisher publisher = client.getLabelDetectionPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rekognition.model.GetLabelDetectionResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rekognition.model.GetLabelDetectionResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getLabelDetection(software.amazon.awssdk.services.rekognition.model.GetLabelDetectionRequest)}
     * operation.</b>
     * </p>
     *
     * @param getLabelDetectionRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetLabelDetection
     */
    default GetLabelDetectionPublisher getLabelDetectionPaginator(GetLabelDetectionRequest getLabelDetectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the label detection results of a Amazon Rekognition Video analysis started by .
     * </p>
     * <p>
     * The label detection operation is started by a call to which returns a job identifier (<code>JobId</code>). When
     * the label detection operation finishes, Amazon Rekognition publishes a completion status to the Amazon Simple
     * Notification Service topic registered in the initial call to <code>StartlabelDetection</code>. To get the results
     * of the label detection operation, first check that the status value published to the Amazon SNS topic is
     * <code>SUCCEEDED</code>. If so, call and pass the job identifier (<code>JobId</code>) from the initial call to
     * <code>StartLabelDetection</code>.
     * </p>
     * <p>
     * <code>GetLabelDetection</code> returns an array of detected labels (<code>Labels</code>) sorted by the time the
     * labels were detected. You can also sort by the label name by specifying <code>NAME</code> for the
     * <code>SortBy</code> input parameter.
     * </p>
     * <p>
     * The labels returned include the label name, the percentage confidence in the accuracy of the detected label, and
     * the time the label was detected in the video.
     * </p>
     * <p>
     * Use MaxResults parameter to limit the number of labels returned. If there are more results than specified in
     * <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination
     * token for getting the next set of results. To get the next page of results, call <code>GetlabelDetection</code>
     * and populate the <code>NextToken</code> request parameter with the token value returned from the previous call to
     * <code>GetLabelDetection</code>.
     * </p>
     * <note>
     * <p>
     * <code>GetLabelDetection</code> doesn't return a hierarchical taxonomy, or bounding box information, for detected
     * labels. <code>GetLabelDetection</code> returns <code>null</code> for the <code>Parents</code> and
     * <code>Instances</code> attributes of the object which is returned in the <code>Labels</code> array.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getLabelDetection(software.amazon.awssdk.services.rekognition.model.GetLabelDetectionRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetLabelDetectionPublisher publisher = client.getLabelDetectionPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetLabelDetectionPublisher publisher = client.getLabelDetectionPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rekognition.model.GetLabelDetectionResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rekognition.model.GetLabelDetectionResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getLabelDetection(software.amazon.awssdk.services.rekognition.model.GetLabelDetectionRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLabelDetectionRequest.Builder} avoiding the need
     * to create one manually via {@link GetLabelDetectionRequest#builder()}
     * </p>
     *
     * @param getLabelDetectionRequest
     *        A {@link Consumer} that will call methods on {@link GetLabelDetectionRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetLabelDetection
     */
    default GetLabelDetectionPublisher getLabelDetectionPaginator(
            Consumer<GetLabelDetectionRequest.Builder> getLabelDetectionRequest) {
        return getLabelDetectionPaginator(GetLabelDetectionRequest.builder().applyMutation(getLabelDetectionRequest).build());
    }

    /**
     * <p>
     * Gets the path tracking results of a Amazon Rekognition Video analysis started by .
     * </p>
     * <p>
     * The person path tracking operation is started by a call to <code>StartPersonTracking</code> which returns a job
     * identifier (<code>JobId</code>). When the operation finishes, Amazon Rekognition Video publishes a completion
     * status to the Amazon Simple Notification Service topic registered in the initial call to
     * <code>StartPersonTracking</code>.
     * </p>
     * <p>
     * To get the results of the person path tracking operation, first check that the status value published to the
     * Amazon SNS topic is <code>SUCCEEDED</code>. If so, call and pass the job identifier (<code>JobId</code>) from the
     * initial call to <code>StartPersonTracking</code>.
     * </p>
     * <p>
     * <code>GetPersonTracking</code> returns an array, <code>Persons</code>, of tracked persons and the time(s) their
     * paths were tracked in the video.
     * </p>
     * <note>
     * <p>
     * <code>GetPersonTracking</code> only returns the default facial attributes (<code>BoundingBox</code>,
     * <code>Confidence</code>, <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>). The other facial
     * attributes listed in the <code>Face</code> object of the following response syntax are not returned.
     * </p>
     * <p>
     * For more information, see FaceDetail in the Amazon Rekognition Developer Guide.
     * </p>
     * </note>
     * <p>
     * By default, the array is sorted by the time(s) a person's path is tracked in the video. You can sort by tracked
     * persons by specifying <code>INDEX</code> for the <code>SortBy</code> input parameter.
     * </p>
     * <p>
     * Use the <code>MaxResults</code> parameter to limit the number of items returned. If there are more results than
     * specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a
     * pagination token for getting the next set of results. To get the next page of results, call
     * <code>GetPersonTracking</code> and populate the <code>NextToken</code> request parameter with the token value
     * returned from the previous call to <code>GetPersonTracking</code>.
     * </p>
     *
     * @param getPersonTrackingRequest
     * @return A Java Future containing the result of the GetPersonTracking operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetPersonTracking
     */
    default CompletableFuture<GetPersonTrackingResponse> getPersonTracking(GetPersonTrackingRequest getPersonTrackingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the path tracking results of a Amazon Rekognition Video analysis started by .
     * </p>
     * <p>
     * The person path tracking operation is started by a call to <code>StartPersonTracking</code> which returns a job
     * identifier (<code>JobId</code>). When the operation finishes, Amazon Rekognition Video publishes a completion
     * status to the Amazon Simple Notification Service topic registered in the initial call to
     * <code>StartPersonTracking</code>.
     * </p>
     * <p>
     * To get the results of the person path tracking operation, first check that the status value published to the
     * Amazon SNS topic is <code>SUCCEEDED</code>. If so, call and pass the job identifier (<code>JobId</code>) from the
     * initial call to <code>StartPersonTracking</code>.
     * </p>
     * <p>
     * <code>GetPersonTracking</code> returns an array, <code>Persons</code>, of tracked persons and the time(s) their
     * paths were tracked in the video.
     * </p>
     * <note>
     * <p>
     * <code>GetPersonTracking</code> only returns the default facial attributes (<code>BoundingBox</code>,
     * <code>Confidence</code>, <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>). The other facial
     * attributes listed in the <code>Face</code> object of the following response syntax are not returned.
     * </p>
     * <p>
     * For more information, see FaceDetail in the Amazon Rekognition Developer Guide.
     * </p>
     * </note>
     * <p>
     * By default, the array is sorted by the time(s) a person's path is tracked in the video. You can sort by tracked
     * persons by specifying <code>INDEX</code> for the <code>SortBy</code> input parameter.
     * </p>
     * <p>
     * Use the <code>MaxResults</code> parameter to limit the number of items returned. If there are more results than
     * specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a
     * pagination token for getting the next set of results. To get the next page of results, call
     * <code>GetPersonTracking</code> and populate the <code>NextToken</code> request parameter with the token value
     * returned from the previous call to <code>GetPersonTracking</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPersonTrackingRequest.Builder} avoiding the need
     * to create one manually via {@link GetPersonTrackingRequest#builder()}
     * </p>
     *
     * @param getPersonTrackingRequest
     *        A {@link Consumer} that will call methods on {@link GetPersonTrackingRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPersonTracking operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetPersonTracking
     */
    default CompletableFuture<GetPersonTrackingResponse> getPersonTracking(
            Consumer<GetPersonTrackingRequest.Builder> getPersonTrackingRequest) {
        return getPersonTracking(GetPersonTrackingRequest.builder().applyMutation(getPersonTrackingRequest).build());
    }

    /**
     * <p>
     * Gets the path tracking results of a Amazon Rekognition Video analysis started by .
     * </p>
     * <p>
     * The person path tracking operation is started by a call to <code>StartPersonTracking</code> which returns a job
     * identifier (<code>JobId</code>). When the operation finishes, Amazon Rekognition Video publishes a completion
     * status to the Amazon Simple Notification Service topic registered in the initial call to
     * <code>StartPersonTracking</code>.
     * </p>
     * <p>
     * To get the results of the person path tracking operation, first check that the status value published to the
     * Amazon SNS topic is <code>SUCCEEDED</code>. If so, call and pass the job identifier (<code>JobId</code>) from the
     * initial call to <code>StartPersonTracking</code>.
     * </p>
     * <p>
     * <code>GetPersonTracking</code> returns an array, <code>Persons</code>, of tracked persons and the time(s) their
     * paths were tracked in the video.
     * </p>
     * <note>
     * <p>
     * <code>GetPersonTracking</code> only returns the default facial attributes (<code>BoundingBox</code>,
     * <code>Confidence</code>, <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>). The other facial
     * attributes listed in the <code>Face</code> object of the following response syntax are not returned.
     * </p>
     * <p>
     * For more information, see FaceDetail in the Amazon Rekognition Developer Guide.
     * </p>
     * </note>
     * <p>
     * By default, the array is sorted by the time(s) a person's path is tracked in the video. You can sort by tracked
     * persons by specifying <code>INDEX</code> for the <code>SortBy</code> input parameter.
     * </p>
     * <p>
     * Use the <code>MaxResults</code> parameter to limit the number of items returned. If there are more results than
     * specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a
     * pagination token for getting the next set of results. To get the next page of results, call
     * <code>GetPersonTracking</code> and populate the <code>NextToken</code> request parameter with the token value
     * returned from the previous call to <code>GetPersonTracking</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getPersonTracking(software.amazon.awssdk.services.rekognition.model.GetPersonTrackingRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetPersonTrackingPublisher publisher = client.getPersonTrackingPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetPersonTrackingPublisher publisher = client.getPersonTrackingPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rekognition.model.GetPersonTrackingResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rekognition.model.GetPersonTrackingResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPersonTracking(software.amazon.awssdk.services.rekognition.model.GetPersonTrackingRequest)}
     * operation.</b>
     * </p>
     *
     * @param getPersonTrackingRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetPersonTracking
     */
    default GetPersonTrackingPublisher getPersonTrackingPaginator(GetPersonTrackingRequest getPersonTrackingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the path tracking results of a Amazon Rekognition Video analysis started by .
     * </p>
     * <p>
     * The person path tracking operation is started by a call to <code>StartPersonTracking</code> which returns a job
     * identifier (<code>JobId</code>). When the operation finishes, Amazon Rekognition Video publishes a completion
     * status to the Amazon Simple Notification Service topic registered in the initial call to
     * <code>StartPersonTracking</code>.
     * </p>
     * <p>
     * To get the results of the person path tracking operation, first check that the status value published to the
     * Amazon SNS topic is <code>SUCCEEDED</code>. If so, call and pass the job identifier (<code>JobId</code>) from the
     * initial call to <code>StartPersonTracking</code>.
     * </p>
     * <p>
     * <code>GetPersonTracking</code> returns an array, <code>Persons</code>, of tracked persons and the time(s) their
     * paths were tracked in the video.
     * </p>
     * <note>
     * <p>
     * <code>GetPersonTracking</code> only returns the default facial attributes (<code>BoundingBox</code>,
     * <code>Confidence</code>, <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>). The other facial
     * attributes listed in the <code>Face</code> object of the following response syntax are not returned.
     * </p>
     * <p>
     * For more information, see FaceDetail in the Amazon Rekognition Developer Guide.
     * </p>
     * </note>
     * <p>
     * By default, the array is sorted by the time(s) a person's path is tracked in the video. You can sort by tracked
     * persons by specifying <code>INDEX</code> for the <code>SortBy</code> input parameter.
     * </p>
     * <p>
     * Use the <code>MaxResults</code> parameter to limit the number of items returned. If there are more results than
     * specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a
     * pagination token for getting the next set of results. To get the next page of results, call
     * <code>GetPersonTracking</code> and populate the <code>NextToken</code> request parameter with the token value
     * returned from the previous call to <code>GetPersonTracking</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getPersonTracking(software.amazon.awssdk.services.rekognition.model.GetPersonTrackingRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetPersonTrackingPublisher publisher = client.getPersonTrackingPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.GetPersonTrackingPublisher publisher = client.getPersonTrackingPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rekognition.model.GetPersonTrackingResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rekognition.model.GetPersonTrackingResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPersonTracking(software.amazon.awssdk.services.rekognition.model.GetPersonTrackingRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPersonTrackingRequest.Builder} avoiding the need
     * to create one manually via {@link GetPersonTrackingRequest#builder()}
     * </p>
     *
     * @param getPersonTrackingRequest
     *        A {@link Consumer} that will call methods on {@link GetPersonTrackingRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetPersonTracking
     */
    default GetPersonTrackingPublisher getPersonTrackingPaginator(
            Consumer<GetPersonTrackingRequest.Builder> getPersonTrackingRequest) {
        return getPersonTrackingPaginator(GetPersonTrackingRequest.builder().applyMutation(getPersonTrackingRequest).build());
    }

    /**
     * <p>
     * Detects faces in the input image and adds them to the specified collection.
     * </p>
     * <p>
     * Amazon Rekognition doesn't save the actual faces that are detected. Instead, the underlying detection algorithm
     * first detects the faces in the input image. For each face, the algorithm extracts facial features into a feature
     * vector, and stores it in the backend database. Amazon Rekognition uses feature vectors when it performs face
     * match and search operations using the and operations.
     * </p>
     * <p>
     * For more information, see Adding Faces to a Collection in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * To get the number of faces in a collection, call .
     * </p>
     * <p>
     * If you're using version 1.0 of the face detection model, <code>IndexFaces</code> indexes the 15 largest faces in
     * the input image. Later versions of the face detection model index the 100 largest faces in the input image. To
     * determine which version of the model you're using, call and supply the collection ID. You can also get the model
     * version from the value of <code>FaceModelVersion</code> in the response from <code>IndexFaces</code>.
     * </p>
     * <p>
     * For more information, see Model Versioning in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * If you provide the optional <code>ExternalImageID</code> for the input image you provided, Amazon Rekognition
     * associates this ID with all faces that it detects. When you call the operation, the response returns the external
     * ID. You can use this external image ID to create a client-side index to associate the faces with each image. You
     * can then use the index to find all faces in an image.
     * </p>
     * <p>
     * You can specify the maximum number of faces to index with the <code>MaxFaces</code> input parameter. This is
     * useful when you want to index the largest faces in an image and don't want to index smaller faces, such as those
     * belonging to people standing in the background.
     * </p>
     * <p>
     * The <code>QualityFilter</code> input parameter allows you to filter out detected faces that don’t meet the
     * required quality bar chosen by Amazon Rekognition. The quality bar is based on a variety of common use cases. By
     * default, <code>IndexFaces</code> filters detected faces. You can also explicitly filter detected faces by
     * specifying <code>AUTO</code> for the value of <code>QualityFilter</code>. If you do not want to filter detected
     * faces, specify <code>NONE</code>.
     * </p>
     * <note>
     * <p>
     * To use quality filtering, you need a collection associated with version 3 of the face model. To get the version
     * of the face model associated with a collection, call .
     * </p>
     * </note>
     * <p>
     * Information about faces detected in an image, but not indexed, is returned in an array of objects,
     * <code>UnindexedFaces</code>. Faces aren't indexed for reasons such as:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The number of faces detected exceeds the value of the <code>MaxFaces</code> request parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * The face is too small compared to the image dimensions.
     * </p>
     * </li>
     * <li>
     * <p>
     * The face is too blurry.
     * </p>
     * </li>
     * <li>
     * <p>
     * The image is too dark.
     * </p>
     * </li>
     * <li>
     * <p>
     * The face has an extreme pose.
     * </p>
     * </li>
     * </ul>
     * <p>
     * In response, the <code>IndexFaces</code> operation returns an array of metadata for all detected faces,
     * <code>FaceRecords</code>. This includes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The bounding box, <code>BoundingBox</code>, of the detected face.
     * </p>
     * </li>
     * <li>
     * <p>
     * A confidence value, <code>Confidence</code>, which indicates the confidence that the bounding box contains a
     * face.
     * </p>
     * </li>
     * <li>
     * <p>
     * A face ID, <code>faceId</code>, assigned by the service for each face that's detected and stored.
     * </p>
     * </li>
     * <li>
     * <p>
     * An image ID, <code>ImageId</code>, assigned by the service for the input image.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you request all facial attributes (by using the <code>detectionAttributes</code> parameter), Amazon
     * Rekognition returns detailed facial attributes, such as facial landmarks (for example, location of eye and mouth)
     * and other facial attributes like gender. If you provide the same image, specify the same collection, and use the
     * same external ID in the <code>IndexFaces</code> operation, Amazon Rekognition doesn't save duplicate face
     * metadata.
     * </p>
     * <p/>
     * <p>
     * The input image is passed either as base64-encoded image bytes, or as a reference to an image in an Amazon S3
     * bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes isn't supported. The
     * image must be formatted as a PNG or JPEG file.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:IndexFaces</code> action.
     * </p>
     *
     * @param indexFacesRequest
     * @return A Java Future containing the result of the IndexFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. For more information, see
     *         Limits in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.IndexFaces
     */
    default CompletableFuture<IndexFacesResponse> indexFaces(IndexFacesRequest indexFacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detects faces in the input image and adds them to the specified collection.
     * </p>
     * <p>
     * Amazon Rekognition doesn't save the actual faces that are detected. Instead, the underlying detection algorithm
     * first detects the faces in the input image. For each face, the algorithm extracts facial features into a feature
     * vector, and stores it in the backend database. Amazon Rekognition uses feature vectors when it performs face
     * match and search operations using the and operations.
     * </p>
     * <p>
     * For more information, see Adding Faces to a Collection in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * To get the number of faces in a collection, call .
     * </p>
     * <p>
     * If you're using version 1.0 of the face detection model, <code>IndexFaces</code> indexes the 15 largest faces in
     * the input image. Later versions of the face detection model index the 100 largest faces in the input image. To
     * determine which version of the model you're using, call and supply the collection ID. You can also get the model
     * version from the value of <code>FaceModelVersion</code> in the response from <code>IndexFaces</code>.
     * </p>
     * <p>
     * For more information, see Model Versioning in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * If you provide the optional <code>ExternalImageID</code> for the input image you provided, Amazon Rekognition
     * associates this ID with all faces that it detects. When you call the operation, the response returns the external
     * ID. You can use this external image ID to create a client-side index to associate the faces with each image. You
     * can then use the index to find all faces in an image.
     * </p>
     * <p>
     * You can specify the maximum number of faces to index with the <code>MaxFaces</code> input parameter. This is
     * useful when you want to index the largest faces in an image and don't want to index smaller faces, such as those
     * belonging to people standing in the background.
     * </p>
     * <p>
     * The <code>QualityFilter</code> input parameter allows you to filter out detected faces that don’t meet the
     * required quality bar chosen by Amazon Rekognition. The quality bar is based on a variety of common use cases. By
     * default, <code>IndexFaces</code> filters detected faces. You can also explicitly filter detected faces by
     * specifying <code>AUTO</code> for the value of <code>QualityFilter</code>. If you do not want to filter detected
     * faces, specify <code>NONE</code>.
     * </p>
     * <note>
     * <p>
     * To use quality filtering, you need a collection associated with version 3 of the face model. To get the version
     * of the face model associated with a collection, call .
     * </p>
     * </note>
     * <p>
     * Information about faces detected in an image, but not indexed, is returned in an array of objects,
     * <code>UnindexedFaces</code>. Faces aren't indexed for reasons such as:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The number of faces detected exceeds the value of the <code>MaxFaces</code> request parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * The face is too small compared to the image dimensions.
     * </p>
     * </li>
     * <li>
     * <p>
     * The face is too blurry.
     * </p>
     * </li>
     * <li>
     * <p>
     * The image is too dark.
     * </p>
     * </li>
     * <li>
     * <p>
     * The face has an extreme pose.
     * </p>
     * </li>
     * </ul>
     * <p>
     * In response, the <code>IndexFaces</code> operation returns an array of metadata for all detected faces,
     * <code>FaceRecords</code>. This includes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The bounding box, <code>BoundingBox</code>, of the detected face.
     * </p>
     * </li>
     * <li>
     * <p>
     * A confidence value, <code>Confidence</code>, which indicates the confidence that the bounding box contains a
     * face.
     * </p>
     * </li>
     * <li>
     * <p>
     * A face ID, <code>faceId</code>, assigned by the service for each face that's detected and stored.
     * </p>
     * </li>
     * <li>
     * <p>
     * An image ID, <code>ImageId</code>, assigned by the service for the input image.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you request all facial attributes (by using the <code>detectionAttributes</code> parameter), Amazon
     * Rekognition returns detailed facial attributes, such as facial landmarks (for example, location of eye and mouth)
     * and other facial attributes like gender. If you provide the same image, specify the same collection, and use the
     * same external ID in the <code>IndexFaces</code> operation, Amazon Rekognition doesn't save duplicate face
     * metadata.
     * </p>
     * <p/>
     * <p>
     * The input image is passed either as base64-encoded image bytes, or as a reference to an image in an Amazon S3
     * bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes isn't supported. The
     * image must be formatted as a PNG or JPEG file.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:IndexFaces</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link IndexFacesRequest.Builder} avoiding the need to
     * create one manually via {@link IndexFacesRequest#builder()}
     * </p>
     *
     * @param indexFacesRequest
     *        A {@link Consumer} that will call methods on {@link IndexFacesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the IndexFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. For more information, see
     *         Limits in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.IndexFaces
     */
    default CompletableFuture<IndexFacesResponse> indexFaces(Consumer<IndexFacesRequest.Builder> indexFacesRequest) {
        return indexFaces(IndexFacesRequest.builder().applyMutation(indexFacesRequest).build());
    }

    /**
     * <p>
     * Returns list of collection IDs in your account. If the result is truncated, the response also provides a
     * <code>NextToken</code> that you can use in the subsequent request to fetch the next set of collection IDs.
     * </p>
     * <p>
     * For an example, see Listing Collections in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:ListCollections</code> action.
     * </p>
     *
     * @param listCollectionsRequest
     * @return A Java Future containing the result of the ListCollections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListCollections
     */
    default CompletableFuture<ListCollectionsResponse> listCollections(ListCollectionsRequest listCollectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns list of collection IDs in your account. If the result is truncated, the response also provides a
     * <code>NextToken</code> that you can use in the subsequent request to fetch the next set of collection IDs.
     * </p>
     * <p>
     * For an example, see Listing Collections in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:ListCollections</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCollectionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCollectionsRequest#builder()}
     * </p>
     *
     * @param listCollectionsRequest
     *        A {@link Consumer} that will call methods on {@link ListCollectionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListCollections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListCollections
     */
    default CompletableFuture<ListCollectionsResponse> listCollections(
            Consumer<ListCollectionsRequest.Builder> listCollectionsRequest) {
        return listCollections(ListCollectionsRequest.builder().applyMutation(listCollectionsRequest).build());
    }

    /**
     * <p>
     * Returns list of collection IDs in your account. If the result is truncated, the response also provides a
     * <code>NextToken</code> that you can use in the subsequent request to fetch the next set of collection IDs.
     * </p>
     * <p>
     * For an example, see Listing Collections in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:ListCollections</code> action.
     * </p>
     *
     * @return A Java Future containing the result of the ListCollections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListCollections
     */
    default CompletableFuture<ListCollectionsResponse> listCollections() {
        return listCollections(ListCollectionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns list of collection IDs in your account. If the result is truncated, the response also provides a
     * <code>NextToken</code> that you can use in the subsequent request to fetch the next set of collection IDs.
     * </p>
     * <p>
     * For an example, see Listing Collections in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:ListCollections</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCollections(software.amazon.awssdk.services.rekognition.model.ListCollectionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.ListCollectionsPublisher publisher = client.listCollectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.ListCollectionsPublisher publisher = client.listCollectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollections(software.amazon.awssdk.services.rekognition.model.ListCollectionsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListCollections
     */
    default ListCollectionsPublisher listCollectionsPaginator() {
        return listCollectionsPaginator(ListCollectionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns list of collection IDs in your account. If the result is truncated, the response also provides a
     * <code>NextToken</code> that you can use in the subsequent request to fetch the next set of collection IDs.
     * </p>
     * <p>
     * For an example, see Listing Collections in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:ListCollections</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCollections(software.amazon.awssdk.services.rekognition.model.ListCollectionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.ListCollectionsPublisher publisher = client.listCollectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.ListCollectionsPublisher publisher = client.listCollectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollections(software.amazon.awssdk.services.rekognition.model.ListCollectionsRequest)} operation.</b>
     * </p>
     *
     * @param listCollectionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListCollections
     */
    default ListCollectionsPublisher listCollectionsPaginator(ListCollectionsRequest listCollectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns list of collection IDs in your account. If the result is truncated, the response also provides a
     * <code>NextToken</code> that you can use in the subsequent request to fetch the next set of collection IDs.
     * </p>
     * <p>
     * For an example, see Listing Collections in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:ListCollections</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCollections(software.amazon.awssdk.services.rekognition.model.ListCollectionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.ListCollectionsPublisher publisher = client.listCollectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.ListCollectionsPublisher publisher = client.listCollectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollections(software.amazon.awssdk.services.rekognition.model.ListCollectionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCollectionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCollectionsRequest#builder()}
     * </p>
     *
     * @param listCollectionsRequest
     *        A {@link Consumer} that will call methods on {@link ListCollectionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListCollections
     */
    default ListCollectionsPublisher listCollectionsPaginator(Consumer<ListCollectionsRequest.Builder> listCollectionsRequest) {
        return listCollectionsPaginator(ListCollectionsRequest.builder().applyMutation(listCollectionsRequest).build());
    }

    /**
     * <p>
     * Returns metadata for faces in the specified collection. This metadata includes information such as the bounding
     * box coordinates, the confidence (that the bounding box contains a face), and face ID. For an example, see Listing
     * Faces in a Collection in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:ListFaces</code> action.
     * </p>
     *
     * @param listFacesRequest
     * @return A Java Future containing the result of the ListFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListFaces
     */
    default CompletableFuture<ListFacesResponse> listFaces(ListFacesRequest listFacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata for faces in the specified collection. This metadata includes information such as the bounding
     * box coordinates, the confidence (that the bounding box contains a face), and face ID. For an example, see Listing
     * Faces in a Collection in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:ListFaces</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListFacesRequest#builder()}
     * </p>
     *
     * @param listFacesRequest
     *        A {@link Consumer} that will call methods on {@link ListFacesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListFaces
     */
    default CompletableFuture<ListFacesResponse> listFaces(Consumer<ListFacesRequest.Builder> listFacesRequest) {
        return listFaces(ListFacesRequest.builder().applyMutation(listFacesRequest).build());
    }

    /**
     * <p>
     * Returns metadata for faces in the specified collection. This metadata includes information such as the bounding
     * box coordinates, the confidence (that the bounding box contains a face), and face ID. For an example, see Listing
     * Faces in a Collection in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:ListFaces</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFaces(software.amazon.awssdk.services.rekognition.model.ListFacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.ListFacesPublisher publisher = client.listFacesPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.ListFacesPublisher publisher = client.listFacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rekognition.model.ListFacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rekognition.model.ListFacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFaces(software.amazon.awssdk.services.rekognition.model.ListFacesRequest)} operation.</b>
     * </p>
     *
     * @param listFacesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListFaces
     */
    default ListFacesPublisher listFacesPaginator(ListFacesRequest listFacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata for faces in the specified collection. This metadata includes information such as the bounding
     * box coordinates, the confidence (that the bounding box contains a face), and face ID. For an example, see Listing
     * Faces in a Collection in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:ListFaces</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFaces(software.amazon.awssdk.services.rekognition.model.ListFacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.ListFacesPublisher publisher = client.listFacesPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.ListFacesPublisher publisher = client.listFacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rekognition.model.ListFacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rekognition.model.ListFacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFaces(software.amazon.awssdk.services.rekognition.model.ListFacesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListFacesRequest#builder()}
     * </p>
     *
     * @param listFacesRequest
     *        A {@link Consumer} that will call methods on {@link ListFacesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListFaces
     */
    default ListFacesPublisher listFacesPaginator(Consumer<ListFacesRequest.Builder> listFacesRequest) {
        return listFacesPaginator(ListFacesRequest.builder().applyMutation(listFacesRequest).build());
    }

    /**
     * <p>
     * Gets a list of stream processors that you have created with .
     * </p>
     *
     * @param listStreamProcessorsRequest
     * @return A Java Future containing the result of the ListStreamProcessors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListStreamProcessors
     */
    default CompletableFuture<ListStreamProcessorsResponse> listStreamProcessors(
            ListStreamProcessorsRequest listStreamProcessorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of stream processors that you have created with .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamProcessorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStreamProcessorsRequest#builder()}
     * </p>
     *
     * @param listStreamProcessorsRequest
     *        A {@link Consumer} that will call methods on {@link ListStreamProcessorsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListStreamProcessors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListStreamProcessors
     */
    default CompletableFuture<ListStreamProcessorsResponse> listStreamProcessors(
            Consumer<ListStreamProcessorsRequest.Builder> listStreamProcessorsRequest) {
        return listStreamProcessors(ListStreamProcessorsRequest.builder().applyMutation(listStreamProcessorsRequest).build());
    }

    /**
     * <p>
     * Gets a list of stream processors that you have created with .
     * </p>
     *
     * @return A Java Future containing the result of the ListStreamProcessors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListStreamProcessors
     */
    default CompletableFuture<ListStreamProcessorsResponse> listStreamProcessors() {
        return listStreamProcessors(ListStreamProcessorsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of stream processors that you have created with .
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStreamProcessors(software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.ListStreamProcessorsPublisher publisher = client.listStreamProcessorsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.ListStreamProcessorsPublisher publisher = client.listStreamProcessorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreamProcessors(software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListStreamProcessors
     */
    default ListStreamProcessorsPublisher listStreamProcessorsPaginator() {
        return listStreamProcessorsPaginator(ListStreamProcessorsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of stream processors that you have created with .
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStreamProcessors(software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.ListStreamProcessorsPublisher publisher = client.listStreamProcessorsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.ListStreamProcessorsPublisher publisher = client.listStreamProcessorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreamProcessors(software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStreamProcessorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListStreamProcessors
     */
    default ListStreamProcessorsPublisher listStreamProcessorsPaginator(ListStreamProcessorsRequest listStreamProcessorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of stream processors that you have created with .
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStreamProcessors(software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.ListStreamProcessorsPublisher publisher = client.listStreamProcessorsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rekognition.paginators.ListStreamProcessorsPublisher publisher = client.listStreamProcessorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreamProcessors(software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamProcessorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStreamProcessorsRequest#builder()}
     * </p>
     *
     * @param listStreamProcessorsRequest
     *        A {@link Consumer} that will call methods on {@link ListStreamProcessorsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListStreamProcessors
     */
    default ListStreamProcessorsPublisher listStreamProcessorsPaginator(
            Consumer<ListStreamProcessorsRequest.Builder> listStreamProcessorsRequest) {
        return listStreamProcessorsPaginator(ListStreamProcessorsRequest.builder().applyMutation(listStreamProcessorsRequest)
                .build());
    }

    /**
     * <p>
     * Returns an array of celebrities recognized in the input image. For more information, see Recognizing Celebrities
     * in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * <code>RecognizeCelebrities</code> returns the 100 largest faces in the image. It lists recognized celebrities in
     * the <code>CelebrityFaces</code> array and unrecognized faces in the <code>UnrecognizedFaces</code> array.
     * <code>RecognizeCelebrities</code> doesn't return celebrities whose faces aren't among the largest 100 faces in
     * the image.
     * </p>
     * <p>
     * For each celebrity recognized, <code>RecognizeCelebrities</code> returns a <code>Celebrity</code> object. The
     * <code>Celebrity</code> object contains the celebrity name, ID, URL links to additional information, match
     * confidence, and a <code>ComparedFace</code> object that you can use to locate the celebrity's face on the image.
     * </p>
     * <p>
     * Amazon Rekognition doesn't retain information about which images a celebrity has been recognized in. Your
     * application must store this information and use the <code>Celebrity</code> ID property as a unique identifier for
     * the celebrity. If you don't store the celebrity name or additional information URLs returned by
     * <code>RecognizeCelebrities</code>, you will need the ID to identify the celebrity in a call to the operation.
     * </p>
     * <p>
     * You pass the input image either as base64-encoded image bytes or as a reference to an image in an Amazon S3
     * bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The
     * image must be either a PNG or JPEG formatted file.
     * </p>
     * <p>
     * For an example, see Recognizing Celebrities in an Image in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:RecognizeCelebrities</code> operation.
     * </p>
     *
     * @param recognizeCelebritiesRequest
     * @return A Java Future containing the result of the RecognizeCelebrities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. For more information, see
     *         Limits in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.RecognizeCelebrities
     */
    default CompletableFuture<RecognizeCelebritiesResponse> recognizeCelebrities(
            RecognizeCelebritiesRequest recognizeCelebritiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of celebrities recognized in the input image. For more information, see Recognizing Celebrities
     * in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * <code>RecognizeCelebrities</code> returns the 100 largest faces in the image. It lists recognized celebrities in
     * the <code>CelebrityFaces</code> array and unrecognized faces in the <code>UnrecognizedFaces</code> array.
     * <code>RecognizeCelebrities</code> doesn't return celebrities whose faces aren't among the largest 100 faces in
     * the image.
     * </p>
     * <p>
     * For each celebrity recognized, <code>RecognizeCelebrities</code> returns a <code>Celebrity</code> object. The
     * <code>Celebrity</code> object contains the celebrity name, ID, URL links to additional information, match
     * confidence, and a <code>ComparedFace</code> object that you can use to locate the celebrity's face on the image.
     * </p>
     * <p>
     * Amazon Rekognition doesn't retain information about which images a celebrity has been recognized in. Your
     * application must store this information and use the <code>Celebrity</code> ID property as a unique identifier for
     * the celebrity. If you don't store the celebrity name or additional information URLs returned by
     * <code>RecognizeCelebrities</code>, you will need the ID to identify the celebrity in a call to the operation.
     * </p>
     * <p>
     * You pass the input image either as base64-encoded image bytes or as a reference to an image in an Amazon S3
     * bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The
     * image must be either a PNG or JPEG formatted file.
     * </p>
     * <p>
     * For an example, see Recognizing Celebrities in an Image in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:RecognizeCelebrities</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RecognizeCelebritiesRequest.Builder} avoiding the
     * need to create one manually via {@link RecognizeCelebritiesRequest#builder()}
     * </p>
     *
     * @param recognizeCelebritiesRequest
     *        A {@link Consumer} that will call methods on {@link RecognizeCelebritiesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RecognizeCelebrities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. For more information, see
     *         Limits in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.RecognizeCelebrities
     */
    default CompletableFuture<RecognizeCelebritiesResponse> recognizeCelebrities(
            Consumer<RecognizeCelebritiesRequest.Builder> recognizeCelebritiesRequest) {
        return recognizeCelebrities(RecognizeCelebritiesRequest.builder().applyMutation(recognizeCelebritiesRequest).build());
    }

    /**
     * <p>
     * For a given input face ID, searches for matching faces in the collection the face belongs to. You get a face ID
     * when you add a face to the collection using the <a>IndexFaces</a> operation. The operation compares the features
     * of the input face with faces in the specified collection.
     * </p>
     * <note>
     * <p>
     * You can also search faces without indexing faces by using the <code>SearchFacesByImage</code> operation.
     * </p>
     * </note>
     * <p>
     * The operation response returns an array of faces that match, ordered by similarity score with the highest
     * similarity first. More specifically, it is an array of metadata for each face match that is found. Along with the
     * metadata, the response also includes a <code>confidence</code> value for each face match, indicating the
     * confidence that the specific face matches the input face.
     * </p>
     * <p>
     * For an example, see Searching for a Face Using Its Face ID in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:SearchFaces</code> action.
     * </p>
     *
     * @param searchFacesRequest
     * @return A Java Future containing the result of the SearchFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.SearchFaces
     */
    default CompletableFuture<SearchFacesResponse> searchFaces(SearchFacesRequest searchFacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a given input face ID, searches for matching faces in the collection the face belongs to. You get a face ID
     * when you add a face to the collection using the <a>IndexFaces</a> operation. The operation compares the features
     * of the input face with faces in the specified collection.
     * </p>
     * <note>
     * <p>
     * You can also search faces without indexing faces by using the <code>SearchFacesByImage</code> operation.
     * </p>
     * </note>
     * <p>
     * The operation response returns an array of faces that match, ordered by similarity score with the highest
     * similarity first. More specifically, it is an array of metadata for each face match that is found. Along with the
     * metadata, the response also includes a <code>confidence</code> value for each face match, indicating the
     * confidence that the specific face matches the input face.
     * </p>
     * <p>
     * For an example, see Searching for a Face Using Its Face ID in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:SearchFaces</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchFacesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchFacesRequest#builder()}
     * </p>
     *
     * @param searchFacesRequest
     *        A {@link Consumer} that will call methods on {@link SearchFacesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SearchFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.SearchFaces
     */
    default CompletableFuture<SearchFacesResponse> searchFaces(Consumer<SearchFacesRequest.Builder> searchFacesRequest) {
        return searchFaces(SearchFacesRequest.builder().applyMutation(searchFacesRequest).build());
    }

    /**
     * <p>
     * For a given input image, first detects the largest face in the image, and then searches the specified collection
     * for matching faces. The operation compares the features of the input face with faces in the specified collection.
     * </p>
     * <note>
     * <p>
     * To search for all faces in an input image, you might first call the operation, and then use the face IDs returned
     * in subsequent calls to the operation.
     * </p>
     * <p>
     * You can also call the <code>DetectFaces</code> operation and use the bounding boxes in the response to make face
     * crops, which then you can pass in to the <code>SearchFacesByImage</code> operation.
     * </p>
     * </note>
     * <p>
     * You pass the input image either as base64-encoded image bytes or as a reference to an image in an Amazon S3
     * bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The
     * image must be either a PNG or JPEG formatted file.
     * </p>
     * <p>
     * The response returns an array of faces that match, ordered by similarity score with the highest similarity first.
     * More specifically, it is an array of metadata for each face match found. Along with the metadata, the response
     * also includes a <code>similarity</code> indicating how similar the face is to the input face. In the response,
     * the operation also returns the bounding box (and a confidence level that the bounding box contains a face) of the
     * face that Amazon Rekognition used for the input image.
     * </p>
     * <p>
     * For an example, Searching for a Face Using an Image in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:SearchFacesByImage</code> action.
     * </p>
     *
     * @param searchFacesByImageRequest
     * @return A Java Future containing the result of the SearchFacesByImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. For more information, see
     *         Limits in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.SearchFacesByImage
     */
    default CompletableFuture<SearchFacesByImageResponse> searchFacesByImage(SearchFacesByImageRequest searchFacesByImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a given input image, first detects the largest face in the image, and then searches the specified collection
     * for matching faces. The operation compares the features of the input face with faces in the specified collection.
     * </p>
     * <note>
     * <p>
     * To search for all faces in an input image, you might first call the operation, and then use the face IDs returned
     * in subsequent calls to the operation.
     * </p>
     * <p>
     * You can also call the <code>DetectFaces</code> operation and use the bounding boxes in the response to make face
     * crops, which then you can pass in to the <code>SearchFacesByImage</code> operation.
     * </p>
     * </note>
     * <p>
     * You pass the input image either as base64-encoded image bytes or as a reference to an image in an Amazon S3
     * bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The
     * image must be either a PNG or JPEG formatted file.
     * </p>
     * <p>
     * The response returns an array of faces that match, ordered by similarity score with the highest similarity first.
     * More specifically, it is an array of metadata for each face match found. Along with the metadata, the response
     * also includes a <code>similarity</code> indicating how similar the face is to the input face. In the response,
     * the operation also returns the bounding box (and a confidence level that the bounding box contains a face) of the
     * face that Amazon Rekognition used for the input image.
     * </p>
     * <p>
     * For an example, Searching for a Face Using an Image in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:SearchFacesByImage</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchFacesByImageRequest.Builder} avoiding the
     * need to create one manually via {@link SearchFacesByImageRequest#builder()}
     * </p>
     *
     * @param searchFacesByImageRequest
     *        A {@link Consumer} that will call methods on {@link SearchFacesByImageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SearchFacesByImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. For more information, see
     *         Limits in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.SearchFacesByImage
     */
    default CompletableFuture<SearchFacesByImageResponse> searchFacesByImage(
            Consumer<SearchFacesByImageRequest.Builder> searchFacesByImageRequest) {
        return searchFacesByImage(SearchFacesByImageRequest.builder().applyMutation(searchFacesByImageRequest).build());
    }

    /**
     * <p>
     * Starts asynchronous recognition of celebrities in a stored video.
     * </p>
     * <p>
     * Amazon Rekognition Video can detect celebrities in a video must be stored in an Amazon S3 bucket. Use
     * <a>Video</a> to specify the bucket name and the filename of the video. <code>StartCelebrityRecognition</code>
     * returns a job identifier (<code>JobId</code>) which you use to get the results of the analysis. When celebrity
     * recognition analysis is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple
     * Notification Service topic that you specify in <code>NotificationChannel</code>. To get the results of the
     * celebrity recognition analysis, first check that the status value published to the Amazon SNS topic is
     * <code>SUCCEEDED</code>. If so, call and pass the job identifier (<code>JobId</code>) from the initial call to
     * <code>StartCelebrityRecognition</code>.
     * </p>
     * <p>
     * For more information, see Recognizing Celebrities in the Amazon Rekognition Developer Guide.
     * </p>
     *
     * @param startCelebrityRecognitionRequest
     * @return A Java Future containing the result of the StartCelebrityRecognition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>VideoTooLargeException The file size or duration of the supplied media is too large. The maximum file
     *         size is 8GB. The maximum duration is 2 hours.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many Amazon Rekognition Video jobs concurrently, calls to start operations (
     *         <code>StartLabelDetection</code>, for example) will raise a <code>LimitExceededException</code> exception
     *         (HTTP status code: 400) until the number of concurrently running jobs is below the Amazon Rekognition
     *         service limit.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartCelebrityRecognition
     */
    default CompletableFuture<StartCelebrityRecognitionResponse> startCelebrityRecognition(
            StartCelebrityRecognitionRequest startCelebrityRecognitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts asynchronous recognition of celebrities in a stored video.
     * </p>
     * <p>
     * Amazon Rekognition Video can detect celebrities in a video must be stored in an Amazon S3 bucket. Use
     * <a>Video</a> to specify the bucket name and the filename of the video. <code>StartCelebrityRecognition</code>
     * returns a job identifier (<code>JobId</code>) which you use to get the results of the analysis. When celebrity
     * recognition analysis is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple
     * Notification Service topic that you specify in <code>NotificationChannel</code>. To get the results of the
     * celebrity recognition analysis, first check that the status value published to the Amazon SNS topic is
     * <code>SUCCEEDED</code>. If so, call and pass the job identifier (<code>JobId</code>) from the initial call to
     * <code>StartCelebrityRecognition</code>.
     * </p>
     * <p>
     * For more information, see Recognizing Celebrities in the Amazon Rekognition Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCelebrityRecognitionRequest.Builder} avoiding
     * the need to create one manually via {@link StartCelebrityRecognitionRequest#builder()}
     * </p>
     *
     * @param startCelebrityRecognitionRequest
     *        A {@link Consumer} that will call methods on {@link StartCelebrityRecognitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartCelebrityRecognition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>VideoTooLargeException The file size or duration of the supplied media is too large. The maximum file
     *         size is 8GB. The maximum duration is 2 hours.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many Amazon Rekognition Video jobs concurrently, calls to start operations (
     *         <code>StartLabelDetection</code>, for example) will raise a <code>LimitExceededException</code> exception
     *         (HTTP status code: 400) until the number of concurrently running jobs is below the Amazon Rekognition
     *         service limit.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartCelebrityRecognition
     */
    default CompletableFuture<StartCelebrityRecognitionResponse> startCelebrityRecognition(
            Consumer<StartCelebrityRecognitionRequest.Builder> startCelebrityRecognitionRequest) {
        return startCelebrityRecognition(StartCelebrityRecognitionRequest.builder()
                .applyMutation(startCelebrityRecognitionRequest).build());
    }

    /**
     * <p>
     * Starts asynchronous detection of explicit or suggestive adult content in a stored video.
     * </p>
     * <p>
     * Amazon Rekognition Video can moderate content in a video stored in an Amazon S3 bucket. Use <a>Video</a> to
     * specify the bucket name and the filename of the video. <code>StartContentModeration</code> returns a job
     * identifier (<code>JobId</code>) which you use to get the results of the analysis. When content moderation
     * analysis is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification
     * Service topic that you specify in <code>NotificationChannel</code>.
     * </p>
     * <p>
     * To get the results of the content moderation analysis, first check that the status value published to the Amazon
     * SNS topic is <code>SUCCEEDED</code>. If so, call and pass the job identifier (<code>JobId</code>) from the
     * initial call to <code>StartContentModeration</code>.
     * </p>
     * <p>
     * For more information, see Detecting Unsafe Content in the Amazon Rekognition Developer Guide.
     * </p>
     *
     * @param startContentModerationRequest
     * @return A Java Future containing the result of the StartContentModeration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>VideoTooLargeException The file size or duration of the supplied media is too large. The maximum file
     *         size is 8GB. The maximum duration is 2 hours.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many Amazon Rekognition Video jobs concurrently, calls to start operations (
     *         <code>StartLabelDetection</code>, for example) will raise a <code>LimitExceededException</code> exception
     *         (HTTP status code: 400) until the number of concurrently running jobs is below the Amazon Rekognition
     *         service limit.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartContentModeration
     */
    default CompletableFuture<StartContentModerationResponse> startContentModeration(
            StartContentModerationRequest startContentModerationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts asynchronous detection of explicit or suggestive adult content in a stored video.
     * </p>
     * <p>
     * Amazon Rekognition Video can moderate content in a video stored in an Amazon S3 bucket. Use <a>Video</a> to
     * specify the bucket name and the filename of the video. <code>StartContentModeration</code> returns a job
     * identifier (<code>JobId</code>) which you use to get the results of the analysis. When content moderation
     * analysis is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification
     * Service topic that you specify in <code>NotificationChannel</code>.
     * </p>
     * <p>
     * To get the results of the content moderation analysis, first check that the status value published to the Amazon
     * SNS topic is <code>SUCCEEDED</code>. If so, call and pass the job identifier (<code>JobId</code>) from the
     * initial call to <code>StartContentModeration</code>.
     * </p>
     * <p>
     * For more information, see Detecting Unsafe Content in the Amazon Rekognition Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartContentModerationRequest.Builder} avoiding the
     * need to create one manually via {@link StartContentModerationRequest#builder()}
     * </p>
     *
     * @param startContentModerationRequest
     *        A {@link Consumer} that will call methods on {@link StartContentModerationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartContentModeration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>VideoTooLargeException The file size or duration of the supplied media is too large. The maximum file
     *         size is 8GB. The maximum duration is 2 hours.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many Amazon Rekognition Video jobs concurrently, calls to start operations (
     *         <code>StartLabelDetection</code>, for example) will raise a <code>LimitExceededException</code> exception
     *         (HTTP status code: 400) until the number of concurrently running jobs is below the Amazon Rekognition
     *         service limit.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartContentModeration
     */
    default CompletableFuture<StartContentModerationResponse> startContentModeration(
            Consumer<StartContentModerationRequest.Builder> startContentModerationRequest) {
        return startContentModeration(StartContentModerationRequest.builder().applyMutation(startContentModerationRequest)
                .build());
    }

    /**
     * <p>
     * Starts asynchronous detection of faces in a stored video.
     * </p>
     * <p>
     * Amazon Rekognition Video can detect faces in a video stored in an Amazon S3 bucket. Use <a>Video</a> to specify
     * the bucket name and the filename of the video. <code>StartFaceDetection</code> returns a job identifier (
     * <code>JobId</code>) that you use to get the results of the operation. When face detection is finished, Amazon
     * Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic that you specify
     * in <code>NotificationChannel</code>. To get the results of the face detection operation, first check that the
     * status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call and pass the job identifier
     * (<code>JobId</code>) from the initial call to <code>StartFaceDetection</code>.
     * </p>
     * <p>
     * For more information, see Detecting Faces in a Stored Video in the Amazon Rekognition Developer Guide.
     * </p>
     *
     * @param startFaceDetectionRequest
     * @return A Java Future containing the result of the StartFaceDetection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>VideoTooLargeException The file size or duration of the supplied media is too large. The maximum file
     *         size is 8GB. The maximum duration is 2 hours.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many Amazon Rekognition Video jobs concurrently, calls to start operations (
     *         <code>StartLabelDetection</code>, for example) will raise a <code>LimitExceededException</code> exception
     *         (HTTP status code: 400) until the number of concurrently running jobs is below the Amazon Rekognition
     *         service limit.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartFaceDetection
     */
    default CompletableFuture<StartFaceDetectionResponse> startFaceDetection(StartFaceDetectionRequest startFaceDetectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts asynchronous detection of faces in a stored video.
     * </p>
     * <p>
     * Amazon Rekognition Video can detect faces in a video stored in an Amazon S3 bucket. Use <a>Video</a> to specify
     * the bucket name and the filename of the video. <code>StartFaceDetection</code> returns a job identifier (
     * <code>JobId</code>) that you use to get the results of the operation. When face detection is finished, Amazon
     * Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic that you specify
     * in <code>NotificationChannel</code>. To get the results of the face detection operation, first check that the
     * status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call and pass the job identifier
     * (<code>JobId</code>) from the initial call to <code>StartFaceDetection</code>.
     * </p>
     * <p>
     * For more information, see Detecting Faces in a Stored Video in the Amazon Rekognition Developer Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFaceDetectionRequest.Builder} avoiding the
     * need to create one manually via {@link StartFaceDetectionRequest#builder()}
     * </p>
     *
     * @param startFaceDetectionRequest
     *        A {@link Consumer} that will call methods on {@link StartFaceDetectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartFaceDetection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>VideoTooLargeException The file size or duration of the supplied media is too large. The maximum file
     *         size is 8GB. The maximum duration is 2 hours.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many Amazon Rekognition Video jobs concurrently, calls to start operations (
     *         <code>StartLabelDetection</code>, for example) will raise a <code>LimitExceededException</code> exception
     *         (HTTP status code: 400) until the number of concurrently running jobs is below the Amazon Rekognition
     *         service limit.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartFaceDetection
     */
    default CompletableFuture<StartFaceDetectionResponse> startFaceDetection(
            Consumer<StartFaceDetectionRequest.Builder> startFaceDetectionRequest) {
        return startFaceDetection(StartFaceDetectionRequest.builder().applyMutation(startFaceDetectionRequest).build());
    }

    /**
     * <p>
     * Starts the asynchronous search for faces in a collection that match the faces of persons detected in a stored
     * video.
     * </p>
     * <p>
     * The video must be stored in an Amazon S3 bucket. Use <a>Video</a> to specify the bucket name and the filename of
     * the video. <code>StartFaceSearch</code> returns a job identifier (<code>JobId</code>) which you use to get the
     * search results once the search has completed. When searching is finished, Amazon Rekognition Video publishes a
     * completion status to the Amazon Simple Notification Service topic that you specify in
     * <code>NotificationChannel</code>. To get the search results, first check that the status value published to the
     * Amazon SNS topic is <code>SUCCEEDED</code>. If so, call and pass the job identifier (<code>JobId</code>) from the
     * initial call to <code>StartFaceSearch</code>. For more information, see <a>procedure-person-search-videos</a>.
     * </p>
     *
     * @param startFaceSearchRequest
     * @return A Java Future containing the result of the StartFaceSearch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>VideoTooLargeException The file size or duration of the supplied media is too large. The maximum file
     *         size is 8GB. The maximum duration is 2 hours.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many Amazon Rekognition Video jobs concurrently, calls to start operations (
     *         <code>StartLabelDetection</code>, for example) will raise a <code>LimitExceededException</code> exception
     *         (HTTP status code: 400) until the number of concurrently running jobs is below the Amazon Rekognition
     *         service limit.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartFaceSearch
     */
    default CompletableFuture<StartFaceSearchResponse> startFaceSearch(StartFaceSearchRequest startFaceSearchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the asynchronous search for faces in a collection that match the faces of persons detected in a stored
     * video.
     * </p>
     * <p>
     * The video must be stored in an Amazon S3 bucket. Use <a>Video</a> to specify the bucket name and the filename of
     * the video. <code>StartFaceSearch</code> returns a job identifier (<code>JobId</code>) which you use to get the
     * search results once the search has completed. When searching is finished, Amazon Rekognition Video publishes a
     * completion status to the Amazon Simple Notification Service topic that you specify in
     * <code>NotificationChannel</code>. To get the search results, first check that the status value published to the
     * Amazon SNS topic is <code>SUCCEEDED</code>. If so, call and pass the job identifier (<code>JobId</code>) from the
     * initial call to <code>StartFaceSearch</code>. For more information, see <a>procedure-person-search-videos</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFaceSearchRequest.Builder} avoiding the need
     * to create one manually via {@link StartFaceSearchRequest#builder()}
     * </p>
     *
     * @param startFaceSearchRequest
     *        A {@link Consumer} that will call methods on {@link StartFaceSearchRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartFaceSearch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>VideoTooLargeException The file size or duration of the supplied media is too large. The maximum file
     *         size is 8GB. The maximum duration is 2 hours.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many Amazon Rekognition Video jobs concurrently, calls to start operations (
     *         <code>StartLabelDetection</code>, for example) will raise a <code>LimitExceededException</code> exception
     *         (HTTP status code: 400) until the number of concurrently running jobs is below the Amazon Rekognition
     *         service limit.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartFaceSearch
     */
    default CompletableFuture<StartFaceSearchResponse> startFaceSearch(
            Consumer<StartFaceSearchRequest.Builder> startFaceSearchRequest) {
        return startFaceSearch(StartFaceSearchRequest.builder().applyMutation(startFaceSearchRequest).build());
    }

    /**
     * <p>
     * Starts asynchronous detection of labels in a stored video.
     * </p>
     * <p>
     * Amazon Rekognition Video can detect labels in a video. Labels are instances of real-world entities. This includes
     * objects like flower, tree, and table; events like wedding, graduation, and birthday party; concepts like
     * landscape, evening, and nature; and activities like a person getting out of a car or a person skiing.
     * </p>
     * <p>
     * The video must be stored in an Amazon S3 bucket. Use <a>Video</a> to specify the bucket name and the filename of
     * the video. <code>StartLabelDetection</code> returns a job identifier (<code>JobId</code>) which you use to get
     * the results of the operation. When label detection is finished, Amazon Rekognition Video publishes a completion
     * status to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>.
     * </p>
     * <p>
     * To get the results of the label detection operation, first check that the status value published to the Amazon
     * SNS topic is <code>SUCCEEDED</code>. If so, call and pass the job identifier (<code>JobId</code>) from the
     * initial call to <code>StartLabelDetection</code>.
     * </p>
     * <p/>
     *
     * @param startLabelDetectionRequest
     * @return A Java Future containing the result of the StartLabelDetection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li> <li>
     *         IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused with an
     *         operation, but at least one of the other input parameters is different from the previous call to the
     *         operation.</li> <li>InvalidParameterException Input parameter violated a constraint. Validate your
     *         parameter before calling the API operation again.</li> <li>InvalidS3ObjectException Amazon Rekognition is
     *         unable to access the S3 object specified in the request.</li> <li>InternalServerErrorException Amazon
     *         Rekognition experienced a service issue. Try your call again.</li> <li>VideoTooLargeException The file
     *         size or duration of the supplied media is too large. The maximum file size is 8GB. The maximum duration
     *         is 2 hours.</li> <li>ProvisionedThroughputExceededException The number of requests exceeded your
     *         throughput limit. If you want to increase this limit, contact Amazon Rekognition.</li> <li>
     *         LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start too
     *         many Amazon Rekognition Video jobs concurrently, calls to start operations (<code>StartLabelDetection
     *         </code>, for example) will raise a <code>LimitExceededException</code> exception (HTTP status code: 400)
     *         until the number of concurrently running jobs is below the Amazon Rekognition service limit.</li> <li>
     *         ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call again.
     *         </li> <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li> <li>SdkClientException If any client side error occurs
     *         such as an IO related failure, failure to get credentials, etc.</li> <li>RekognitionException Base class
     *         for all service exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartLabelDetection
     */
    default CompletableFuture<StartLabelDetectionResponse> startLabelDetection(
            StartLabelDetectionRequest startLabelDetectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts asynchronous detection of labels in a stored video.
     * </p>
     * <p>
     * Amazon Rekognition Video can detect labels in a video. Labels are instances of real-world entities. This includes
     * objects like flower, tree, and table; events like wedding, graduation, and birthday party; concepts like
     * landscape, evening, and nature; and activities like a person getting out of a car or a person skiing.
     * </p>
     * <p>
     * The video must be stored in an Amazon S3 bucket. Use <a>Video</a> to specify the bucket name and the filename of
     * the video. <code>StartLabelDetection</code> returns a job identifier (<code>JobId</code>) which you use to get
     * the results of the operation. When label detection is finished, Amazon Rekognition Video publishes a completion
     * status to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>.
     * </p>
     * <p>
     * To get the results of the label detection operation, first check that the status value published to the Amazon
     * SNS topic is <code>SUCCEEDED</code>. If so, call and pass the job identifier (<code>JobId</code>) from the
     * initial call to <code>StartLabelDetection</code>.
     * </p>
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartLabelDetectionRequest.Builder} avoiding the
     * need to create one manually via {@link StartLabelDetectionRequest#builder()}
     * </p>
     *
     * @param startLabelDetectionRequest
     *        A {@link Consumer} that will call methods on {@link StartLabelDetectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartLabelDetection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>VideoTooLargeException The file size or duration of the supplied media is too large. The maximum file
     *         size is 8GB. The maximum duration is 2 hours.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many Amazon Rekognition Video jobs concurrently, calls to start operations (
     *         <code>StartLabelDetection</code>, for example) will raise a <code>LimitExceededException</code> exception
     *         (HTTP status code: 400) until the number of concurrently running jobs is below the Amazon Rekognition
     *         service limit.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartLabelDetection
     */
    default CompletableFuture<StartLabelDetectionResponse> startLabelDetection(
            Consumer<StartLabelDetectionRequest.Builder> startLabelDetectionRequest) {
        return startLabelDetection(StartLabelDetectionRequest.builder().applyMutation(startLabelDetectionRequest).build());
    }

    /**
     * <p>
     * Starts the asynchronous tracking of a person's path in a stored video.
     * </p>
     * <p>
     * Amazon Rekognition Video can track the path of people in a video stored in an Amazon S3 bucket. Use <a>Video</a>
     * to specify the bucket name and the filename of the video. <code>StartPersonTracking</code> returns a job
     * identifier (<code>JobId</code>) which you use to get the results of the operation. When label detection is
     * finished, Amazon Rekognition publishes a completion status to the Amazon Simple Notification Service topic that
     * you specify in <code>NotificationChannel</code>.
     * </p>
     * <p>
     * To get the results of the person detection operation, first check that the status value published to the Amazon
     * SNS topic is <code>SUCCEEDED</code>. If so, call and pass the job identifier (<code>JobId</code>) from the
     * initial call to <code>StartPersonTracking</code>.
     * </p>
     *
     * @param startPersonTrackingRequest
     * @return A Java Future containing the result of the StartPersonTracking operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>VideoTooLargeException The file size or duration of the supplied media is too large. The maximum file
     *         size is 8GB. The maximum duration is 2 hours.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many Amazon Rekognition Video jobs concurrently, calls to start operations (
     *         <code>StartLabelDetection</code>, for example) will raise a <code>LimitExceededException</code> exception
     *         (HTTP status code: 400) until the number of concurrently running jobs is below the Amazon Rekognition
     *         service limit.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartPersonTracking
     */
    default CompletableFuture<StartPersonTrackingResponse> startPersonTracking(
            StartPersonTrackingRequest startPersonTrackingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the asynchronous tracking of a person's path in a stored video.
     * </p>
     * <p>
     * Amazon Rekognition Video can track the path of people in a video stored in an Amazon S3 bucket. Use <a>Video</a>
     * to specify the bucket name and the filename of the video. <code>StartPersonTracking</code> returns a job
     * identifier (<code>JobId</code>) which you use to get the results of the operation. When label detection is
     * finished, Amazon Rekognition publishes a completion status to the Amazon Simple Notification Service topic that
     * you specify in <code>NotificationChannel</code>.
     * </p>
     * <p>
     * To get the results of the person detection operation, first check that the status value published to the Amazon
     * SNS topic is <code>SUCCEEDED</code>. If so, call and pass the job identifier (<code>JobId</code>) from the
     * initial call to <code>StartPersonTracking</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartPersonTrackingRequest.Builder} avoiding the
     * need to create one manually via {@link StartPersonTrackingRequest#builder()}
     * </p>
     *
     * @param startPersonTrackingRequest
     *        A {@link Consumer} that will call methods on {@link StartPersonTrackingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartPersonTracking operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>VideoTooLargeException The file size or duration of the supplied media is too large. The maximum file
     *         size is 8GB. The maximum duration is 2 hours.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many Amazon Rekognition Video jobs concurrently, calls to start operations (
     *         <code>StartLabelDetection</code>, for example) will raise a <code>LimitExceededException</code> exception
     *         (HTTP status code: 400) until the number of concurrently running jobs is below the Amazon Rekognition
     *         service limit.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartPersonTracking
     */
    default CompletableFuture<StartPersonTrackingResponse> startPersonTracking(
            Consumer<StartPersonTrackingRequest.Builder> startPersonTrackingRequest) {
        return startPersonTracking(StartPersonTrackingRequest.builder().applyMutation(startPersonTrackingRequest).build());
    }

    /**
     * <p>
     * Starts processing a stream processor. You create a stream processor by calling . To tell
     * <code>StartStreamProcessor</code> which stream processor to start, use the value of the <code>Name</code> field
     * specified in the call to <code>CreateStreamProcessor</code>.
     * </p>
     *
     * @param startStreamProcessorRequest
     * @return A Java Future containing the result of the StartStreamProcessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ResourceInUseException</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartStreamProcessor
     */
    default CompletableFuture<StartStreamProcessorResponse> startStreamProcessor(
            StartStreamProcessorRequest startStreamProcessorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts processing a stream processor. You create a stream processor by calling . To tell
     * <code>StartStreamProcessor</code> which stream processor to start, use the value of the <code>Name</code> field
     * specified in the call to <code>CreateStreamProcessor</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartStreamProcessorRequest.Builder} avoiding the
     * need to create one manually via {@link StartStreamProcessorRequest#builder()}
     * </p>
     *
     * @param startStreamProcessorRequest
     *        A {@link Consumer} that will call methods on {@link StartStreamProcessorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartStreamProcessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ResourceInUseException</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartStreamProcessor
     */
    default CompletableFuture<StartStreamProcessorResponse> startStreamProcessor(
            Consumer<StartStreamProcessorRequest.Builder> startStreamProcessorRequest) {
        return startStreamProcessor(StartStreamProcessorRequest.builder().applyMutation(startStreamProcessorRequest).build());
    }

    /**
     * <p>
     * Stops a running stream processor that was created by .
     * </p>
     *
     * @param stopStreamProcessorRequest
     * @return A Java Future containing the result of the StopStreamProcessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ResourceInUseException</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StopStreamProcessor
     */
    default CompletableFuture<StopStreamProcessorResponse> stopStreamProcessor(
            StopStreamProcessorRequest stopStreamProcessorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a running stream processor that was created by .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopStreamProcessorRequest.Builder} avoiding the
     * need to create one manually via {@link StopStreamProcessorRequest#builder()}
     * </p>
     *
     * @param stopStreamProcessorRequest
     *        A {@link Consumer} that will call methods on {@link StopStreamProcessorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopStreamProcessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ResourceNotFoundException The collection specified in the request cannot be found.</li>
     *         <li>ResourceInUseException</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StopStreamProcessor
     */
    default CompletableFuture<StopStreamProcessorResponse> stopStreamProcessor(
            Consumer<StopStreamProcessorRequest.Builder> stopStreamProcessorRequest) {
        return stopStreamProcessor(StopStreamProcessorRequest.builder().applyMutation(stopStreamProcessorRequest).build());
    }
}
