/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectModerationLabelsResponse extends RekognitionResponse implements
        ToCopyableBuilder<DetectModerationLabelsResponse.Builder, DetectModerationLabelsResponse> {
    private static final SdkField<List<ModerationLabel>> MODERATION_LABELS_FIELD = SdkField
            .<List<ModerationLabel>> builder(MarshallingType.LIST)
            .getter(getter(DetectModerationLabelsResponse::moderationLabels))
            .setter(setter(Builder::moderationLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModerationLabels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModerationLabel> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModerationLabel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODERATION_LABELS_FIELD));

    private final List<ModerationLabel> moderationLabels;

    private DetectModerationLabelsResponse(BuilderImpl builder) {
        super(builder);
        this.moderationLabels = builder.moderationLabels;
    }

    /**
     * <p>
     * Array of detected Moderation labels and the time, in millseconds from the start of the video, they were detected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Array of detected Moderation labels and the time, in millseconds from the start of the video, they were
     *         detected.
     */
    public List<ModerationLabel> moderationLabels() {
        return moderationLabels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(moderationLabels());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectModerationLabelsResponse)) {
            return false;
        }
        DetectModerationLabelsResponse other = (DetectModerationLabelsResponse) obj;
        return Objects.equals(moderationLabels(), other.moderationLabels());
    }

    @Override
    public String toString() {
        return ToString.builder("DetectModerationLabelsResponse").add("ModerationLabels", moderationLabels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModerationLabels":
            return Optional.ofNullable(clazz.cast(moderationLabels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectModerationLabelsResponse, T> g) {
        return obj -> g.apply((DetectModerationLabelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DetectModerationLabelsResponse> {
        /**
         * <p>
         * Array of detected Moderation labels and the time, in millseconds from the start of the video, they were
         * detected.
         * </p>
         * 
         * @param moderationLabels
         *        Array of detected Moderation labels and the time, in millseconds from the start of the video, they
         *        were detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moderationLabels(Collection<ModerationLabel> moderationLabels);

        /**
         * <p>
         * Array of detected Moderation labels and the time, in millseconds from the start of the video, they were
         * detected.
         * </p>
         * 
         * @param moderationLabels
         *        Array of detected Moderation labels and the time, in millseconds from the start of the video, they
         *        were detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moderationLabels(ModerationLabel... moderationLabels);

        /**
         * <p>
         * Array of detected Moderation labels and the time, in millseconds from the start of the video, they were
         * detected.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ModerationLabel>.Builder} avoiding the need
         * to create one manually via {@link List<ModerationLabel>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ModerationLabel>.Builder#build()} is called immediately and
         * its result is passed to {@link #moderationLabels(List<ModerationLabel>)}.
         * 
         * @param moderationLabels
         *        a consumer that will call methods on {@link List<ModerationLabel>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #moderationLabels(List<ModerationLabel>)
         */
        Builder moderationLabels(Consumer<ModerationLabel.Builder>... moderationLabels);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<ModerationLabel> moderationLabels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectModerationLabelsResponse model) {
            super(model);
            moderationLabels(model.moderationLabels);
        }

        public final Collection<ModerationLabel.Builder> getModerationLabels() {
            return moderationLabels != null ? moderationLabels.stream().map(ModerationLabel::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder moderationLabels(Collection<ModerationLabel> moderationLabels) {
            this.moderationLabels = ModerationLabelsCopier.copy(moderationLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder moderationLabels(ModerationLabel... moderationLabels) {
            moderationLabels(Arrays.asList(moderationLabels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder moderationLabels(Consumer<ModerationLabel.Builder>... moderationLabels) {
            moderationLabels(Stream.of(moderationLabels).map(c -> ModerationLabel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setModerationLabels(Collection<ModerationLabel.BuilderImpl> moderationLabels) {
            this.moderationLabels = ModerationLabelsCopier.copyFromBuilder(moderationLabels);
        }

        @Override
        public DetectModerationLabelsResponse build() {
            return new DetectModerationLabelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
