/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectTextResponse extends RekognitionResponse implements
        ToCopyableBuilder<DetectTextResponse.Builder, DetectTextResponse> {
    private static final SdkField<List<TextDetection>> TEXT_DETECTIONS_FIELD = SdkField
            .<List<TextDetection>> builder(MarshallingType.LIST)
            .getter(getter(DetectTextResponse::textDetections))
            .setter(setter(Builder::textDetections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextDetections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TextDetection> builder(MarshallingType.SDK_POJO)
                                            .constructor(TextDetection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_DETECTIONS_FIELD));

    private final List<TextDetection> textDetections;

    private DetectTextResponse(BuilderImpl builder) {
        super(builder);
        this.textDetections = builder.textDetections;
    }

    /**
     * <p>
     * An array of text that was detected in the input image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of text that was detected in the input image.
     */
    public List<TextDetection> textDetections() {
        return textDetections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(textDetections());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectTextResponse)) {
            return false;
        }
        DetectTextResponse other = (DetectTextResponse) obj;
        return Objects.equals(textDetections(), other.textDetections());
    }

    @Override
    public String toString() {
        return ToString.builder("DetectTextResponse").add("TextDetections", textDetections()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TextDetections":
            return Optional.ofNullable(clazz.cast(textDetections()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectTextResponse, T> g) {
        return obj -> g.apply((DetectTextResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, DetectTextResponse> {
        /**
         * <p>
         * An array of text that was detected in the input image.
         * </p>
         * 
         * @param textDetections
         *        An array of text that was detected in the input image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textDetections(Collection<TextDetection> textDetections);

        /**
         * <p>
         * An array of text that was detected in the input image.
         * </p>
         * 
         * @param textDetections
         *        An array of text that was detected in the input image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textDetections(TextDetection... textDetections);

        /**
         * <p>
         * An array of text that was detected in the input image.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TextDetection>.Builder} avoiding the need
         * to create one manually via {@link List<TextDetection>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TextDetection>.Builder#build()} is called immediately and
         * its result is passed to {@link #textDetections(List<TextDetection>)}.
         * 
         * @param textDetections
         *        a consumer that will call methods on {@link List<TextDetection>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textDetections(List<TextDetection>)
         */
        Builder textDetections(Consumer<TextDetection.Builder>... textDetections);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<TextDetection> textDetections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectTextResponse model) {
            super(model);
            textDetections(model.textDetections);
        }

        public final Collection<TextDetection.Builder> getTextDetections() {
            return textDetections != null ? textDetections.stream().map(TextDetection::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder textDetections(Collection<TextDetection> textDetections) {
            this.textDetections = TextDetectionListCopier.copy(textDetections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textDetections(TextDetection... textDetections) {
            textDetections(Arrays.asList(textDetections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textDetections(Consumer<TextDetection.Builder>... textDetections) {
            textDetections(Stream.of(textDetections).map(c -> TextDetection.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTextDetections(Collection<TextDetection.BuilderImpl> textDetections) {
            this.textDetections = TextDetectionListCopier.copyFromBuilder(textDetections);
        }

        @Override
        public DetectTextResponse build() {
            return new DetectTextResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
