/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about where the text detected by is located on an image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Geometry implements SdkPojo, Serializable, ToCopyableBuilder<Geometry.Builder, Geometry> {
    private static final SdkField<BoundingBox> BOUNDING_BOX_FIELD = SdkField.<BoundingBox> builder(MarshallingType.SDK_POJO)
            .getter(getter(Geometry::boundingBox)).setter(setter(Builder::boundingBox)).constructor(BoundingBox::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build()).build();

    private static final SdkField<List<Point>> POLYGON_FIELD = SdkField
            .<List<Point>> builder(MarshallingType.LIST)
            .getter(getter(Geometry::polygon))
            .setter(setter(Builder::polygon))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Polygon").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Point> builder(MarshallingType.SDK_POJO)
                                            .constructor(Point::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDING_BOX_FIELD,
            POLYGON_FIELD));

    private static final long serialVersionUID = 1L;

    private final BoundingBox boundingBox;

    private final List<Point> polygon;

    private Geometry(BuilderImpl builder) {
        this.boundingBox = builder.boundingBox;
        this.polygon = builder.polygon;
    }

    /**
     * <p>
     * An axis-aligned coarse representation of the detected text's location on the image.
     * </p>
     * 
     * @return An axis-aligned coarse representation of the detected text's location on the image.
     */
    public BoundingBox boundingBox() {
        return boundingBox;
    }

    /**
     * <p>
     * Within the bounding box, a fine-grained polygon around the detected text.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Within the bounding box, a fine-grained polygon around the detected text.
     */
    public List<Point> polygon() {
        return polygon;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(polygon());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Geometry)) {
            return false;
        }
        Geometry other = (Geometry) obj;
        return Objects.equals(boundingBox(), other.boundingBox()) && Objects.equals(polygon(), other.polygon());
    }

    @Override
    public String toString() {
        return ToString.builder("Geometry").add("BoundingBox", boundingBox()).add("Polygon", polygon()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BoundingBox":
            return Optional.ofNullable(clazz.cast(boundingBox()));
        case "Polygon":
            return Optional.ofNullable(clazz.cast(polygon()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Geometry, T> g) {
        return obj -> g.apply((Geometry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Geometry> {
        /**
         * <p>
         * An axis-aligned coarse representation of the detected text's location on the image.
         * </p>
         * 
         * @param boundingBox
         *        An axis-aligned coarse representation of the detected text's location on the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(BoundingBox boundingBox);

        /**
         * <p>
         * An axis-aligned coarse representation of the detected text's location on the image.
         * </p>
         * This is a convenience that creates an instance of the {@link BoundingBox.Builder} avoiding the need to create
         * one manually via {@link BoundingBox#builder()}.
         *
         * When the {@link Consumer} completes, {@link BoundingBox.Builder#build()} is called immediately and its result
         * is passed to {@link #boundingBox(BoundingBox)}.
         * 
         * @param boundingBox
         *        a consumer that will call methods on {@link BoundingBox.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #boundingBox(BoundingBox)
         */
        default Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return boundingBox(BoundingBox.builder().applyMutation(boundingBox).build());
        }

        /**
         * <p>
         * Within the bounding box, a fine-grained polygon around the detected text.
         * </p>
         * 
         * @param polygon
         *        Within the bounding box, a fine-grained polygon around the detected text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder polygon(Collection<Point> polygon);

        /**
         * <p>
         * Within the bounding box, a fine-grained polygon around the detected text.
         * </p>
         * 
         * @param polygon
         *        Within the bounding box, a fine-grained polygon around the detected text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder polygon(Point... polygon);

        /**
         * <p>
         * Within the bounding box, a fine-grained polygon around the detected text.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Point>.Builder} avoiding the need to create
         * one manually via {@link List<Point>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Point>.Builder#build()} is called immediately and its result
         * is passed to {@link #polygon(List<Point>)}.
         * 
         * @param polygon
         *        a consumer that will call methods on {@link List<Point>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #polygon(List<Point>)
         */
        Builder polygon(Consumer<Point.Builder>... polygon);
    }

    static final class BuilderImpl implements Builder {
        private BoundingBox boundingBox;

        private List<Point> polygon = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Geometry model) {
            boundingBox(model.boundingBox);
            polygon(model.polygon);
        }

        public final BoundingBox.Builder getBoundingBox() {
            return boundingBox != null ? boundingBox.toBuilder() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        public final Collection<Point.Builder> getPolygon() {
            return polygon != null ? polygon.stream().map(Point::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder polygon(Collection<Point> polygon) {
            this.polygon = PolygonCopier.copy(polygon);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder polygon(Point... polygon) {
            polygon(Arrays.asList(polygon));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder polygon(Consumer<Point.Builder>... polygon) {
            polygon(Stream.of(polygon).map(c -> Point.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolygon(Collection<Point.BuilderImpl> polygon) {
            this.polygon = PolygonCopier.copyFromBuilder(polygon);
        }

        @Override
        public Geometry build() {
            return new Geometry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
