/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCollectionResponse extends RekognitionResponse implements
        ToCopyableBuilder<CreateCollectionResponse.Builder, CreateCollectionResponse> {
    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateCollectionResponse::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final SdkField<String> COLLECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCollectionResponse::collectionArn)).setter(setter(Builder::collectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionArn").build()).build();

    private static final SdkField<String> FACE_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCollectionResponse::faceModelVersion)).setter(setter(Builder::faceModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceModelVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_CODE_FIELD,
            COLLECTION_ARN_FIELD, FACE_MODEL_VERSION_FIELD));

    private final Integer statusCode;

    private final String collectionArn;

    private final String faceModelVersion;

    private CreateCollectionResponse(BuilderImpl builder) {
        super(builder);
        this.statusCode = builder.statusCode;
        this.collectionArn = builder.collectionArn;
        this.faceModelVersion = builder.faceModelVersion;
    }

    /**
     * <p>
     * HTTP status code indicating the result of the operation.
     * </p>
     * 
     * @return HTTP status code indicating the result of the operation.
     */
    public Integer statusCode() {
        return statusCode;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the collection. You can use this to manage permissions on your resources.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the collection. You can use this to manage permissions on your resources.
     */
    public String collectionArn() {
        return collectionArn;
    }

    /**
     * <p>
     * Version number of the face detection model associated with the collection you are creating.
     * </p>
     * 
     * @return Version number of the face detection model associated with the collection you are creating.
     */
    public String faceModelVersion() {
        return faceModelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(collectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(faceModelVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCollectionResponse)) {
            return false;
        }
        CreateCollectionResponse other = (CreateCollectionResponse) obj;
        return Objects.equals(statusCode(), other.statusCode()) && Objects.equals(collectionArn(), other.collectionArn())
                && Objects.equals(faceModelVersion(), other.faceModelVersion());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateCollectionResponse").add("StatusCode", statusCode()).add("CollectionArn", collectionArn())
                .add("FaceModelVersion", faceModelVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "CollectionArn":
            return Optional.ofNullable(clazz.cast(collectionArn()));
        case "FaceModelVersion":
            return Optional.ofNullable(clazz.cast(faceModelVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCollectionResponse, T> g) {
        return obj -> g.apply((CreateCollectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateCollectionResponse> {
        /**
         * <p>
         * HTTP status code indicating the result of the operation.
         * </p>
         * 
         * @param statusCode
         *        HTTP status code indicating the result of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(Integer statusCode);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the collection. You can use this to manage permissions on your resources.
         * </p>
         * 
         * @param collectionArn
         *        Amazon Resource Name (ARN) of the collection. You can use this to manage permissions on your
         *        resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionArn(String collectionArn);

        /**
         * <p>
         * Version number of the face detection model associated with the collection you are creating.
         * </p>
         * 
         * @param faceModelVersion
         *        Version number of the face detection model associated with the collection you are creating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceModelVersion(String faceModelVersion);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private Integer statusCode;

        private String collectionArn;

        private String faceModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCollectionResponse model) {
            super(model);
            statusCode(model.statusCode);
            collectionArn(model.collectionArn);
            faceModelVersion(model.faceModelVersion);
        }

        public final Integer getStatusCode() {
            return statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public final String getCollectionArn() {
            return collectionArn;
        }

        @Override
        public final Builder collectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
            return this;
        }

        public final void setCollectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
        }

        public final String getFaceModelVersion() {
            return faceModelVersion;
        }

        @Override
        public final Builder faceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
            return this;
        }

        public final void setFaceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
        }

        @Override
        public CreateCollectionResponse build() {
            return new CreateCollectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
