/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectFacesResponse extends RekognitionResponse implements
        ToCopyableBuilder<DetectFacesResponse.Builder, DetectFacesResponse> {
    private static final SdkField<List<FaceDetail>> FACE_DETAILS_FIELD = SdkField
            .<List<FaceDetail>> builder(MarshallingType.LIST)
            .getter(getter(DetectFacesResponse::faceDetails))
            .setter(setter(Builder::faceDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FaceDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(FaceDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ORIENTATION_CORRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DetectFacesResponse::orientationCorrectionAsString)).setter(setter(Builder::orientationCorrection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrientationCorrection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACE_DETAILS_FIELD,
            ORIENTATION_CORRECTION_FIELD));

    private final List<FaceDetail> faceDetails;

    private final String orientationCorrection;

    private DetectFacesResponse(BuilderImpl builder) {
        super(builder);
        this.faceDetails = builder.faceDetails;
        this.orientationCorrection = builder.orientationCorrection;
    }

    /**
     * <p>
     * Details of each face found in the image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Details of each face found in the image.
     */
    public List<FaceDetail> faceDetails() {
        return faceDetails;
    }

    /**
     * <p>
     * The value of <code>OrientationCorrection</code> is always null.
     * </p>
     * <p>
     * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
     * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
     * correction. The bounding box coordinates are translated to represent object locations after the orientation
     * information in the Exif metadata is used to correct the image orientation. Images in .png format don't contain
     * Exif metadata.
     * </p>
     * <p>
     * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
     * orientation information in the image Exif metadata. The bounding box coordinates aren't translated and represent
     * the object locations before the image is rotated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #orientationCorrection} will return {@link OrientationCorrection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #orientationCorrectionAsString}.
     * </p>
     * 
     * @return The value of <code>OrientationCorrection</code> is always null.</p>
     *         <p>
     *         If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
     *         that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
     *         image correction. The bounding box coordinates are translated to represent object locations after the
     *         orientation information in the Exif metadata is used to correct the image orientation. Images in .png
     *         format don't contain Exif metadata.
     *         </p>
     *         <p>
     *         Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
     *         orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
     *         represent the object locations before the image is rotated.
     * @see OrientationCorrection
     */
    public OrientationCorrection orientationCorrection() {
        return OrientationCorrection.fromValue(orientationCorrection);
    }

    /**
     * <p>
     * The value of <code>OrientationCorrection</code> is always null.
     * </p>
     * <p>
     * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
     * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
     * correction. The bounding box coordinates are translated to represent object locations after the orientation
     * information in the Exif metadata is used to correct the image orientation. Images in .png format don't contain
     * Exif metadata.
     * </p>
     * <p>
     * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
     * orientation information in the image Exif metadata. The bounding box coordinates aren't translated and represent
     * the object locations before the image is rotated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #orientationCorrection} will return {@link OrientationCorrection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #orientationCorrectionAsString}.
     * </p>
     * 
     * @return The value of <code>OrientationCorrection</code> is always null.</p>
     *         <p>
     *         If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
     *         that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
     *         image correction. The bounding box coordinates are translated to represent object locations after the
     *         orientation information in the Exif metadata is used to correct the image orientation. Images in .png
     *         format don't contain Exif metadata.
     *         </p>
     *         <p>
     *         Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
     *         orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
     *         represent the object locations before the image is rotated.
     * @see OrientationCorrection
     */
    public String orientationCorrectionAsString() {
        return orientationCorrection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(faceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(orientationCorrectionAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectFacesResponse)) {
            return false;
        }
        DetectFacesResponse other = (DetectFacesResponse) obj;
        return Objects.equals(faceDetails(), other.faceDetails())
                && Objects.equals(orientationCorrectionAsString(), other.orientationCorrectionAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("DetectFacesResponse").add("FaceDetails", faceDetails())
                .add("OrientationCorrection", orientationCorrectionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FaceDetails":
            return Optional.ofNullable(clazz.cast(faceDetails()));
        case "OrientationCorrection":
            return Optional.ofNullable(clazz.cast(orientationCorrectionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectFacesResponse, T> g) {
        return obj -> g.apply((DetectFacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, DetectFacesResponse> {
        /**
         * <p>
         * Details of each face found in the image.
         * </p>
         * 
         * @param faceDetails
         *        Details of each face found in the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceDetails(Collection<FaceDetail> faceDetails);

        /**
         * <p>
         * Details of each face found in the image.
         * </p>
         * 
         * @param faceDetails
         *        Details of each face found in the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceDetails(FaceDetail... faceDetails);

        /**
         * <p>
         * Details of each face found in the image.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FaceDetail>.Builder} avoiding the need to
         * create one manually via {@link List<FaceDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FaceDetail>.Builder#build()} is called immediately and its
         * result is passed to {@link #faceDetails(List<FaceDetail>)}.
         * 
         * @param faceDetails
         *        a consumer that will call methods on {@link List<FaceDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #faceDetails(List<FaceDetail>)
         */
        Builder faceDetails(Consumer<FaceDetail.Builder>... faceDetails);

        /**
         * <p>
         * The value of <code>OrientationCorrection</code> is always null.
         * </p>
         * <p>
         * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
         * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
         * correction. The bounding box coordinates are translated to represent object locations after the orientation
         * information in the Exif metadata is used to correct the image orientation. Images in .png format don't
         * contain Exif metadata.
         * </p>
         * <p>
         * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
         * orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
         * represent the object locations before the image is rotated.
         * </p>
         * 
         * @param orientationCorrection
         *        The value of <code>OrientationCorrection</code> is always null.</p>
         *        <p>
         *        If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
         *        that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
         *        image correction. The bounding box coordinates are translated to represent object locations after the
         *        orientation information in the Exif metadata is used to correct the image orientation. Images in .png
         *        format don't contain Exif metadata.
         *        </p>
         *        <p>
         *        Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
         *        orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
         *        represent the object locations before the image is rotated.
         * @see OrientationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder orientationCorrection(String orientationCorrection);

        /**
         * <p>
         * The value of <code>OrientationCorrection</code> is always null.
         * </p>
         * <p>
         * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
         * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
         * correction. The bounding box coordinates are translated to represent object locations after the orientation
         * information in the Exif metadata is used to correct the image orientation. Images in .png format don't
         * contain Exif metadata.
         * </p>
         * <p>
         * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
         * orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
         * represent the object locations before the image is rotated.
         * </p>
         * 
         * @param orientationCorrection
         *        The value of <code>OrientationCorrection</code> is always null.</p>
         *        <p>
         *        If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
         *        that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
         *        image correction. The bounding box coordinates are translated to represent object locations after the
         *        orientation information in the Exif metadata is used to correct the image orientation. Images in .png
         *        format don't contain Exif metadata.
         *        </p>
         *        <p>
         *        Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
         *        orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
         *        represent the object locations before the image is rotated.
         * @see OrientationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder orientationCorrection(OrientationCorrection orientationCorrection);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<FaceDetail> faceDetails = DefaultSdkAutoConstructList.getInstance();

        private String orientationCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectFacesResponse model) {
            super(model);
            faceDetails(model.faceDetails);
            orientationCorrection(model.orientationCorrection);
        }

        public final Collection<FaceDetail.Builder> getFaceDetails() {
            return faceDetails != null ? faceDetails.stream().map(FaceDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder faceDetails(Collection<FaceDetail> faceDetails) {
            this.faceDetails = FaceDetailListCopier.copy(faceDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceDetails(FaceDetail... faceDetails) {
            faceDetails(Arrays.asList(faceDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceDetails(Consumer<FaceDetail.Builder>... faceDetails) {
            faceDetails(Stream.of(faceDetails).map(c -> FaceDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFaceDetails(Collection<FaceDetail.BuilderImpl> faceDetails) {
            this.faceDetails = FaceDetailListCopier.copyFromBuilder(faceDetails);
        }

        public final String getOrientationCorrection() {
            return orientationCorrection;
        }

        @Override
        public final Builder orientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
            return this;
        }

        @Override
        public final Builder orientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection.toString());
            return this;
        }

        public final void setOrientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
        }

        @Override
        public DetectFacesResponse build() {
            return new DetectFacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
