/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCelebrityRecognitionResponse extends RekognitionResponse implements
        ToCopyableBuilder<GetCelebrityRecognitionResponse.Builder, GetCelebrityRecognitionResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCelebrityRecognitionResponse::jobStatusAsString)).setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCelebrityRecognitionResponse::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<VideoMetadata> VIDEO_METADATA_FIELD = SdkField
            .<VideoMetadata> builder(MarshallingType.SDK_POJO).getter(getter(GetCelebrityRecognitionResponse::videoMetadata))
            .setter(setter(Builder::videoMetadata)).constructor(VideoMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VideoMetadata").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCelebrityRecognitionResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<CelebrityRecognition>> CELEBRITIES_FIELD = SdkField
            .<List<CelebrityRecognition>> builder(MarshallingType.LIST)
            .getter(getter(GetCelebrityRecognitionResponse::celebrities))
            .setter(setter(Builder::celebrities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Celebrities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CelebrityRecognition> builder(MarshallingType.SDK_POJO)
                                            .constructor(CelebrityRecognition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD,
            STATUS_MESSAGE_FIELD, VIDEO_METADATA_FIELD, NEXT_TOKEN_FIELD, CELEBRITIES_FIELD));

    private final String jobStatus;

    private final String statusMessage;

    private final VideoMetadata videoMetadata;

    private final String nextToken;

    private final List<CelebrityRecognition> celebrities;

    private GetCelebrityRecognitionResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.statusMessage = builder.statusMessage;
        this.videoMetadata = builder.videoMetadata;
        this.nextToken = builder.nextToken;
        this.celebrities = builder.celebrities;
    }

    /**
     * <p>
     * The current status of the celebrity recognition job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link VideoJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the celebrity recognition job.
     * @see VideoJobStatus
     */
    public VideoJobStatus jobStatus() {
        return VideoJobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The current status of the celebrity recognition job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link VideoJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the celebrity recognition job.
     * @see VideoJobStatus
     */
    public String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * If the job fails, <code>StatusMessage</code> provides a descriptive error message.
     * </p>
     * 
     * @return If the job fails, <code>StatusMessage</code> provides a descriptive error message.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Information about a video that Amazon Rekognition Video analyzed. <code>Videometadata</code> is returned in every
     * page of paginated responses from a Amazon Rekognition Video operation.
     * </p>
     * 
     * @return Information about a video that Amazon Rekognition Video analyzed. <code>Videometadata</code> is returned
     *         in every page of paginated responses from a Amazon Rekognition Video operation.
     */
    public VideoMetadata videoMetadata() {
        return videoMetadata;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent
     * request to retrieve the next set of celebrities.
     * </p>
     * 
     * @return If the response is truncated, Amazon Rekognition Video returns this token that you can use in the
     *         subsequent request to retrieve the next set of celebrities.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Array of celebrities recognized in the video.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Array of celebrities recognized in the video.
     */
    public List<CelebrityRecognition> celebrities() {
        return celebrities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(videoMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(celebrities());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCelebrityRecognitionResponse)) {
            return false;
        }
        GetCelebrityRecognitionResponse other = (GetCelebrityRecognitionResponse) obj;
        return Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(videoMetadata(), other.videoMetadata()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(celebrities(), other.celebrities());
    }

    @Override
    public String toString() {
        return ToString.builder("GetCelebrityRecognitionResponse").add("JobStatus", jobStatusAsString())
                .add("StatusMessage", statusMessage()).add("VideoMetadata", videoMetadata()).add("NextToken", nextToken())
                .add("Celebrities", celebrities()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "VideoMetadata":
            return Optional.ofNullable(clazz.cast(videoMetadata()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Celebrities":
            return Optional.ofNullable(clazz.cast(celebrities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCelebrityRecognitionResponse, T> g) {
        return obj -> g.apply((GetCelebrityRecognitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCelebrityRecognitionResponse> {
        /**
         * <p>
         * The current status of the celebrity recognition job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the celebrity recognition job.
         * @see VideoJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoJobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The current status of the celebrity recognition job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the celebrity recognition job.
         * @see VideoJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoJobStatus
         */
        Builder jobStatus(VideoJobStatus jobStatus);

        /**
         * <p>
         * If the job fails, <code>StatusMessage</code> provides a descriptive error message.
         * </p>
         * 
         * @param statusMessage
         *        If the job fails, <code>StatusMessage</code> provides a descriptive error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Information about a video that Amazon Rekognition Video analyzed. <code>Videometadata</code> is returned in
         * every page of paginated responses from a Amazon Rekognition Video operation.
         * </p>
         * 
         * @param videoMetadata
         *        Information about a video that Amazon Rekognition Video analyzed. <code>Videometadata</code> is
         *        returned in every page of paginated responses from a Amazon Rekognition Video operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoMetadata(VideoMetadata videoMetadata);

        /**
         * <p>
         * Information about a video that Amazon Rekognition Video analyzed. <code>Videometadata</code> is returned in
         * every page of paginated responses from a Amazon Rekognition Video operation.
         * </p>
         * This is a convenience that creates an instance of the {@link VideoMetadata.Builder} avoiding the need to
         * create one manually via {@link VideoMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link VideoMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #videoMetadata(VideoMetadata)}.
         * 
         * @param videoMetadata
         *        a consumer that will call methods on {@link VideoMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #videoMetadata(VideoMetadata)
         */
        default Builder videoMetadata(Consumer<VideoMetadata.Builder> videoMetadata) {
            return videoMetadata(VideoMetadata.builder().applyMutation(videoMetadata).build());
        }

        /**
         * <p>
         * If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent
         * request to retrieve the next set of celebrities.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Rekognition Video returns this token that you can use in the
         *        subsequent request to retrieve the next set of celebrities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Array of celebrities recognized in the video.
         * </p>
         * 
         * @param celebrities
         *        Array of celebrities recognized in the video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder celebrities(Collection<CelebrityRecognition> celebrities);

        /**
         * <p>
         * Array of celebrities recognized in the video.
         * </p>
         * 
         * @param celebrities
         *        Array of celebrities recognized in the video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder celebrities(CelebrityRecognition... celebrities);

        /**
         * <p>
         * Array of celebrities recognized in the video.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CelebrityRecognition>.Builder} avoiding the
         * need to create one manually via {@link List<CelebrityRecognition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CelebrityRecognition>.Builder#build()} is called immediately
         * and its result is passed to {@link #celebrities(List<CelebrityRecognition>)}.
         * 
         * @param celebrities
         *        a consumer that will call methods on {@link List<CelebrityRecognition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #celebrities(List<CelebrityRecognition>)
         */
        Builder celebrities(Consumer<CelebrityRecognition.Builder>... celebrities);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private String jobStatus;

        private String statusMessage;

        private VideoMetadata videoMetadata;

        private String nextToken;

        private List<CelebrityRecognition> celebrities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCelebrityRecognitionResponse model) {
            super(model);
            jobStatus(model.jobStatus);
            statusMessage(model.statusMessage);
            videoMetadata(model.videoMetadata);
            nextToken(model.nextToken);
            celebrities(model.celebrities);
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(VideoJobStatus jobStatus) {
            this.jobStatus(jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final VideoMetadata.Builder getVideoMetadata() {
            return videoMetadata != null ? videoMetadata.toBuilder() : null;
        }

        @Override
        public final Builder videoMetadata(VideoMetadata videoMetadata) {
            this.videoMetadata = videoMetadata;
            return this;
        }

        public final void setVideoMetadata(VideoMetadata.BuilderImpl videoMetadata) {
            this.videoMetadata = videoMetadata != null ? videoMetadata.build() : null;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<CelebrityRecognition.Builder> getCelebrities() {
            return celebrities != null ? celebrities.stream().map(CelebrityRecognition::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder celebrities(Collection<CelebrityRecognition> celebrities) {
            this.celebrities = CelebrityRecognitionsCopier.copy(celebrities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder celebrities(CelebrityRecognition... celebrities) {
            celebrities(Arrays.asList(celebrities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder celebrities(Consumer<CelebrityRecognition.Builder>... celebrities) {
            celebrities(Stream.of(celebrities).map(c -> CelebrityRecognition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCelebrities(Collection<CelebrityRecognition.BuilderImpl> celebrities) {
            this.celebrities = CelebrityRecognitionsCopier.copyFromBuilder(celebrities);
        }

        @Override
        public GetCelebrityRecognitionResponse build() {
            return new GetCelebrityRecognitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
