/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorInput;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorOutput;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorSettings;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStreamProcessorResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, DescribeStreamProcessorResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::name)).setter(DescribeStreamProcessorResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STREAM_PROCESSOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::streamProcessorArn)).setter(DescribeStreamProcessorResponse.setter(Builder::streamProcessorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamProcessorArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::statusAsString)).setter(DescribeStreamProcessorResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::statusMessage)).setter(DescribeStreamProcessorResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::creationTimestamp)).setter(DescribeStreamProcessorResponse.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::lastUpdateTimestamp)).setter(DescribeStreamProcessorResponse.setter(Builder::lastUpdateTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimestamp").build()}).build();
    private static final SdkField<StreamProcessorInput> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::input)).setter(DescribeStreamProcessorResponse.setter(Builder::input)).constructor(StreamProcessorInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()}).build();
    private static final SdkField<StreamProcessorOutput> OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::output)).setter(DescribeStreamProcessorResponse.setter(Builder::output)).constructor(StreamProcessorOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Output").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::roleArn)).setter(DescribeStreamProcessorResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<StreamProcessorSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeStreamProcessorResponse.getter(DescribeStreamProcessorResponse::settings)).setter(DescribeStreamProcessorResponse.setter(Builder::settings)).constructor(StreamProcessorSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STREAM_PROCESSOR_ARN_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATION_TIMESTAMP_FIELD, LAST_UPDATE_TIMESTAMP_FIELD, INPUT_FIELD, OUTPUT_FIELD, ROLE_ARN_FIELD, SETTINGS_FIELD));
    private final String name;
    private final String streamProcessorArn;
    private final String status;
    private final String statusMessage;
    private final Instant creationTimestamp;
    private final Instant lastUpdateTimestamp;
    private final StreamProcessorInput input;
    private final StreamProcessorOutput output;
    private final String roleArn;
    private final StreamProcessorSettings settings;

    private DescribeStreamProcessorResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.streamProcessorArn = builder.streamProcessorArn;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.creationTimestamp = builder.creationTimestamp;
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
        this.input = builder.input;
        this.output = builder.output;
        this.roleArn = builder.roleArn;
        this.settings = builder.settings;
    }

    public String name() {
        return this.name;
    }

    public String streamProcessorArn() {
        return this.streamProcessorArn;
    }

    public StreamProcessorStatus status() {
        return StreamProcessorStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public Instant lastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public StreamProcessorInput input() {
        return this.input;
    }

    public StreamProcessorOutput output() {
        return this.output;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public StreamProcessorSettings settings() {
        return this.settings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamProcessorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.output());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamProcessorResponse)) {
            return false;
        }
        DescribeStreamProcessorResponse other = (DescribeStreamProcessorResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.streamProcessorArn(), other.streamProcessorArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.lastUpdateTimestamp(), other.lastUpdateTimestamp()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.output(), other.output()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.settings(), other.settings());
    }

    public String toString() {
        return ToString.builder((String)"DescribeStreamProcessorResponse").add("Name", (Object)this.name()).add("StreamProcessorArn", (Object)this.streamProcessorArn()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("LastUpdateTimestamp", (Object)this.lastUpdateTimestamp()).add("Input", (Object)this.input()).add("Output", (Object)this.output()).add("RoleArn", (Object)this.roleArn()).add("Settings", (Object)this.settings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "StreamProcessorArn": {
                return Optional.ofNullable(clazz.cast(this.streamProcessorArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "LastUpdateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTimestamp()));
            }
            case "Input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "Output": {
                return Optional.ofNullable(clazz.cast(this.output()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStreamProcessorResponse, T> g) {
        return obj -> g.apply((DescribeStreamProcessorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private String name;
        private String streamProcessorArn;
        private String status;
        private String statusMessage;
        private Instant creationTimestamp;
        private Instant lastUpdateTimestamp;
        private StreamProcessorInput input;
        private StreamProcessorOutput output;
        private String roleArn;
        private StreamProcessorSettings settings;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamProcessorResponse model) {
            super(model);
            this.name(model.name);
            this.streamProcessorArn(model.streamProcessorArn);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.creationTimestamp(model.creationTimestamp);
            this.lastUpdateTimestamp(model.lastUpdateTimestamp);
            this.input(model.input);
            this.output(model.output);
            this.roleArn(model.roleArn);
            this.settings(model.settings);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStreamProcessorArn() {
            return this.streamProcessorArn;
        }

        @Override
        public final Builder streamProcessorArn(String streamProcessorArn) {
            this.streamProcessorArn = streamProcessorArn;
            return this;
        }

        public final void setStreamProcessorArn(String streamProcessorArn) {
            this.streamProcessorArn = streamProcessorArn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StreamProcessorStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public final Instant getLastUpdateTimestamp() {
            return this.lastUpdateTimestamp;
        }

        @Override
        public final Builder lastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public final void setLastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
        }

        public final StreamProcessorInput.Builder getInput() {
            return this.input != null ? this.input.toBuilder() : null;
        }

        @Override
        public final Builder input(StreamProcessorInput input) {
            this.input = input;
            return this;
        }

        public final void setInput(StreamProcessorInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        public final StreamProcessorOutput.Builder getOutput() {
            return this.output != null ? this.output.toBuilder() : null;
        }

        @Override
        public final Builder output(StreamProcessorOutput output) {
            this.output = output;
            return this;
        }

        public final void setOutput(StreamProcessorOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final StreamProcessorSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(StreamProcessorSettings settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(StreamProcessorSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        public DescribeStreamProcessorResponse build() {
            return new DescribeStreamProcessorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStreamProcessorResponse> {
        public Builder name(String var1);

        public Builder streamProcessorArn(String var1);

        public Builder status(String var1);

        public Builder status(StreamProcessorStatus var1);

        public Builder statusMessage(String var1);

        public Builder creationTimestamp(Instant var1);

        public Builder lastUpdateTimestamp(Instant var1);

        public Builder input(StreamProcessorInput var1);

        default public Builder input(Consumer<StreamProcessorInput.Builder> input) {
            return this.input((StreamProcessorInput)((StreamProcessorInput.Builder)StreamProcessorInput.builder().applyMutation(input)).build());
        }

        public Builder output(StreamProcessorOutput var1);

        default public Builder output(Consumer<StreamProcessorOutput.Builder> output) {
            return this.output((StreamProcessorOutput)((StreamProcessorOutput.Builder)StreamProcessorOutput.builder().applyMutation(output)).build());
        }

        public Builder roleArn(String var1);

        public Builder settings(StreamProcessorSettings var1);

        default public Builder settings(Consumer<StreamProcessorSettings.Builder> settings) {
            return this.settings((StreamProcessorSettings)((StreamProcessorSettings.Builder)StreamProcessorSettings.builder().applyMutation(settings)).build());
        }
    }
}

