/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a video that Amazon Rekognition analyzed. <code>Videometadata</code> is returned in every page of
 * paginated responses from a Amazon Rekognition video operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoMetadata implements SdkPojo, Serializable, ToCopyableBuilder<VideoMetadata.Builder, VideoMetadata> {
    private static final SdkField<String> CODEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VideoMetadata::codec)).setter(setter(Builder::codec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Codec").build()).build();

    private static final SdkField<Long> DURATION_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(VideoMetadata::durationMillis)).setter(setter(Builder::durationMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMillis").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VideoMetadata::format)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final SdkField<Float> FRAME_RATE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .getter(getter(VideoMetadata::frameRate)).setter(setter(Builder::frameRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameRate").build()).build();

    private static final SdkField<Long> FRAME_HEIGHT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(VideoMetadata::frameHeight)).setter(setter(Builder::frameHeight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameHeight").build()).build();

    private static final SdkField<Long> FRAME_WIDTH_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(VideoMetadata::frameWidth)).setter(setter(Builder::frameWidth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameWidth").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODEC_FIELD,
            DURATION_MILLIS_FIELD, FORMAT_FIELD, FRAME_RATE_FIELD, FRAME_HEIGHT_FIELD, FRAME_WIDTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String codec;

    private final Long durationMillis;

    private final String format;

    private final Float frameRate;

    private final Long frameHeight;

    private final Long frameWidth;

    private VideoMetadata(BuilderImpl builder) {
        this.codec = builder.codec;
        this.durationMillis = builder.durationMillis;
        this.format = builder.format;
        this.frameRate = builder.frameRate;
        this.frameHeight = builder.frameHeight;
        this.frameWidth = builder.frameWidth;
    }

    /**
     * <p>
     * Type of compression used in the analyzed video.
     * </p>
     * 
     * @return Type of compression used in the analyzed video.
     */
    public String codec() {
        return codec;
    }

    /**
     * <p>
     * Length of the video in milliseconds.
     * </p>
     * 
     * @return Length of the video in milliseconds.
     */
    public Long durationMillis() {
        return durationMillis;
    }

    /**
     * <p>
     * Format of the analyzed video. Possible values are MP4, MOV and AVI.
     * </p>
     * 
     * @return Format of the analyzed video. Possible values are MP4, MOV and AVI.
     */
    public String format() {
        return format;
    }

    /**
     * <p>
     * Number of frames per second in the video.
     * </p>
     * 
     * @return Number of frames per second in the video.
     */
    public Float frameRate() {
        return frameRate;
    }

    /**
     * <p>
     * Vertical pixel dimension of the video.
     * </p>
     * 
     * @return Vertical pixel dimension of the video.
     */
    public Long frameHeight() {
        return frameHeight;
    }

    /**
     * <p>
     * Horizontal pixel dimension of the video.
     * </p>
     * 
     * @return Horizontal pixel dimension of the video.
     */
    public Long frameWidth() {
        return frameWidth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codec());
        hashCode = 31 * hashCode + Objects.hashCode(durationMillis());
        hashCode = 31 * hashCode + Objects.hashCode(format());
        hashCode = 31 * hashCode + Objects.hashCode(frameRate());
        hashCode = 31 * hashCode + Objects.hashCode(frameHeight());
        hashCode = 31 * hashCode + Objects.hashCode(frameWidth());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoMetadata)) {
            return false;
        }
        VideoMetadata other = (VideoMetadata) obj;
        return Objects.equals(codec(), other.codec()) && Objects.equals(durationMillis(), other.durationMillis())
                && Objects.equals(format(), other.format()) && Objects.equals(frameRate(), other.frameRate())
                && Objects.equals(frameHeight(), other.frameHeight()) && Objects.equals(frameWidth(), other.frameWidth());
    }

    @Override
    public String toString() {
        return ToString.builder("VideoMetadata").add("Codec", codec()).add("DurationMillis", durationMillis())
                .add("Format", format()).add("FrameRate", frameRate()).add("FrameHeight", frameHeight())
                .add("FrameWidth", frameWidth()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Codec":
            return Optional.ofNullable(clazz.cast(codec()));
        case "DurationMillis":
            return Optional.ofNullable(clazz.cast(durationMillis()));
        case "Format":
            return Optional.ofNullable(clazz.cast(format()));
        case "FrameRate":
            return Optional.ofNullable(clazz.cast(frameRate()));
        case "FrameHeight":
            return Optional.ofNullable(clazz.cast(frameHeight()));
        case "FrameWidth":
            return Optional.ofNullable(clazz.cast(frameWidth()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoMetadata, T> g) {
        return obj -> g.apply((VideoMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoMetadata> {
        /**
         * <p>
         * Type of compression used in the analyzed video.
         * </p>
         * 
         * @param codec
         *        Type of compression used in the analyzed video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codec(String codec);

        /**
         * <p>
         * Length of the video in milliseconds.
         * </p>
         * 
         * @param durationMillis
         *        Length of the video in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationMillis(Long durationMillis);

        /**
         * <p>
         * Format of the analyzed video. Possible values are MP4, MOV and AVI.
         * </p>
         * 
         * @param format
         *        Format of the analyzed video. Possible values are MP4, MOV and AVI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        /**
         * <p>
         * Number of frames per second in the video.
         * </p>
         * 
         * @param frameRate
         *        Number of frames per second in the video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameRate(Float frameRate);

        /**
         * <p>
         * Vertical pixel dimension of the video.
         * </p>
         * 
         * @param frameHeight
         *        Vertical pixel dimension of the video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameHeight(Long frameHeight);

        /**
         * <p>
         * Horizontal pixel dimension of the video.
         * </p>
         * 
         * @param frameWidth
         *        Horizontal pixel dimension of the video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameWidth(Long frameWidth);
    }

    static final class BuilderImpl implements Builder {
        private String codec;

        private Long durationMillis;

        private String format;

        private Float frameRate;

        private Long frameHeight;

        private Long frameWidth;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoMetadata model) {
            codec(model.codec);
            durationMillis(model.durationMillis);
            format(model.format);
            frameRate(model.frameRate);
            frameHeight(model.frameHeight);
            frameWidth(model.frameWidth);
        }

        public final String getCodec() {
            return codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        public final Long getDurationMillis() {
            return durationMillis;
        }

        @Override
        public final Builder durationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
            return this;
        }

        public final void setDurationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final Float getFrameRate() {
            return frameRate;
        }

        @Override
        public final Builder frameRate(Float frameRate) {
            this.frameRate = frameRate;
            return this;
        }

        public final void setFrameRate(Float frameRate) {
            this.frameRate = frameRate;
        }

        public final Long getFrameHeight() {
            return frameHeight;
        }

        @Override
        public final Builder frameHeight(Long frameHeight) {
            this.frameHeight = frameHeight;
            return this;
        }

        public final void setFrameHeight(Long frameHeight) {
            this.frameHeight = frameHeight;
        }

        public final Long getFrameWidth() {
            return frameWidth;
        }

        @Override
        public final Builder frameWidth(Long frameWidth) {
            this.frameWidth = frameWidth;
            return this;
        }

        public final void setFrameWidth(Long frameWidth) {
            this.frameWidth = frameWidth;
        }

        @Override
        public VideoMetadata build() {
            return new VideoMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
