/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompareFacesResponse extends RekognitionResponse implements
        ToCopyableBuilder<CompareFacesResponse.Builder, CompareFacesResponse> {
    private static final SdkField<ComparedSourceImageFace> SOURCE_IMAGE_FACE_FIELD = SdkField
            .<ComparedSourceImageFace> builder(MarshallingType.SDK_POJO).getter(getter(CompareFacesResponse::sourceImageFace))
            .setter(setter(Builder::sourceImageFace)).constructor(ComparedSourceImageFace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceImageFace").build()).build();

    private static final SdkField<List<CompareFacesMatch>> FACE_MATCHES_FIELD = SdkField
            .<List<CompareFacesMatch>> builder(MarshallingType.LIST)
            .getter(getter(CompareFacesResponse::faceMatches))
            .setter(setter(Builder::faceMatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceMatches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CompareFacesMatch> builder(MarshallingType.SDK_POJO)
                                            .constructor(CompareFacesMatch::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ComparedFace>> UNMATCHED_FACES_FIELD = SdkField
            .<List<ComparedFace>> builder(MarshallingType.LIST)
            .getter(getter(CompareFacesResponse::unmatchedFaces))
            .setter(setter(Builder::unmatchedFaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnmatchedFaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComparedFace> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComparedFace::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_IMAGE_ORIENTATION_CORRECTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CompareFacesResponse::sourceImageOrientationCorrectionAsString))
            .setter(setter(Builder::sourceImageOrientationCorrection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceImageOrientationCorrection")
                    .build()).build();

    private static final SdkField<String> TARGET_IMAGE_ORIENTATION_CORRECTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CompareFacesResponse::targetImageOrientationCorrectionAsString))
            .setter(setter(Builder::targetImageOrientationCorrection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetImageOrientationCorrection")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_IMAGE_FACE_FIELD,
            FACE_MATCHES_FIELD, UNMATCHED_FACES_FIELD, SOURCE_IMAGE_ORIENTATION_CORRECTION_FIELD,
            TARGET_IMAGE_ORIENTATION_CORRECTION_FIELD));

    private final ComparedSourceImageFace sourceImageFace;

    private final List<CompareFacesMatch> faceMatches;

    private final List<ComparedFace> unmatchedFaces;

    private final String sourceImageOrientationCorrection;

    private final String targetImageOrientationCorrection;

    private CompareFacesResponse(BuilderImpl builder) {
        super(builder);
        this.sourceImageFace = builder.sourceImageFace;
        this.faceMatches = builder.faceMatches;
        this.unmatchedFaces = builder.unmatchedFaces;
        this.sourceImageOrientationCorrection = builder.sourceImageOrientationCorrection;
        this.targetImageOrientationCorrection = builder.targetImageOrientationCorrection;
    }

    /**
     * <p>
     * The face in the source image that was used for comparison.
     * </p>
     * 
     * @return The face in the source image that was used for comparison.
     */
    public ComparedSourceImageFace sourceImageFace() {
        return sourceImageFace;
    }

    /**
     * <p>
     * An array of faces in the target image that match the source image face. Each <code>CompareFacesMatch</code>
     * object provides the bounding box, the confidence level that the bounding box contains a face, and the similarity
     * score for the face in the bounding box and the face in the source image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of faces in the target image that match the source image face. Each
     *         <code>CompareFacesMatch</code> object provides the bounding box, the confidence level that the bounding
     *         box contains a face, and the similarity score for the face in the bounding box and the face in the source
     *         image.
     */
    public List<CompareFacesMatch> faceMatches() {
        return faceMatches;
    }

    /**
     * <p>
     * An array of faces in the target image that did not match the source image face.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of faces in the target image that did not match the source image face.
     */
    public List<ComparedFace> unmatchedFaces() {
        return unmatchedFaces;
    }

    /**
     * <p>
     * The value of <code>SourceImageOrientationCorrection</code> is always null.
     * </p>
     * <p>
     * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
     * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
     * correction. The bounding box coordinates are translated to represent object locations after the orientation
     * information in the Exif metadata is used to correct the image orientation. Images in .png format don't contain
     * Exif metadata.
     * </p>
     * <p>
     * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
     * orientation information in the image Exif metadata. The bounding box coordinates aren't translated and represent
     * the object locations before the image is rotated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sourceImageOrientationCorrection} will return {@link OrientationCorrection#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #sourceImageOrientationCorrectionAsString}.
     * </p>
     * 
     * @return The value of <code>SourceImageOrientationCorrection</code> is always null.</p>
     *         <p>
     *         If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
     *         that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
     *         image correction. The bounding box coordinates are translated to represent object locations after the
     *         orientation information in the Exif metadata is used to correct the image orientation. Images in .png
     *         format don't contain Exif metadata.
     *         </p>
     *         <p>
     *         Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
     *         orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
     *         represent the object locations before the image is rotated.
     * @see OrientationCorrection
     */
    public OrientationCorrection sourceImageOrientationCorrection() {
        return OrientationCorrection.fromValue(sourceImageOrientationCorrection);
    }

    /**
     * <p>
     * The value of <code>SourceImageOrientationCorrection</code> is always null.
     * </p>
     * <p>
     * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
     * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
     * correction. The bounding box coordinates are translated to represent object locations after the orientation
     * information in the Exif metadata is used to correct the image orientation. Images in .png format don't contain
     * Exif metadata.
     * </p>
     * <p>
     * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
     * orientation information in the image Exif metadata. The bounding box coordinates aren't translated and represent
     * the object locations before the image is rotated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sourceImageOrientationCorrection} will return {@link OrientationCorrection#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #sourceImageOrientationCorrectionAsString}.
     * </p>
     * 
     * @return The value of <code>SourceImageOrientationCorrection</code> is always null.</p>
     *         <p>
     *         If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
     *         that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
     *         image correction. The bounding box coordinates are translated to represent object locations after the
     *         orientation information in the Exif metadata is used to correct the image orientation. Images in .png
     *         format don't contain Exif metadata.
     *         </p>
     *         <p>
     *         Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
     *         orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
     *         represent the object locations before the image is rotated.
     * @see OrientationCorrection
     */
    public String sourceImageOrientationCorrectionAsString() {
        return sourceImageOrientationCorrection;
    }

    /**
     * <p>
     * The value of <code>TargetImageOrientationCorrection</code> is always null.
     * </p>
     * <p>
     * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
     * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
     * correction. The bounding box coordinates are translated to represent object locations after the orientation
     * information in the Exif metadata is used to correct the image orientation. Images in .png format don't contain
     * Exif metadata.
     * </p>
     * <p>
     * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
     * orientation information in the image Exif metadata. The bounding box coordinates aren't translated and represent
     * the object locations before the image is rotated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetImageOrientationCorrection} will return {@link OrientationCorrection#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #targetImageOrientationCorrectionAsString}.
     * </p>
     * 
     * @return The value of <code>TargetImageOrientationCorrection</code> is always null.</p>
     *         <p>
     *         If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
     *         that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
     *         image correction. The bounding box coordinates are translated to represent object locations after the
     *         orientation information in the Exif metadata is used to correct the image orientation. Images in .png
     *         format don't contain Exif metadata.
     *         </p>
     *         <p>
     *         Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
     *         orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
     *         represent the object locations before the image is rotated.
     * @see OrientationCorrection
     */
    public OrientationCorrection targetImageOrientationCorrection() {
        return OrientationCorrection.fromValue(targetImageOrientationCorrection);
    }

    /**
     * <p>
     * The value of <code>TargetImageOrientationCorrection</code> is always null.
     * </p>
     * <p>
     * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
     * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
     * correction. The bounding box coordinates are translated to represent object locations after the orientation
     * information in the Exif metadata is used to correct the image orientation. Images in .png format don't contain
     * Exif metadata.
     * </p>
     * <p>
     * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
     * orientation information in the image Exif metadata. The bounding box coordinates aren't translated and represent
     * the object locations before the image is rotated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetImageOrientationCorrection} will return {@link OrientationCorrection#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #targetImageOrientationCorrectionAsString}.
     * </p>
     * 
     * @return The value of <code>TargetImageOrientationCorrection</code> is always null.</p>
     *         <p>
     *         If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
     *         that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
     *         image correction. The bounding box coordinates are translated to represent object locations after the
     *         orientation information in the Exif metadata is used to correct the image orientation. Images in .png
     *         format don't contain Exif metadata.
     *         </p>
     *         <p>
     *         Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
     *         orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
     *         represent the object locations before the image is rotated.
     * @see OrientationCorrection
     */
    public String targetImageOrientationCorrectionAsString() {
        return targetImageOrientationCorrection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceImageFace());
        hashCode = 31 * hashCode + Objects.hashCode(faceMatches());
        hashCode = 31 * hashCode + Objects.hashCode(unmatchedFaces());
        hashCode = 31 * hashCode + Objects.hashCode(sourceImageOrientationCorrectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetImageOrientationCorrectionAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareFacesResponse)) {
            return false;
        }
        CompareFacesResponse other = (CompareFacesResponse) obj;
        return Objects.equals(sourceImageFace(), other.sourceImageFace()) && Objects.equals(faceMatches(), other.faceMatches())
                && Objects.equals(unmatchedFaces(), other.unmatchedFaces())
                && Objects.equals(sourceImageOrientationCorrectionAsString(), other.sourceImageOrientationCorrectionAsString())
                && Objects.equals(targetImageOrientationCorrectionAsString(), other.targetImageOrientationCorrectionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CompareFacesResponse").add("SourceImageFace", sourceImageFace())
                .add("FaceMatches", faceMatches()).add("UnmatchedFaces", unmatchedFaces())
                .add("SourceImageOrientationCorrection", sourceImageOrientationCorrectionAsString())
                .add("TargetImageOrientationCorrection", targetImageOrientationCorrectionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceImageFace":
            return Optional.ofNullable(clazz.cast(sourceImageFace()));
        case "FaceMatches":
            return Optional.ofNullable(clazz.cast(faceMatches()));
        case "UnmatchedFaces":
            return Optional.ofNullable(clazz.cast(unmatchedFaces()));
        case "SourceImageOrientationCorrection":
            return Optional.ofNullable(clazz.cast(sourceImageOrientationCorrectionAsString()));
        case "TargetImageOrientationCorrection":
            return Optional.ofNullable(clazz.cast(targetImageOrientationCorrectionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompareFacesResponse, T> g) {
        return obj -> g.apply((CompareFacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, CompareFacesResponse> {
        /**
         * <p>
         * The face in the source image that was used for comparison.
         * </p>
         * 
         * @param sourceImageFace
         *        The face in the source image that was used for comparison.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceImageFace(ComparedSourceImageFace sourceImageFace);

        /**
         * <p>
         * The face in the source image that was used for comparison.
         * </p>
         * This is a convenience that creates an instance of the {@link ComparedSourceImageFace.Builder} avoiding the
         * need to create one manually via {@link ComparedSourceImageFace#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComparedSourceImageFace.Builder#build()} is called immediately
         * and its result is passed to {@link #sourceImageFace(ComparedSourceImageFace)}.
         * 
         * @param sourceImageFace
         *        a consumer that will call methods on {@link ComparedSourceImageFace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceImageFace(ComparedSourceImageFace)
         */
        default Builder sourceImageFace(Consumer<ComparedSourceImageFace.Builder> sourceImageFace) {
            return sourceImageFace(ComparedSourceImageFace.builder().applyMutation(sourceImageFace).build());
        }

        /**
         * <p>
         * An array of faces in the target image that match the source image face. Each <code>CompareFacesMatch</code>
         * object provides the bounding box, the confidence level that the bounding box contains a face, and the
         * similarity score for the face in the bounding box and the face in the source image.
         * </p>
         * 
         * @param faceMatches
         *        An array of faces in the target image that match the source image face. Each
         *        <code>CompareFacesMatch</code> object provides the bounding box, the confidence level that the
         *        bounding box contains a face, and the similarity score for the face in the bounding box and the face
         *        in the source image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceMatches(Collection<CompareFacesMatch> faceMatches);

        /**
         * <p>
         * An array of faces in the target image that match the source image face. Each <code>CompareFacesMatch</code>
         * object provides the bounding box, the confidence level that the bounding box contains a face, and the
         * similarity score for the face in the bounding box and the face in the source image.
         * </p>
         * 
         * @param faceMatches
         *        An array of faces in the target image that match the source image face. Each
         *        <code>CompareFacesMatch</code> object provides the bounding box, the confidence level that the
         *        bounding box contains a face, and the similarity score for the face in the bounding box and the face
         *        in the source image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceMatches(CompareFacesMatch... faceMatches);

        /**
         * <p>
         * An array of faces in the target image that match the source image face. Each <code>CompareFacesMatch</code>
         * object provides the bounding box, the confidence level that the bounding box contains a face, and the
         * similarity score for the face in the bounding box and the face in the source image.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CompareFacesMatch>.Builder} avoiding the
         * need to create one manually via {@link List<CompareFacesMatch>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CompareFacesMatch>.Builder#build()} is called immediately
         * and its result is passed to {@link #faceMatches(List<CompareFacesMatch>)}.
         * 
         * @param faceMatches
         *        a consumer that will call methods on {@link List<CompareFacesMatch>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #faceMatches(List<CompareFacesMatch>)
         */
        Builder faceMatches(Consumer<CompareFacesMatch.Builder>... faceMatches);

        /**
         * <p>
         * An array of faces in the target image that did not match the source image face.
         * </p>
         * 
         * @param unmatchedFaces
         *        An array of faces in the target image that did not match the source image face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unmatchedFaces(Collection<ComparedFace> unmatchedFaces);

        /**
         * <p>
         * An array of faces in the target image that did not match the source image face.
         * </p>
         * 
         * @param unmatchedFaces
         *        An array of faces in the target image that did not match the source image face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unmatchedFaces(ComparedFace... unmatchedFaces);

        /**
         * <p>
         * An array of faces in the target image that did not match the source image face.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ComparedFace>.Builder} avoiding the need to
         * create one manually via {@link List<ComparedFace>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ComparedFace>.Builder#build()} is called immediately and its
         * result is passed to {@link #unmatchedFaces(List<ComparedFace>)}.
         * 
         * @param unmatchedFaces
         *        a consumer that will call methods on {@link List<ComparedFace>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unmatchedFaces(List<ComparedFace>)
         */
        Builder unmatchedFaces(Consumer<ComparedFace.Builder>... unmatchedFaces);

        /**
         * <p>
         * The value of <code>SourceImageOrientationCorrection</code> is always null.
         * </p>
         * <p>
         * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
         * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
         * correction. The bounding box coordinates are translated to represent object locations after the orientation
         * information in the Exif metadata is used to correct the image orientation. Images in .png format don't
         * contain Exif metadata.
         * </p>
         * <p>
         * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
         * orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
         * represent the object locations before the image is rotated.
         * </p>
         * 
         * @param sourceImageOrientationCorrection
         *        The value of <code>SourceImageOrientationCorrection</code> is always null.</p>
         *        <p>
         *        If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
         *        that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
         *        image correction. The bounding box coordinates are translated to represent object locations after the
         *        orientation information in the Exif metadata is used to correct the image orientation. Images in .png
         *        format don't contain Exif metadata.
         *        </p>
         *        <p>
         *        Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
         *        orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
         *        represent the object locations before the image is rotated.
         * @see OrientationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder sourceImageOrientationCorrection(String sourceImageOrientationCorrection);

        /**
         * <p>
         * The value of <code>SourceImageOrientationCorrection</code> is always null.
         * </p>
         * <p>
         * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
         * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
         * correction. The bounding box coordinates are translated to represent object locations after the orientation
         * information in the Exif metadata is used to correct the image orientation. Images in .png format don't
         * contain Exif metadata.
         * </p>
         * <p>
         * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
         * orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
         * represent the object locations before the image is rotated.
         * </p>
         * 
         * @param sourceImageOrientationCorrection
         *        The value of <code>SourceImageOrientationCorrection</code> is always null.</p>
         *        <p>
         *        If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
         *        that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
         *        image correction. The bounding box coordinates are translated to represent object locations after the
         *        orientation information in the Exif metadata is used to correct the image orientation. Images in .png
         *        format don't contain Exif metadata.
         *        </p>
         *        <p>
         *        Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
         *        orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
         *        represent the object locations before the image is rotated.
         * @see OrientationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder sourceImageOrientationCorrection(OrientationCorrection sourceImageOrientationCorrection);

        /**
         * <p>
         * The value of <code>TargetImageOrientationCorrection</code> is always null.
         * </p>
         * <p>
         * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
         * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
         * correction. The bounding box coordinates are translated to represent object locations after the orientation
         * information in the Exif metadata is used to correct the image orientation. Images in .png format don't
         * contain Exif metadata.
         * </p>
         * <p>
         * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
         * orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
         * represent the object locations before the image is rotated.
         * </p>
         * 
         * @param targetImageOrientationCorrection
         *        The value of <code>TargetImageOrientationCorrection</code> is always null.</p>
         *        <p>
         *        If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
         *        that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
         *        image correction. The bounding box coordinates are translated to represent object locations after the
         *        orientation information in the Exif metadata is used to correct the image orientation. Images in .png
         *        format don't contain Exif metadata.
         *        </p>
         *        <p>
         *        Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
         *        orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
         *        represent the object locations before the image is rotated.
         * @see OrientationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder targetImageOrientationCorrection(String targetImageOrientationCorrection);

        /**
         * <p>
         * The value of <code>TargetImageOrientationCorrection</code> is always null.
         * </p>
         * <p>
         * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
         * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
         * correction. The bounding box coordinates are translated to represent object locations after the orientation
         * information in the Exif metadata is used to correct the image orientation. Images in .png format don't
         * contain Exif metadata.
         * </p>
         * <p>
         * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
         * orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
         * represent the object locations before the image is rotated.
         * </p>
         * 
         * @param targetImageOrientationCorrection
         *        The value of <code>TargetImageOrientationCorrection</code> is always null.</p>
         *        <p>
         *        If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
         *        that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
         *        image correction. The bounding box coordinates are translated to represent object locations after the
         *        orientation information in the Exif metadata is used to correct the image orientation. Images in .png
         *        format don't contain Exif metadata.
         *        </p>
         *        <p>
         *        Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
         *        orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
         *        represent the object locations before the image is rotated.
         * @see OrientationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder targetImageOrientationCorrection(OrientationCorrection targetImageOrientationCorrection);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private ComparedSourceImageFace sourceImageFace;

        private List<CompareFacesMatch> faceMatches = DefaultSdkAutoConstructList.getInstance();

        private List<ComparedFace> unmatchedFaces = DefaultSdkAutoConstructList.getInstance();

        private String sourceImageOrientationCorrection;

        private String targetImageOrientationCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(CompareFacesResponse model) {
            super(model);
            sourceImageFace(model.sourceImageFace);
            faceMatches(model.faceMatches);
            unmatchedFaces(model.unmatchedFaces);
            sourceImageOrientationCorrection(model.sourceImageOrientationCorrection);
            targetImageOrientationCorrection(model.targetImageOrientationCorrection);
        }

        public final ComparedSourceImageFace.Builder getSourceImageFace() {
            return sourceImageFace != null ? sourceImageFace.toBuilder() : null;
        }

        @Override
        public final Builder sourceImageFace(ComparedSourceImageFace sourceImageFace) {
            this.sourceImageFace = sourceImageFace;
            return this;
        }

        public final void setSourceImageFace(ComparedSourceImageFace.BuilderImpl sourceImageFace) {
            this.sourceImageFace = sourceImageFace != null ? sourceImageFace.build() : null;
        }

        public final Collection<CompareFacesMatch.Builder> getFaceMatches() {
            return faceMatches != null ? faceMatches.stream().map(CompareFacesMatch::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder faceMatches(Collection<CompareFacesMatch> faceMatches) {
            this.faceMatches = CompareFacesMatchListCopier.copy(faceMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(CompareFacesMatch... faceMatches) {
            faceMatches(Arrays.asList(faceMatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(Consumer<CompareFacesMatch.Builder>... faceMatches) {
            faceMatches(Stream.of(faceMatches).map(c -> CompareFacesMatch.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFaceMatches(Collection<CompareFacesMatch.BuilderImpl> faceMatches) {
            this.faceMatches = CompareFacesMatchListCopier.copyFromBuilder(faceMatches);
        }

        public final Collection<ComparedFace.Builder> getUnmatchedFaces() {
            return unmatchedFaces != null ? unmatchedFaces.stream().map(ComparedFace::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder unmatchedFaces(Collection<ComparedFace> unmatchedFaces) {
            this.unmatchedFaces = CompareFacesUnmatchListCopier.copy(unmatchedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unmatchedFaces(ComparedFace... unmatchedFaces) {
            unmatchedFaces(Arrays.asList(unmatchedFaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unmatchedFaces(Consumer<ComparedFace.Builder>... unmatchedFaces) {
            unmatchedFaces(Stream.of(unmatchedFaces).map(c -> ComparedFace.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUnmatchedFaces(Collection<ComparedFace.BuilderImpl> unmatchedFaces) {
            this.unmatchedFaces = CompareFacesUnmatchListCopier.copyFromBuilder(unmatchedFaces);
        }

        public final String getSourceImageOrientationCorrectionAsString() {
            return sourceImageOrientationCorrection;
        }

        @Override
        public final Builder sourceImageOrientationCorrection(String sourceImageOrientationCorrection) {
            this.sourceImageOrientationCorrection = sourceImageOrientationCorrection;
            return this;
        }

        @Override
        public final Builder sourceImageOrientationCorrection(OrientationCorrection sourceImageOrientationCorrection) {
            this.sourceImageOrientationCorrection(sourceImageOrientationCorrection == null ? null
                    : sourceImageOrientationCorrection.toString());
            return this;
        }

        public final void setSourceImageOrientationCorrection(String sourceImageOrientationCorrection) {
            this.sourceImageOrientationCorrection = sourceImageOrientationCorrection;
        }

        public final String getTargetImageOrientationCorrectionAsString() {
            return targetImageOrientationCorrection;
        }

        @Override
        public final Builder targetImageOrientationCorrection(String targetImageOrientationCorrection) {
            this.targetImageOrientationCorrection = targetImageOrientationCorrection;
            return this;
        }

        @Override
        public final Builder targetImageOrientationCorrection(OrientationCorrection targetImageOrientationCorrection) {
            this.targetImageOrientationCorrection(targetImageOrientationCorrection == null ? null
                    : targetImageOrientationCorrection.toString());
            return this;
        }

        public final void setTargetImageOrientationCorrection(String targetImageOrientationCorrection) {
            this.targetImageOrientationCorrection = targetImageOrientationCorrection;
        }

        @Override
        public CompareFacesResponse build() {
            return new CompareFacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
