/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that recognizes faces in a streaming video. An Amazon Rekognition stream processor is created by a call to
 * <a>CreateStreamProcessor</a>. The request parameters for <code>CreateStreamProcessor</code> describe the Kinesis
 * video stream source for the streaming video, face recognition parameters, and where to stream the analysis resullts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamProcessor implements SdkPojo, Serializable, ToCopyableBuilder<StreamProcessor.Builder, StreamProcessor> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StreamProcessor::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StreamProcessor::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String status;

    private StreamProcessor(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
    }

    /**
     * <p>
     * Name of the Amazon Rekognition stream processor.
     * </p>
     * 
     * @return Name of the Amazon Rekognition stream processor.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Current status of the Amazon Rekognition stream processor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StreamProcessorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Current status of the Amazon Rekognition stream processor.
     * @see StreamProcessorStatus
     */
    public StreamProcessorStatus status() {
        return StreamProcessorStatus.fromValue(status);
    }

    /**
     * <p>
     * Current status of the Amazon Rekognition stream processor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StreamProcessorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Current status of the Amazon Rekognition stream processor.
     * @see StreamProcessorStatus
     */
    public String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamProcessor)) {
            return false;
        }
        StreamProcessor other = (StreamProcessor) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StreamProcessor").add("Name", name()).add("Status", statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamProcessor, T> g) {
        return obj -> g.apply((StreamProcessor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamProcessor> {
        /**
         * <p>
         * Name of the Amazon Rekognition stream processor.
         * </p>
         * 
         * @param name
         *        Name of the Amazon Rekognition stream processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Current status of the Amazon Rekognition stream processor.
         * </p>
         * 
         * @param status
         *        Current status of the Amazon Rekognition stream processor.
         * @see StreamProcessorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamProcessorStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Current status of the Amazon Rekognition stream processor.
         * </p>
         * 
         * @param status
         *        Current status of the Amazon Rekognition stream processor.
         * @see StreamProcessorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamProcessorStatus
         */
        Builder status(StreamProcessorStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamProcessor model) {
            name(model.name);
            status(model.status);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StreamProcessorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public StreamProcessor build() {
            return new StreamProcessor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
