/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCollectionResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, DescribeCollectionResponse> {
    private static final SdkField<Long> FACE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DescribeCollectionResponse.getter(DescribeCollectionResponse::faceCount)).setter(DescribeCollectionResponse.setter(Builder::faceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceCount").build()}).build();
    private static final SdkField<String> FACE_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeCollectionResponse.getter(DescribeCollectionResponse::faceModelVersion)).setter(DescribeCollectionResponse.setter(Builder::faceModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceModelVersion").build()}).build();
    private static final SdkField<String> COLLECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeCollectionResponse.getter(DescribeCollectionResponse::collectionARN)).setter(DescribeCollectionResponse.setter(Builder::collectionARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionARN").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeCollectionResponse.getter(DescribeCollectionResponse::creationTimestamp)).setter(DescribeCollectionResponse.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACE_COUNT_FIELD, FACE_MODEL_VERSION_FIELD, COLLECTION_ARN_FIELD, CREATION_TIMESTAMP_FIELD));
    private final Long faceCount;
    private final String faceModelVersion;
    private final String collectionARN;
    private final Instant creationTimestamp;

    private DescribeCollectionResponse(BuilderImpl builder) {
        super(builder);
        this.faceCount = builder.faceCount;
        this.faceModelVersion = builder.faceModelVersion;
        this.collectionARN = builder.collectionARN;
        this.creationTimestamp = builder.creationTimestamp;
    }

    public Long faceCount() {
        return this.faceCount;
    }

    public String faceModelVersion() {
        return this.faceModelVersion;
    }

    public String collectionARN() {
        return this.collectionARN;
    }

    public Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.faceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCollectionResponse)) {
            return false;
        }
        DescribeCollectionResponse other = (DescribeCollectionResponse)((Object)obj);
        return Objects.equals(this.faceCount(), other.faceCount()) && Objects.equals(this.faceModelVersion(), other.faceModelVersion()) && Objects.equals(this.collectionARN(), other.collectionARN()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCollectionResponse").add("FaceCount", (Object)this.faceCount()).add("FaceModelVersion", (Object)this.faceModelVersion()).add("CollectionARN", (Object)this.collectionARN()).add("CreationTimestamp", (Object)this.creationTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FaceCount": {
                return Optional.ofNullable(clazz.cast(this.faceCount()));
            }
            case "FaceModelVersion": {
                return Optional.ofNullable(clazz.cast(this.faceModelVersion()));
            }
            case "CollectionARN": {
                return Optional.ofNullable(clazz.cast(this.collectionARN()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCollectionResponse, T> g) {
        return obj -> g.apply((DescribeCollectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private Long faceCount;
        private String faceModelVersion;
        private String collectionARN;
        private Instant creationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCollectionResponse model) {
            super(model);
            this.faceCount(model.faceCount);
            this.faceModelVersion(model.faceModelVersion);
            this.collectionARN(model.collectionARN);
            this.creationTimestamp(model.creationTimestamp);
        }

        public final Long getFaceCount() {
            return this.faceCount;
        }

        @Override
        public final Builder faceCount(Long faceCount) {
            this.faceCount = faceCount;
            return this;
        }

        public final void setFaceCount(Long faceCount) {
            this.faceCount = faceCount;
        }

        public final String getFaceModelVersion() {
            return this.faceModelVersion;
        }

        @Override
        public final Builder faceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
            return this;
        }

        public final void setFaceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
        }

        public final String getCollectionARN() {
            return this.collectionARN;
        }

        @Override
        public final Builder collectionARN(String collectionARN) {
            this.collectionARN = collectionARN;
            return this;
        }

        public final void setCollectionARN(String collectionARN) {
            this.collectionARN = collectionARN;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public DescribeCollectionResponse build() {
            return new DescribeCollectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCollectionResponse> {
        public Builder faceCount(Long var1);

        public Builder faceModelVersion(String var1);

        public Builder collectionARN(String var1);

        public Builder creationTimestamp(Instant var1);
    }
}

