/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProjectsResponse extends RekognitionResponse implements
        ToCopyableBuilder<DescribeProjectsResponse.Builder, DescribeProjectsResponse> {
    private static final SdkField<List<ProjectDescription>> PROJECT_DESCRIPTIONS_FIELD = SdkField
            .<List<ProjectDescription>> builder(MarshallingType.LIST)
            .getter(getter(DescribeProjectsResponse::projectDescriptions))
            .setter(setter(Builder::projectDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeProjectsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_DESCRIPTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ProjectDescription> projectDescriptions;

    private final String nextToken;

    private DescribeProjectsResponse(BuilderImpl builder) {
        super(builder);
        this.projectDescriptions = builder.projectDescriptions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ProjectDescriptions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasProjectDescriptions() {
        return projectDescriptions != null && !(projectDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of project descriptions. The list is sorted by the date and time the projects are created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProjectDescriptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of project descriptions. The list is sorted by the date and time the projects are created.
     */
    public List<ProjectDescription> projectDescriptions() {
        return projectDescriptions;
    }

    /**
     * <p>
     * If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom
     * Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of
     * results.
     * </p>
     * 
     * @return If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition
     *         Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve
     *         the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProjectsResponse)) {
            return false;
        }
        DescribeProjectsResponse other = (DescribeProjectsResponse) obj;
        return Objects.equals(projectDescriptions(), other.projectDescriptions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeProjectsResponse").add("ProjectDescriptions", projectDescriptions())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectDescriptions":
            return Optional.ofNullable(clazz.cast(projectDescriptions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProjectsResponse, T> g) {
        return obj -> g.apply((DescribeProjectsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeProjectsResponse> {
        /**
         * <p>
         * A list of project descriptions. The list is sorted by the date and time the projects are created.
         * </p>
         * 
         * @param projectDescriptions
         *        A list of project descriptions. The list is sorted by the date and time the projects are created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectDescriptions(Collection<ProjectDescription> projectDescriptions);

        /**
         * <p>
         * A list of project descriptions. The list is sorted by the date and time the projects are created.
         * </p>
         * 
         * @param projectDescriptions
         *        A list of project descriptions. The list is sorted by the date and time the projects are created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectDescriptions(ProjectDescription... projectDescriptions);

        /**
         * <p>
         * A list of project descriptions. The list is sorted by the date and time the projects are created.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProjectDescription>.Builder} avoiding the
         * need to create one manually via {@link List<ProjectDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProjectDescription>.Builder#build()} is called immediately
         * and its result is passed to {@link #projectDescriptions(List<ProjectDescription>)}.
         * 
         * @param projectDescriptions
         *        a consumer that will call methods on {@link List<ProjectDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projectDescriptions(List<ProjectDescription>)
         */
        Builder projectDescriptions(Consumer<ProjectDescription.Builder>... projectDescriptions);

        /**
         * <p>
         * If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition
         * Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the
         * next set of results.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was incomplete (because there is more results to retrieve), Amazon
         *        Rekognition Custom Labels returns a pagination token in the response. You can use this pagination
         *        token to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<ProjectDescription> projectDescriptions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProjectsResponse model) {
            super(model);
            projectDescriptions(model.projectDescriptions);
            nextToken(model.nextToken);
        }

        public final Collection<ProjectDescription.Builder> getProjectDescriptions() {
            return projectDescriptions != null ? projectDescriptions.stream().map(ProjectDescription::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder projectDescriptions(Collection<ProjectDescription> projectDescriptions) {
            this.projectDescriptions = ProjectDescriptionsCopier.copy(projectDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectDescriptions(ProjectDescription... projectDescriptions) {
            projectDescriptions(Arrays.asList(projectDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectDescriptions(Consumer<ProjectDescription.Builder>... projectDescriptions) {
            projectDescriptions(Stream.of(projectDescriptions).map(c -> ProjectDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProjectDescriptions(Collection<ProjectDescription.BuilderImpl> projectDescriptions) {
            this.projectDescriptions = ProjectDescriptionsCopier.copyFromBuilder(projectDescriptions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeProjectsResponse build() {
            return new DescribeProjectsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
