/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Shows the results of the human in the loop evaluation. If there is no HumanLoopArn, the input did not trigger human
 * review.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HumanLoopActivationOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<HumanLoopActivationOutput.Builder, HumanLoopActivationOutput> {
    private static final SdkField<String> HUMAN_LOOP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HumanLoopActivationOutput::humanLoopArn)).setter(setter(Builder::humanLoopArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopArn").build()).build();

    private static final SdkField<List<String>> HUMAN_LOOP_ACTIVATION_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(HumanLoopActivationOutput::humanLoopActivationReasons))
            .setter(setter(Builder::humanLoopActivationReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopActivationReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> HUMAN_LOOP_ACTIVATION_CONDITIONS_EVALUATION_RESULTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(HumanLoopActivationOutput::humanLoopActivationConditionsEvaluationResults))
            .setter(setter(Builder::humanLoopActivationConditionsEvaluationResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("HumanLoopActivationConditionsEvaluationResults").build(), JsonValueTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_LOOP_ARN_FIELD,
            HUMAN_LOOP_ACTIVATION_REASONS_FIELD, HUMAN_LOOP_ACTIVATION_CONDITIONS_EVALUATION_RESULTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String humanLoopArn;

    private final List<String> humanLoopActivationReasons;

    private final String humanLoopActivationConditionsEvaluationResults;

    private HumanLoopActivationOutput(BuilderImpl builder) {
        this.humanLoopArn = builder.humanLoopArn;
        this.humanLoopActivationReasons = builder.humanLoopActivationReasons;
        this.humanLoopActivationConditionsEvaluationResults = builder.humanLoopActivationConditionsEvaluationResults;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the HumanLoop created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the HumanLoop created.
     */
    public String humanLoopArn() {
        return humanLoopArn;
    }

    /**
     * Returns true if the HumanLoopActivationReasons property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasHumanLoopActivationReasons() {
        return humanLoopActivationReasons != null && !(humanLoopActivationReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Shows if and why human review was needed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHumanLoopActivationReasons()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Shows if and why human review was needed.
     */
    public List<String> humanLoopActivationReasons() {
        return humanLoopActivationReasons;
    }

    /**
     * <p>
     * Shows the result of condition evaluations, including those conditions which activated a human review.
     * </p>
     * 
     * @return Shows the result of condition evaluations, including those conditions which activated a human review.
     */
    public String humanLoopActivationConditionsEvaluationResults() {
        return humanLoopActivationConditionsEvaluationResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopArn());
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopActivationReasons());
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopActivationConditionsEvaluationResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanLoopActivationOutput)) {
            return false;
        }
        HumanLoopActivationOutput other = (HumanLoopActivationOutput) obj;
        return Objects.equals(humanLoopArn(), other.humanLoopArn())
                && Objects.equals(humanLoopActivationReasons(), other.humanLoopActivationReasons())
                && Objects.equals(humanLoopActivationConditionsEvaluationResults(),
                        other.humanLoopActivationConditionsEvaluationResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HumanLoopActivationOutput").add("HumanLoopArn", humanLoopArn())
                .add("HumanLoopActivationReasons", humanLoopActivationReasons())
                .add("HumanLoopActivationConditionsEvaluationResults", humanLoopActivationConditionsEvaluationResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HumanLoopArn":
            return Optional.ofNullable(clazz.cast(humanLoopArn()));
        case "HumanLoopActivationReasons":
            return Optional.ofNullable(clazz.cast(humanLoopActivationReasons()));
        case "HumanLoopActivationConditionsEvaluationResults":
            return Optional.ofNullable(clazz.cast(humanLoopActivationConditionsEvaluationResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HumanLoopActivationOutput, T> g) {
        return obj -> g.apply((HumanLoopActivationOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HumanLoopActivationOutput> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the HumanLoop created.
         * </p>
         * 
         * @param humanLoopArn
         *        The Amazon Resource Name (ARN) of the HumanLoop created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopArn(String humanLoopArn);

        /**
         * <p>
         * Shows if and why human review was needed.
         * </p>
         * 
         * @param humanLoopActivationReasons
         *        Shows if and why human review was needed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopActivationReasons(Collection<String> humanLoopActivationReasons);

        /**
         * <p>
         * Shows if and why human review was needed.
         * </p>
         * 
         * @param humanLoopActivationReasons
         *        Shows if and why human review was needed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopActivationReasons(String... humanLoopActivationReasons);

        /**
         * <p>
         * Shows the result of condition evaluations, including those conditions which activated a human review.
         * </p>
         * 
         * @param humanLoopActivationConditionsEvaluationResults
         *        Shows the result of condition evaluations, including those conditions which activated a human review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopActivationConditionsEvaluationResults(String humanLoopActivationConditionsEvaluationResults);
    }

    static final class BuilderImpl implements Builder {
        private String humanLoopArn;

        private List<String> humanLoopActivationReasons = DefaultSdkAutoConstructList.getInstance();

        private String humanLoopActivationConditionsEvaluationResults;

        private BuilderImpl() {
        }

        private BuilderImpl(HumanLoopActivationOutput model) {
            humanLoopArn(model.humanLoopArn);
            humanLoopActivationReasons(model.humanLoopActivationReasons);
            humanLoopActivationConditionsEvaluationResults(model.humanLoopActivationConditionsEvaluationResults);
        }

        public final String getHumanLoopArn() {
            return humanLoopArn;
        }

        @Override
        public final Builder humanLoopArn(String humanLoopArn) {
            this.humanLoopArn = humanLoopArn;
            return this;
        }

        public final void setHumanLoopArn(String humanLoopArn) {
            this.humanLoopArn = humanLoopArn;
        }

        public final Collection<String> getHumanLoopActivationReasons() {
            return humanLoopActivationReasons;
        }

        @Override
        public final Builder humanLoopActivationReasons(Collection<String> humanLoopActivationReasons) {
            this.humanLoopActivationReasons = HumanLoopActivationReasonsCopier.copy(humanLoopActivationReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder humanLoopActivationReasons(String... humanLoopActivationReasons) {
            humanLoopActivationReasons(Arrays.asList(humanLoopActivationReasons));
            return this;
        }

        public final void setHumanLoopActivationReasons(Collection<String> humanLoopActivationReasons) {
            this.humanLoopActivationReasons = HumanLoopActivationReasonsCopier.copy(humanLoopActivationReasons);
        }

        public final String getHumanLoopActivationConditionsEvaluationResults() {
            return humanLoopActivationConditionsEvaluationResults;
        }

        @Override
        public final Builder humanLoopActivationConditionsEvaluationResults(String humanLoopActivationConditionsEvaluationResults) {
            this.humanLoopActivationConditionsEvaluationResults = humanLoopActivationConditionsEvaluationResults;
            return this;
        }

        public final void setHumanLoopActivationConditionsEvaluationResults(String humanLoopActivationConditionsEvaluationResults) {
            this.humanLoopActivationConditionsEvaluationResults = humanLoopActivationConditionsEvaluationResults;
        }

        @Override
        public HumanLoopActivationOutput build() {
            return new HumanLoopActivationOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
