/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProjectVersionRequest extends RekognitionRequest implements
        ToCopyableBuilder<CreateProjectVersionRequest.Builder, CreateProjectVersionRequest> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateProjectVersionRequest::projectArn)).setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectArn").build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateProjectVersionRequest::versionName)).setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()).build();

    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.<OutputConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateProjectVersionRequest::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(OutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<TrainingData> TRAINING_DATA_FIELD = SdkField.<TrainingData> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateProjectVersionRequest::trainingData)).setter(setter(Builder::trainingData))
            .constructor(TrainingData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingData").build()).build();

    private static final SdkField<TestingData> TESTING_DATA_FIELD = SdkField.<TestingData> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateProjectVersionRequest::testingData)).setter(setter(Builder::testingData))
            .constructor(TestingData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestingData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD,
            VERSION_NAME_FIELD, OUTPUT_CONFIG_FIELD, TRAINING_DATA_FIELD, TESTING_DATA_FIELD));

    private final String projectArn;

    private final String versionName;

    private final OutputConfig outputConfig;

    private final TrainingData trainingData;

    private final TestingData testingData;

    private CreateProjectVersionRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.versionName = builder.versionName;
        this.outputConfig = builder.outputConfig;
        this.trainingData = builder.trainingData;
        this.testingData = builder.testingData;
    }

    /**
     * <p>
     * The ARN of the Amazon Rekognition Custom Labels project that manages the model that you want to train.
     * </p>
     * 
     * @return The ARN of the Amazon Rekognition Custom Labels project that manages the model that you want to train.
     */
    public String projectArn() {
        return projectArn;
    }

    /**
     * <p>
     * A name for the version of the model. This value must be unique.
     * </p>
     * 
     * @return A name for the version of the model. This value must be unique.
     */
    public String versionName() {
        return versionName;
    }

    /**
     * <p>
     * The Amazon S3 location to store the results of training.
     * </p>
     * 
     * @return The Amazon S3 location to store the results of training.
     */
    public OutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * The dataset to use for training.
     * </p>
     * 
     * @return The dataset to use for training.
     */
    public TrainingData trainingData() {
        return trainingData;
    }

    /**
     * <p>
     * The dataset to use for testing.
     * </p>
     * 
     * @return The dataset to use for testing.
     */
    public TestingData testingData() {
        return testingData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(trainingData());
        hashCode = 31 * hashCode + Objects.hashCode(testingData());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectVersionRequest)) {
            return false;
        }
        CreateProjectVersionRequest other = (CreateProjectVersionRequest) obj;
        return Objects.equals(projectArn(), other.projectArn()) && Objects.equals(versionName(), other.versionName())
                && Objects.equals(outputConfig(), other.outputConfig()) && Objects.equals(trainingData(), other.trainingData())
                && Objects.equals(testingData(), other.testingData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateProjectVersionRequest").add("ProjectArn", projectArn()).add("VersionName", versionName())
                .add("OutputConfig", outputConfig()).add("TrainingData", trainingData()).add("TestingData", testingData())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        case "VersionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "TrainingData":
            return Optional.ofNullable(clazz.cast(trainingData()));
        case "TestingData":
            return Optional.ofNullable(clazz.cast(testingData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProjectVersionRequest, T> g) {
        return obj -> g.apply((CreateProjectVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateProjectVersionRequest> {
        /**
         * <p>
         * The ARN of the Amazon Rekognition Custom Labels project that manages the model that you want to train.
         * </p>
         * 
         * @param projectArn
         *        The ARN of the Amazon Rekognition Custom Labels project that manages the model that you want to train.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * A name for the version of the model. This value must be unique.
         * </p>
         * 
         * @param versionName
         *        A name for the version of the model. This value must be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * <p>
         * The Amazon S3 location to store the results of training.
         * </p>
         * 
         * @param outputConfig
         *        The Amazon S3 location to store the results of training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(OutputConfig outputConfig);

        /**
         * <p>
         * The Amazon S3 location to store the results of training.
         * </p>
         * This is a convenience that creates an instance of the {@link OutputConfig.Builder} avoiding the need to
         * create one manually via {@link OutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputConfig(OutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link OutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(OutputConfig)
         */
        default Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return outputConfig(OutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * The dataset to use for training.
         * </p>
         * 
         * @param trainingData
         *        The dataset to use for training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingData(TrainingData trainingData);

        /**
         * <p>
         * The dataset to use for training.
         * </p>
         * This is a convenience that creates an instance of the {@link TrainingData.Builder} avoiding the need to
         * create one manually via {@link TrainingData#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrainingData.Builder#build()} is called immediately and its
         * result is passed to {@link #trainingData(TrainingData)}.
         * 
         * @param trainingData
         *        a consumer that will call methods on {@link TrainingData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingData(TrainingData)
         */
        default Builder trainingData(Consumer<TrainingData.Builder> trainingData) {
            return trainingData(TrainingData.builder().applyMutation(trainingData).build());
        }

        /**
         * <p>
         * The dataset to use for testing.
         * </p>
         * 
         * @param testingData
         *        The dataset to use for testing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testingData(TestingData testingData);

        /**
         * <p>
         * The dataset to use for testing.
         * </p>
         * This is a convenience that creates an instance of the {@link TestingData.Builder} avoiding the need to create
         * one manually via {@link TestingData#builder()}.
         *
         * When the {@link Consumer} completes, {@link TestingData.Builder#build()} is called immediately and its result
         * is passed to {@link #testingData(TestingData)}.
         * 
         * @param testingData
         *        a consumer that will call methods on {@link TestingData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testingData(TestingData)
         */
        default Builder testingData(Consumer<TestingData.Builder> testingData) {
            return testingData(TestingData.builder().applyMutation(testingData).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String projectArn;

        private String versionName;

        private OutputConfig outputConfig;

        private TrainingData trainingData;

        private TestingData testingData;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProjectVersionRequest model) {
            super(model);
            projectArn(model.projectArn);
            versionName(model.versionName);
            outputConfig(model.outputConfig);
            trainingData(model.trainingData);
            testingData(model.testingData);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        public final String getVersionName() {
            return versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        public final TrainingData.Builder getTrainingData() {
            return trainingData != null ? trainingData.toBuilder() : null;
        }

        @Override
        public final Builder trainingData(TrainingData trainingData) {
            this.trainingData = trainingData;
            return this;
        }

        public final void setTrainingData(TrainingData.BuilderImpl trainingData) {
            this.trainingData = trainingData != null ? trainingData.build() : null;
        }

        public final TestingData.Builder getTestingData() {
            return testingData != null ? testingData.toBuilder() : null;
        }

        @Override
        public final Builder testingData(TestingData testingData) {
            this.testingData = testingData;
            return this;
        }

        public final void setTestingData(TestingData.BuilderImpl testingData) {
            this.testingData = testingData != null ? testingData.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProjectVersionRequest build() {
            return new CreateProjectVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
