/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchFacesByImageResponse extends RekognitionResponse implements
        ToCopyableBuilder<SearchFacesByImageResponse.Builder, SearchFacesByImageResponse> {
    private static final SdkField<BoundingBox> SEARCHED_FACE_BOUNDING_BOX_FIELD = SdkField
            .<BoundingBox> builder(MarshallingType.SDK_POJO).getter(getter(SearchFacesByImageResponse::searchedFaceBoundingBox))
            .setter(setter(Builder::searchedFaceBoundingBox)).constructor(BoundingBox::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchedFaceBoundingBox").build())
            .build();

    private static final SdkField<Float> SEARCHED_FACE_CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .getter(getter(SearchFacesByImageResponse::searchedFaceConfidence)).setter(setter(Builder::searchedFaceConfidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchedFaceConfidence").build())
            .build();

    private static final SdkField<List<FaceMatch>> FACE_MATCHES_FIELD = SdkField
            .<List<FaceMatch>> builder(MarshallingType.LIST)
            .getter(getter(SearchFacesByImageResponse::faceMatches))
            .setter(setter(Builder::faceMatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceMatches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FaceMatch> builder(MarshallingType.SDK_POJO)
                                            .constructor(FaceMatch::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FACE_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchFacesByImageResponse::faceModelVersion)).setter(setter(Builder::faceModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceModelVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SEARCHED_FACE_BOUNDING_BOX_FIELD, SEARCHED_FACE_CONFIDENCE_FIELD, FACE_MATCHES_FIELD, FACE_MODEL_VERSION_FIELD));

    private final BoundingBox searchedFaceBoundingBox;

    private final Float searchedFaceConfidence;

    private final List<FaceMatch> faceMatches;

    private final String faceModelVersion;

    private SearchFacesByImageResponse(BuilderImpl builder) {
        super(builder);
        this.searchedFaceBoundingBox = builder.searchedFaceBoundingBox;
        this.searchedFaceConfidence = builder.searchedFaceConfidence;
        this.faceMatches = builder.faceMatches;
        this.faceModelVersion = builder.faceModelVersion;
    }

    /**
     * <p>
     * The bounding box around the face in the input image that Amazon Rekognition used for the search.
     * </p>
     * 
     * @return The bounding box around the face in the input image that Amazon Rekognition used for the search.
     */
    public BoundingBox searchedFaceBoundingBox() {
        return searchedFaceBoundingBox;
    }

    /**
     * <p>
     * The level of confidence that the <code>searchedFaceBoundingBox</code>, contains a face.
     * </p>
     * 
     * @return The level of confidence that the <code>searchedFaceBoundingBox</code>, contains a face.
     */
    public Float searchedFaceConfidence() {
        return searchedFaceConfidence;
    }

    /**
     * Returns true if the FaceMatches property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFaceMatches() {
        return faceMatches != null && !(faceMatches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of faces that match the input face, along with the confidence in the match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFaceMatches()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of faces that match the input face, along with the confidence in the match.
     */
    public List<FaceMatch> faceMatches() {
        return faceMatches;
    }

    /**
     * <p>
     * Version number of the face detection model associated with the input collection (<code>CollectionId</code>).
     * </p>
     * 
     * @return Version number of the face detection model associated with the input collection (
     *         <code>CollectionId</code>).
     */
    public String faceModelVersion() {
        return faceModelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(searchedFaceBoundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(searchedFaceConfidence());
        hashCode = 31 * hashCode + Objects.hashCode(faceMatches());
        hashCode = 31 * hashCode + Objects.hashCode(faceModelVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFacesByImageResponse)) {
            return false;
        }
        SearchFacesByImageResponse other = (SearchFacesByImageResponse) obj;
        return Objects.equals(searchedFaceBoundingBox(), other.searchedFaceBoundingBox())
                && Objects.equals(searchedFaceConfidence(), other.searchedFaceConfidence())
                && Objects.equals(faceMatches(), other.faceMatches())
                && Objects.equals(faceModelVersion(), other.faceModelVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SearchFacesByImageResponse").add("SearchedFaceBoundingBox", searchedFaceBoundingBox())
                .add("SearchedFaceConfidence", searchedFaceConfidence()).add("FaceMatches", faceMatches())
                .add("FaceModelVersion", faceModelVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SearchedFaceBoundingBox":
            return Optional.ofNullable(clazz.cast(searchedFaceBoundingBox()));
        case "SearchedFaceConfidence":
            return Optional.ofNullable(clazz.cast(searchedFaceConfidence()));
        case "FaceMatches":
            return Optional.ofNullable(clazz.cast(faceMatches()));
        case "FaceModelVersion":
            return Optional.ofNullable(clazz.cast(faceModelVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchFacesByImageResponse, T> g) {
        return obj -> g.apply((SearchFacesByImageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchFacesByImageResponse> {
        /**
         * <p>
         * The bounding box around the face in the input image that Amazon Rekognition used for the search.
         * </p>
         * 
         * @param searchedFaceBoundingBox
         *        The bounding box around the face in the input image that Amazon Rekognition used for the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchedFaceBoundingBox(BoundingBox searchedFaceBoundingBox);

        /**
         * <p>
         * The bounding box around the face in the input image that Amazon Rekognition used for the search.
         * </p>
         * This is a convenience that creates an instance of the {@link BoundingBox.Builder} avoiding the need to create
         * one manually via {@link BoundingBox#builder()}.
         *
         * When the {@link Consumer} completes, {@link BoundingBox.Builder#build()} is called immediately and its result
         * is passed to {@link #searchedFaceBoundingBox(BoundingBox)}.
         * 
         * @param searchedFaceBoundingBox
         *        a consumer that will call methods on {@link BoundingBox.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchedFaceBoundingBox(BoundingBox)
         */
        default Builder searchedFaceBoundingBox(Consumer<BoundingBox.Builder> searchedFaceBoundingBox) {
            return searchedFaceBoundingBox(BoundingBox.builder().applyMutation(searchedFaceBoundingBox).build());
        }

        /**
         * <p>
         * The level of confidence that the <code>searchedFaceBoundingBox</code>, contains a face.
         * </p>
         * 
         * @param searchedFaceConfidence
         *        The level of confidence that the <code>searchedFaceBoundingBox</code>, contains a face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchedFaceConfidence(Float searchedFaceConfidence);

        /**
         * <p>
         * An array of faces that match the input face, along with the confidence in the match.
         * </p>
         * 
         * @param faceMatches
         *        An array of faces that match the input face, along with the confidence in the match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceMatches(Collection<FaceMatch> faceMatches);

        /**
         * <p>
         * An array of faces that match the input face, along with the confidence in the match.
         * </p>
         * 
         * @param faceMatches
         *        An array of faces that match the input face, along with the confidence in the match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceMatches(FaceMatch... faceMatches);

        /**
         * <p>
         * An array of faces that match the input face, along with the confidence in the match.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FaceMatch>.Builder} avoiding the need to
         * create one manually via {@link List<FaceMatch>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FaceMatch>.Builder#build()} is called immediately and its
         * result is passed to {@link #faceMatches(List<FaceMatch>)}.
         * 
         * @param faceMatches
         *        a consumer that will call methods on {@link List<FaceMatch>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #faceMatches(List<FaceMatch>)
         */
        Builder faceMatches(Consumer<FaceMatch.Builder>... faceMatches);

        /**
         * <p>
         * Version number of the face detection model associated with the input collection (<code>CollectionId</code>).
         * </p>
         * 
         * @param faceModelVersion
         *        Version number of the face detection model associated with the input collection (
         *        <code>CollectionId</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceModelVersion(String faceModelVersion);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private BoundingBox searchedFaceBoundingBox;

        private Float searchedFaceConfidence;

        private List<FaceMatch> faceMatches = DefaultSdkAutoConstructList.getInstance();

        private String faceModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFacesByImageResponse model) {
            super(model);
            searchedFaceBoundingBox(model.searchedFaceBoundingBox);
            searchedFaceConfidence(model.searchedFaceConfidence);
            faceMatches(model.faceMatches);
            faceModelVersion(model.faceModelVersion);
        }

        public final BoundingBox.Builder getSearchedFaceBoundingBox() {
            return searchedFaceBoundingBox != null ? searchedFaceBoundingBox.toBuilder() : null;
        }

        @Override
        public final Builder searchedFaceBoundingBox(BoundingBox searchedFaceBoundingBox) {
            this.searchedFaceBoundingBox = searchedFaceBoundingBox;
            return this;
        }

        public final void setSearchedFaceBoundingBox(BoundingBox.BuilderImpl searchedFaceBoundingBox) {
            this.searchedFaceBoundingBox = searchedFaceBoundingBox != null ? searchedFaceBoundingBox.build() : null;
        }

        public final Float getSearchedFaceConfidence() {
            return searchedFaceConfidence;
        }

        @Override
        public final Builder searchedFaceConfidence(Float searchedFaceConfidence) {
            this.searchedFaceConfidence = searchedFaceConfidence;
            return this;
        }

        public final void setSearchedFaceConfidence(Float searchedFaceConfidence) {
            this.searchedFaceConfidence = searchedFaceConfidence;
        }

        public final Collection<FaceMatch.Builder> getFaceMatches() {
            return faceMatches != null ? faceMatches.stream().map(FaceMatch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder faceMatches(Collection<FaceMatch> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copy(faceMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(FaceMatch... faceMatches) {
            faceMatches(Arrays.asList(faceMatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(Consumer<FaceMatch.Builder>... faceMatches) {
            faceMatches(Stream.of(faceMatches).map(c -> FaceMatch.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFaceMatches(Collection<FaceMatch.BuilderImpl> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copyFromBuilder(faceMatches);
        }

        public final String getFaceModelVersion() {
            return faceModelVersion;
        }

        @Override
        public final Builder faceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
            return this;
        }

        public final void setFaceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
        }

        @Override
        public SearchFacesByImageResponse build() {
            return new SearchFacesByImageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
