/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Allows you to set attributes of the image. Currently, you can declare an image as free of personally identifiable
 * information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HumanLoopDataAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<HumanLoopDataAttributes.Builder, HumanLoopDataAttributes> {
    private static final SdkField<List<String>> CONTENT_CLASSIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(HumanLoopDataAttributes::contentClassifiersAsStrings))
            .setter(setter(Builder::contentClassifiersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentClassifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_CLASSIFIERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> contentClassifiers;

    private HumanLoopDataAttributes(BuilderImpl builder) {
        this.contentClassifiers = builder.contentClassifiers;
    }

    /**
     * <p>
     * Sets whether the input image is free of personally identifiable information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasContentClassifiers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Sets whether the input image is free of personally identifiable information.
     */
    public List<ContentClassifier> contentClassifiers() {
        return ContentClassifiersCopier.copyStringToEnum(contentClassifiers);
    }

    /**
     * Returns true if the ContentClassifiers property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasContentClassifiers() {
        return contentClassifiers != null && !(contentClassifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Sets whether the input image is free of personally identifiable information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasContentClassifiers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Sets whether the input image is free of personally identifiable information.
     */
    public List<String> contentClassifiersAsStrings() {
        return contentClassifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentClassifiersAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanLoopDataAttributes)) {
            return false;
        }
        HumanLoopDataAttributes other = (HumanLoopDataAttributes) obj;
        return Objects.equals(contentClassifiersAsStrings(), other.contentClassifiersAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HumanLoopDataAttributes").add("ContentClassifiers", contentClassifiersAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContentClassifiers":
            return Optional.ofNullable(clazz.cast(contentClassifiersAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HumanLoopDataAttributes, T> g) {
        return obj -> g.apply((HumanLoopDataAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HumanLoopDataAttributes> {
        /**
         * <p>
         * Sets whether the input image is free of personally identifiable information.
         * </p>
         * 
         * @param contentClassifiers
         *        Sets whether the input image is free of personally identifiable information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentClassifiersWithStrings(Collection<String> contentClassifiers);

        /**
         * <p>
         * Sets whether the input image is free of personally identifiable information.
         * </p>
         * 
         * @param contentClassifiers
         *        Sets whether the input image is free of personally identifiable information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentClassifiersWithStrings(String... contentClassifiers);

        /**
         * <p>
         * Sets whether the input image is free of personally identifiable information.
         * </p>
         * 
         * @param contentClassifiers
         *        Sets whether the input image is free of personally identifiable information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentClassifiers(Collection<ContentClassifier> contentClassifiers);

        /**
         * <p>
         * Sets whether the input image is free of personally identifiable information.
         * </p>
         * 
         * @param contentClassifiers
         *        Sets whether the input image is free of personally identifiable information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentClassifiers(ContentClassifier... contentClassifiers);
    }

    static final class BuilderImpl implements Builder {
        private List<String> contentClassifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HumanLoopDataAttributes model) {
            contentClassifiersWithStrings(model.contentClassifiers);
        }

        public final Collection<String> getContentClassifiersAsStrings() {
            return contentClassifiers;
        }

        @Override
        public final Builder contentClassifiersWithStrings(Collection<String> contentClassifiers) {
            this.contentClassifiers = ContentClassifiersCopier.copy(contentClassifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentClassifiersWithStrings(String... contentClassifiers) {
            contentClassifiersWithStrings(Arrays.asList(contentClassifiers));
            return this;
        }

        @Override
        public final Builder contentClassifiers(Collection<ContentClassifier> contentClassifiers) {
            this.contentClassifiers = ContentClassifiersCopier.copyEnumToString(contentClassifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentClassifiers(ContentClassifier... contentClassifiers) {
            contentClassifiers(Arrays.asList(contentClassifiers));
            return this;
        }

        public final void setContentClassifiersWithStrings(Collection<String> contentClassifiers) {
            this.contentClassifiers = ContentClassifiersCopier.copy(contentClassifiers);
        }

        @Override
        public HumanLoopDataAttributes build() {
            return new HumanLoopDataAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
