/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of optional parameters that you can use to set the criteria that the text must meet to be included in your
 * response. <code>WordFilter</code> looks at a word’s height, width, and minimum confidence.
 * <code>RegionOfInterest</code> lets you set a specific region of the image to look for text in.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectTextFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectTextFilters.Builder, DetectTextFilters> {
    private static final SdkField<DetectionFilter> WORD_FILTER_FIELD = SdkField
            .<DetectionFilter> builder(MarshallingType.SDK_POJO).getter(getter(DetectTextFilters::wordFilter))
            .setter(setter(Builder::wordFilter)).constructor(DetectionFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WordFilter").build()).build();

    private static final SdkField<List<RegionOfInterest>> REGIONS_OF_INTEREST_FIELD = SdkField
            .<List<RegionOfInterest>> builder(MarshallingType.LIST)
            .getter(getter(DetectTextFilters::regionsOfInterest))
            .setter(setter(Builder::regionsOfInterest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionsOfInterest").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegionOfInterest> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegionOfInterest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORD_FILTER_FIELD,
            REGIONS_OF_INTEREST_FIELD));

    private static final long serialVersionUID = 1L;

    private final DetectionFilter wordFilter;

    private final List<RegionOfInterest> regionsOfInterest;

    private DetectTextFilters(BuilderImpl builder) {
        this.wordFilter = builder.wordFilter;
        this.regionsOfInterest = builder.regionsOfInterest;
    }

    /**
     * Returns the value of the WordFilter property for this object.
     * 
     * @return The value of the WordFilter property for this object.
     */
    public DetectionFilter wordFilter() {
        return wordFilter;
    }

    /**
     * Returns true if the RegionsOfInterest property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRegionsOfInterest() {
        return regionsOfInterest != null && !(regionsOfInterest instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A Filter focusing on a certain area of the image. Uses a <code>BoundingBox</code> object to set the region of the
     * image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRegionsOfInterest()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A Filter focusing on a certain area of the image. Uses a <code>BoundingBox</code> object to set the
     *         region of the image.
     */
    public List<RegionOfInterest> regionsOfInterest() {
        return regionsOfInterest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(wordFilter());
        hashCode = 31 * hashCode + Objects.hashCode(regionsOfInterest());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectTextFilters)) {
            return false;
        }
        DetectTextFilters other = (DetectTextFilters) obj;
        return Objects.equals(wordFilter(), other.wordFilter()) && Objects.equals(regionsOfInterest(), other.regionsOfInterest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DetectTextFilters").add("WordFilter", wordFilter())
                .add("RegionsOfInterest", regionsOfInterest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WordFilter":
            return Optional.ofNullable(clazz.cast(wordFilter()));
        case "RegionsOfInterest":
            return Optional.ofNullable(clazz.cast(regionsOfInterest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectTextFilters, T> g) {
        return obj -> g.apply((DetectTextFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectTextFilters> {
        /**
         * Sets the value of the WordFilter property for this object.
         *
         * @param wordFilter
         *        The new value for the WordFilter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wordFilter(DetectionFilter wordFilter);

        /**
         * Sets the value of the WordFilter property for this object.
         *
         * This is a convenience that creates an instance of the {@link DetectionFilter.Builder} avoiding the need to
         * create one manually via {@link DetectionFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link DetectionFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #wordFilter(DetectionFilter)}.
         * 
         * @param wordFilter
         *        a consumer that will call methods on {@link DetectionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wordFilter(DetectionFilter)
         */
        default Builder wordFilter(Consumer<DetectionFilter.Builder> wordFilter) {
            return wordFilter(DetectionFilter.builder().applyMutation(wordFilter).build());
        }

        /**
         * <p>
         * A Filter focusing on a certain area of the image. Uses a <code>BoundingBox</code> object to set the region of
         * the image.
         * </p>
         * 
         * @param regionsOfInterest
         *        A Filter focusing on a certain area of the image. Uses a <code>BoundingBox</code> object to set the
         *        region of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionsOfInterest(Collection<RegionOfInterest> regionsOfInterest);

        /**
         * <p>
         * A Filter focusing on a certain area of the image. Uses a <code>BoundingBox</code> object to set the region of
         * the image.
         * </p>
         * 
         * @param regionsOfInterest
         *        A Filter focusing on a certain area of the image. Uses a <code>BoundingBox</code> object to set the
         *        region of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionsOfInterest(RegionOfInterest... regionsOfInterest);

        /**
         * <p>
         * A Filter focusing on a certain area of the image. Uses a <code>BoundingBox</code> object to set the region of
         * the image.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RegionOfInterest>.Builder} avoiding the
         * need to create one manually via {@link List<RegionOfInterest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RegionOfInterest>.Builder#build()} is called immediately and
         * its result is passed to {@link #regionsOfInterest(List<RegionOfInterest>)}.
         * 
         * @param regionsOfInterest
         *        a consumer that will call methods on {@link List<RegionOfInterest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regionsOfInterest(List<RegionOfInterest>)
         */
        Builder regionsOfInterest(Consumer<RegionOfInterest.Builder>... regionsOfInterest);
    }

    static final class BuilderImpl implements Builder {
        private DetectionFilter wordFilter;

        private List<RegionOfInterest> regionsOfInterest = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectTextFilters model) {
            wordFilter(model.wordFilter);
            regionsOfInterest(model.regionsOfInterest);
        }

        public final DetectionFilter.Builder getWordFilter() {
            return wordFilter != null ? wordFilter.toBuilder() : null;
        }

        @Override
        public final Builder wordFilter(DetectionFilter wordFilter) {
            this.wordFilter = wordFilter;
            return this;
        }

        public final void setWordFilter(DetectionFilter.BuilderImpl wordFilter) {
            this.wordFilter = wordFilter != null ? wordFilter.build() : null;
        }

        public final Collection<RegionOfInterest.Builder> getRegionsOfInterest() {
            return regionsOfInterest != null ? regionsOfInterest.stream().map(RegionOfInterest::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder regionsOfInterest(Collection<RegionOfInterest> regionsOfInterest) {
            this.regionsOfInterest = RegionsOfInterestCopier.copy(regionsOfInterest);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionsOfInterest(RegionOfInterest... regionsOfInterest) {
            regionsOfInterest(Arrays.asList(regionsOfInterest));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionsOfInterest(Consumer<RegionOfInterest.Builder>... regionsOfInterest) {
            regionsOfInterest(Stream.of(regionsOfInterest).map(c -> RegionOfInterest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRegionsOfInterest(Collection<RegionOfInterest.BuilderImpl> regionsOfInterest) {
            this.regionsOfInterest = RegionsOfInterestCopier.copyFromBuilder(regionsOfInterest);
        }

        @Override
        public DetectTextFilters build() {
            return new DetectTextFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
