/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectCustomLabelsRequest extends RekognitionRequest implements
        ToCopyableBuilder<DetectCustomLabelsRequest.Builder, DetectCustomLabelsRequest> {
    private static final SdkField<String> PROJECT_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DetectCustomLabelsRequest::projectVersionArn)).setter(setter(Builder::projectVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectVersionArn").build()).build();

    private static final SdkField<Image> IMAGE_FIELD = SdkField.<Image> builder(MarshallingType.SDK_POJO)
            .getter(getter(DetectCustomLabelsRequest::image)).setter(setter(Builder::image)).constructor(Image::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DetectCustomLabelsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<Float> MIN_CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .getter(getter(DetectCustomLabelsRequest::minConfidence)).setter(setter(Builder::minConfidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinConfidence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_VERSION_ARN_FIELD,
            IMAGE_FIELD, MAX_RESULTS_FIELD, MIN_CONFIDENCE_FIELD));

    private final String projectVersionArn;

    private final Image image;

    private final Integer maxResults;

    private final Float minConfidence;

    private DetectCustomLabelsRequest(BuilderImpl builder) {
        super(builder);
        this.projectVersionArn = builder.projectVersionArn;
        this.image = builder.image;
        this.maxResults = builder.maxResults;
        this.minConfidence = builder.minConfidence;
    }

    /**
     * <p>
     * The ARN of the model version that you want to use.
     * </p>
     * 
     * @return The ARN of the model version that you want to use.
     */
    public String projectVersionArn() {
        return projectVersionArn;
    }

    /**
     * Returns the value of the Image property for this object.
     * 
     * @return The value of the Image property for this object.
     */
    public Image image() {
        return image;
    }

    /**
     * <p>
     * Maximum number of results you want the service to return in the response. The service returns the specified
     * number of highest confidence labels ranked from highest confidence to lowest.
     * </p>
     * 
     * @return Maximum number of results you want the service to return in the response. The service returns the
     *         specified number of highest confidence labels ranked from highest confidence to lowest.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't return any labels
     * with a confidence lower than this specified value. If you specify a value of 0, all labels are return, regardless
     * of the default thresholds that the model version applies.
     * </p>
     * 
     * @return Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't return any
     *         labels with a confidence lower than this specified value. If you specify a value of 0, all labels are
     *         return, regardless of the default thresholds that the model version applies.
     */
    public Float minConfidence() {
        return minConfidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(minConfidence());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectCustomLabelsRequest)) {
            return false;
        }
        DetectCustomLabelsRequest other = (DetectCustomLabelsRequest) obj;
        return Objects.equals(projectVersionArn(), other.projectVersionArn()) && Objects.equals(image(), other.image())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(minConfidence(), other.minConfidence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DetectCustomLabelsRequest").add("ProjectVersionArn", projectVersionArn()).add("Image", image())
                .add("MaxResults", maxResults()).add("MinConfidence", minConfidence()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectVersionArn":
            return Optional.ofNullable(clazz.cast(projectVersionArn()));
        case "Image":
            return Optional.ofNullable(clazz.cast(image()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "MinConfidence":
            return Optional.ofNullable(clazz.cast(minConfidence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectCustomLabelsRequest, T> g) {
        return obj -> g.apply((DetectCustomLabelsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, DetectCustomLabelsRequest> {
        /**
         * <p>
         * The ARN of the model version that you want to use.
         * </p>
         * 
         * @param projectVersionArn
         *        The ARN of the model version that you want to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectVersionArn(String projectVersionArn);

        /**
         * Sets the value of the Image property for this object.
         *
         * @param image
         *        The new value for the Image property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(Image image);

        /**
         * Sets the value of the Image property for this object.
         *
         * This is a convenience that creates an instance of the {@link Image.Builder} avoiding the need to create one
         * manually via {@link Image#builder()}.
         *
         * When the {@link Consumer} completes, {@link Image.Builder#build()} is called immediately and its result is
         * passed to {@link #image(Image)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link Image.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(Image)
         */
        default Builder image(Consumer<Image.Builder> image) {
            return image(Image.builder().applyMutation(image).build());
        }

        /**
         * <p>
         * Maximum number of results you want the service to return in the response. The service returns the specified
         * number of highest confidence labels ranked from highest confidence to lowest.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of results you want the service to return in the response. The service returns the
         *        specified number of highest confidence labels ranked from highest confidence to lowest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't return any labels
         * with a confidence lower than this specified value. If you specify a value of 0, all labels are return,
         * regardless of the default thresholds that the model version applies.
         * </p>
         * 
         * @param minConfidence
         *        Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't return any
         *        labels with a confidence lower than this specified value. If you specify a value of 0, all labels are
         *        return, regardless of the default thresholds that the model version applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minConfidence(Float minConfidence);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String projectVersionArn;

        private Image image;

        private Integer maxResults;

        private Float minConfidence;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectCustomLabelsRequest model) {
            super(model);
            projectVersionArn(model.projectVersionArn);
            image(model.image);
            maxResults(model.maxResults);
            minConfidence(model.minConfidence);
        }

        public final String getProjectVersionArn() {
            return projectVersionArn;
        }

        @Override
        public final Builder projectVersionArn(String projectVersionArn) {
            this.projectVersionArn = projectVersionArn;
            return this;
        }

        public final void setProjectVersionArn(String projectVersionArn) {
            this.projectVersionArn = projectVersionArn;
        }

        public final Image.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Float getMinConfidence() {
            return minConfidence;
        }

        @Override
        public final Builder minConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
            return this;
        }

        public final void setMinConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetectCustomLabelsRequest build() {
            return new DetectCustomLabelsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
