/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFacesResponse extends RekognitionResponse implements
        ToCopyableBuilder<ListFacesResponse.Builder, ListFacesResponse> {
    private static final SdkField<List<Face>> FACES_FIELD = SdkField
            .<List<Face>> builder(MarshallingType.LIST)
            .getter(getter(ListFacesResponse::faces))
            .setter(setter(Builder::faces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Faces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Face> builder(MarshallingType.SDK_POJO)
                                            .constructor(Face::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListFacesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> FACE_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListFacesResponse::faceModelVersion)).setter(setter(Builder::faceModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceModelVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACES_FIELD, NEXT_TOKEN_FIELD,
            FACE_MODEL_VERSION_FIELD));

    private final List<Face> faces;

    private final String nextToken;

    private final String faceModelVersion;

    private ListFacesResponse(BuilderImpl builder) {
        super(builder);
        this.faces = builder.faces;
        this.nextToken = builder.nextToken;
        this.faceModelVersion = builder.faceModelVersion;
    }

    /**
     * Returns true if the Faces property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFaces() {
        return faces != null && !(faces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>Face</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFaces()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>Face</code> objects.
     */
    public List<Face> faces() {
        return faces;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Rekognition returns this token that you can use in the subsequent request to
     * retrieve the next set of faces.
     * </p>
     * 
     * @return If the response is truncated, Amazon Rekognition returns this token that you can use in the subsequent
     *         request to retrieve the next set of faces.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Version number of the face detection model associated with the input collection (<code>CollectionId</code>).
     * </p>
     * 
     * @return Version number of the face detection model associated with the input collection (
     *         <code>CollectionId</code>).
     */
    public String faceModelVersion() {
        return faceModelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(faces());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(faceModelVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFacesResponse)) {
            return false;
        }
        ListFacesResponse other = (ListFacesResponse) obj;
        return Objects.equals(faces(), other.faces()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(faceModelVersion(), other.faceModelVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListFacesResponse").add("Faces", faces()).add("NextToken", nextToken())
                .add("FaceModelVersion", faceModelVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Faces":
            return Optional.ofNullable(clazz.cast(faces()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "FaceModelVersion":
            return Optional.ofNullable(clazz.cast(faceModelVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFacesResponse, T> g) {
        return obj -> g.apply((ListFacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFacesResponse> {
        /**
         * <p>
         * An array of <code>Face</code> objects.
         * </p>
         * 
         * @param faces
         *        An array of <code>Face</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faces(Collection<Face> faces);

        /**
         * <p>
         * An array of <code>Face</code> objects.
         * </p>
         * 
         * @param faces
         *        An array of <code>Face</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faces(Face... faces);

        /**
         * <p>
         * An array of <code>Face</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Face>.Builder} avoiding the need to create
         * one manually via {@link List<Face>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Face>.Builder#build()} is called immediately and its result
         * is passed to {@link #faces(List<Face>)}.
         * 
         * @param faces
         *        a consumer that will call methods on {@link List<Face>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #faces(List<Face>)
         */
        Builder faces(Consumer<Face.Builder>... faces);

        /**
         * <p>
         * If the response is truncated, Amazon Rekognition returns this token that you can use in the subsequent
         * request to retrieve the next set of faces.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Rekognition returns this token that you can use in the subsequent
         *        request to retrieve the next set of faces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Version number of the face detection model associated with the input collection (<code>CollectionId</code>).
         * </p>
         * 
         * @param faceModelVersion
         *        Version number of the face detection model associated with the input collection (
         *        <code>CollectionId</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceModelVersion(String faceModelVersion);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<Face> faces = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String faceModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFacesResponse model) {
            super(model);
            faces(model.faces);
            nextToken(model.nextToken);
            faceModelVersion(model.faceModelVersion);
        }

        public final Collection<Face.Builder> getFaces() {
            return faces != null ? faces.stream().map(Face::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder faces(Collection<Face> faces) {
            this.faces = FaceListCopier.copy(faces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faces(Face... faces) {
            faces(Arrays.asList(faces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faces(Consumer<Face.Builder>... faces) {
            faces(Stream.of(faces).map(c -> Face.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFaces(Collection<Face.BuilderImpl> faces) {
            this.faces = FaceListCopier.copyFromBuilder(faces);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getFaceModelVersion() {
            return faceModelVersion;
        }

        @Override
        public final Builder faceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
            return this;
        }

        public final void setFaceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
        }

        @Override
        public ListFacesResponse build() {
            return new ListFacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
