/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSegmentDetectionResponse extends RekognitionResponse implements
        ToCopyableBuilder<GetSegmentDetectionResponse.Builder, GetSegmentDetectionResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSegmentDetectionResponse::jobStatusAsString)).setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSegmentDetectionResponse::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<List<VideoMetadata>> VIDEO_METADATA_FIELD = SdkField
            .<List<VideoMetadata>> builder(MarshallingType.LIST)
            .getter(getter(GetSegmentDetectionResponse::videoMetadata))
            .setter(setter(Builder::videoMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VideoMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VideoMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(VideoMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AudioMetadata>> AUDIO_METADATA_FIELD = SdkField
            .<List<AudioMetadata>> builder(MarshallingType.LIST)
            .getter(getter(GetSegmentDetectionResponse::audioMetadata))
            .setter(setter(Builder::audioMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AudioMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(AudioMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSegmentDetectionResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<SegmentDetection>> SEGMENTS_FIELD = SdkField
            .<List<SegmentDetection>> builder(MarshallingType.LIST)
            .getter(getter(GetSegmentDetectionResponse::segments))
            .setter(setter(Builder::segments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Segments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SegmentDetection> builder(MarshallingType.SDK_POJO)
                                            .constructor(SegmentDetection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SegmentTypeInfo>> SELECTED_SEGMENT_TYPES_FIELD = SdkField
            .<List<SegmentTypeInfo>> builder(MarshallingType.LIST)
            .getter(getter(GetSegmentDetectionResponse::selectedSegmentTypes))
            .setter(setter(Builder::selectedSegmentTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedSegmentTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SegmentTypeInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(SegmentTypeInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD,
            STATUS_MESSAGE_FIELD, VIDEO_METADATA_FIELD, AUDIO_METADATA_FIELD, NEXT_TOKEN_FIELD, SEGMENTS_FIELD,
            SELECTED_SEGMENT_TYPES_FIELD));

    private final String jobStatus;

    private final String statusMessage;

    private final List<VideoMetadata> videoMetadata;

    private final List<AudioMetadata> audioMetadata;

    private final String nextToken;

    private final List<SegmentDetection> segments;

    private final List<SegmentTypeInfo> selectedSegmentTypes;

    private GetSegmentDetectionResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.statusMessage = builder.statusMessage;
        this.videoMetadata = builder.videoMetadata;
        this.audioMetadata = builder.audioMetadata;
        this.nextToken = builder.nextToken;
        this.segments = builder.segments;
        this.selectedSegmentTypes = builder.selectedSegmentTypes;
    }

    /**
     * <p>
     * Current status of the segment detection job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link VideoJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return Current status of the segment detection job.
     * @see VideoJobStatus
     */
    public VideoJobStatus jobStatus() {
        return VideoJobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * Current status of the segment detection job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link VideoJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return Current status of the segment detection job.
     * @see VideoJobStatus
     */
    public String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * If the job fails, <code>StatusMessage</code> provides a descriptive error message.
     * </p>
     * 
     * @return If the job fails, <code>StatusMessage</code> provides a descriptive error message.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * Returns true if the VideoMetadata property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasVideoMetadata() {
        return videoMetadata != null && !(videoMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Currently, Amazon Rekognition Video returns a single object in the <code>VideoMetadata</code> array. The object
     * contains information about the video stream in the input file that Amazon Rekognition Video chose to analyze. The
     * <code>VideoMetadata</code> object includes the video codec, video format and other information. Video metadata is
     * returned in each page of information returned by <code>GetSegmentDetection</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVideoMetadata()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Currently, Amazon Rekognition Video returns a single object in the <code>VideoMetadata</code> array. The
     *         object contains information about the video stream in the input file that Amazon Rekognition Video chose
     *         to analyze. The <code>VideoMetadata</code> object includes the video codec, video format and other
     *         information. Video metadata is returned in each page of information returned by
     *         <code>GetSegmentDetection</code>.
     */
    public List<VideoMetadata> videoMetadata() {
        return videoMetadata;
    }

    /**
     * Returns true if the AudioMetadata property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAudioMetadata() {
        return audioMetadata != null && !(audioMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects. There can be multiple audio streams. Each <code>AudioMetadata</code> object contains
     * metadata for a single audio stream. Audio information in an <code>AudioMetadata</code> objects includes the audio
     * codec, the number of audio channels, the duration of the audio stream, and the sample rate. Audio metadata is
     * returned in each page of information returned by <code>GetSegmentDetection</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAudioMetadata()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects. There can be multiple audio streams. Each <code>AudioMetadata</code> object contains
     *         metadata for a single audio stream. Audio information in an <code>AudioMetadata</code> objects includes
     *         the audio codec, the number of audio channels, the duration of the audio stream, and the sample rate.
     *         Audio metadata is returned in each page of information returned by <code>GetSegmentDetection</code>.
     */
    public List<AudioMetadata> audioMetadata() {
        return audioMetadata;
    }

    /**
     * <p>
     * If the previous response was incomplete (because there are more labels to retrieve), Amazon Rekognition Video
     * returns a pagination token in the response. You can use this pagination token to retrieve the next set of text.
     * </p>
     * 
     * @return If the previous response was incomplete (because there are more labels to retrieve), Amazon Rekognition
     *         Video returns a pagination token in the response. You can use this pagination token to retrieve the next
     *         set of text.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Segments property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSegments() {
        return segments != null && !(segments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of segments detected in a video.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSegments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of segments detected in a video.
     */
    public List<SegmentDetection> segments() {
        return segments;
    }

    /**
     * Returns true if the SelectedSegmentTypes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSelectedSegmentTypes() {
        return selectedSegmentTypes != null && !(selectedSegmentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array containing the segment types requested in the call to <code>StartSegmentDetection</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSelectedSegmentTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array containing the segment types requested in the call to <code>StartSegmentDetection</code>.
     */
    public List<SegmentTypeInfo> selectedSegmentTypes() {
        return selectedSegmentTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(videoMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(audioMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(segments());
        hashCode = 31 * hashCode + Objects.hashCode(selectedSegmentTypes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSegmentDetectionResponse)) {
            return false;
        }
        GetSegmentDetectionResponse other = (GetSegmentDetectionResponse) obj;
        return Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(videoMetadata(), other.videoMetadata())
                && Objects.equals(audioMetadata(), other.audioMetadata()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(segments(), other.segments())
                && Objects.equals(selectedSegmentTypes(), other.selectedSegmentTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetSegmentDetectionResponse").add("JobStatus", jobStatusAsString())
                .add("StatusMessage", statusMessage()).add("VideoMetadata", videoMetadata())
                .add("AudioMetadata", audioMetadata()).add("NextToken", nextToken()).add("Segments", segments())
                .add("SelectedSegmentTypes", selectedSegmentTypes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "VideoMetadata":
            return Optional.ofNullable(clazz.cast(videoMetadata()));
        case "AudioMetadata":
            return Optional.ofNullable(clazz.cast(audioMetadata()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Segments":
            return Optional.ofNullable(clazz.cast(segments()));
        case "SelectedSegmentTypes":
            return Optional.ofNullable(clazz.cast(selectedSegmentTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSegmentDetectionResponse, T> g) {
        return obj -> g.apply((GetSegmentDetectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSegmentDetectionResponse> {
        /**
         * <p>
         * Current status of the segment detection job.
         * </p>
         * 
         * @param jobStatus
         *        Current status of the segment detection job.
         * @see VideoJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoJobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * Current status of the segment detection job.
         * </p>
         * 
         * @param jobStatus
         *        Current status of the segment detection job.
         * @see VideoJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoJobStatus
         */
        Builder jobStatus(VideoJobStatus jobStatus);

        /**
         * <p>
         * If the job fails, <code>StatusMessage</code> provides a descriptive error message.
         * </p>
         * 
         * @param statusMessage
         *        If the job fails, <code>StatusMessage</code> provides a descriptive error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Currently, Amazon Rekognition Video returns a single object in the <code>VideoMetadata</code> array. The
         * object contains information about the video stream in the input file that Amazon Rekognition Video chose to
         * analyze. The <code>VideoMetadata</code> object includes the video codec, video format and other information.
         * Video metadata is returned in each page of information returned by <code>GetSegmentDetection</code>.
         * </p>
         * 
         * @param videoMetadata
         *        Currently, Amazon Rekognition Video returns a single object in the <code>VideoMetadata</code> array.
         *        The object contains information about the video stream in the input file that Amazon Rekognition Video
         *        chose to analyze. The <code>VideoMetadata</code> object includes the video codec, video format and
         *        other information. Video metadata is returned in each page of information returned by
         *        <code>GetSegmentDetection</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoMetadata(Collection<VideoMetadata> videoMetadata);

        /**
         * <p>
         * Currently, Amazon Rekognition Video returns a single object in the <code>VideoMetadata</code> array. The
         * object contains information about the video stream in the input file that Amazon Rekognition Video chose to
         * analyze. The <code>VideoMetadata</code> object includes the video codec, video format and other information.
         * Video metadata is returned in each page of information returned by <code>GetSegmentDetection</code>.
         * </p>
         * 
         * @param videoMetadata
         *        Currently, Amazon Rekognition Video returns a single object in the <code>VideoMetadata</code> array.
         *        The object contains information about the video stream in the input file that Amazon Rekognition Video
         *        chose to analyze. The <code>VideoMetadata</code> object includes the video codec, video format and
         *        other information. Video metadata is returned in each page of information returned by
         *        <code>GetSegmentDetection</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoMetadata(VideoMetadata... videoMetadata);

        /**
         * <p>
         * Currently, Amazon Rekognition Video returns a single object in the <code>VideoMetadata</code> array. The
         * object contains information about the video stream in the input file that Amazon Rekognition Video chose to
         * analyze. The <code>VideoMetadata</code> object includes the video codec, video format and other information.
         * Video metadata is returned in each page of information returned by <code>GetSegmentDetection</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VideoMetadata>.Builder} avoiding the need
         * to create one manually via {@link List<VideoMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VideoMetadata>.Builder#build()} is called immediately and
         * its result is passed to {@link #videoMetadata(List<VideoMetadata>)}.
         * 
         * @param videoMetadata
         *        a consumer that will call methods on {@link List<VideoMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #videoMetadata(List<VideoMetadata>)
         */
        Builder videoMetadata(Consumer<VideoMetadata.Builder>... videoMetadata);

        /**
         * <p>
         * An array of objects. There can be multiple audio streams. Each <code>AudioMetadata</code> object contains
         * metadata for a single audio stream. Audio information in an <code>AudioMetadata</code> objects includes the
         * audio codec, the number of audio channels, the duration of the audio stream, and the sample rate. Audio
         * metadata is returned in each page of information returned by <code>GetSegmentDetection</code>.
         * </p>
         * 
         * @param audioMetadata
         *        An array of objects. There can be multiple audio streams. Each <code>AudioMetadata</code> object
         *        contains metadata for a single audio stream. Audio information in an <code>AudioMetadata</code>
         *        objects includes the audio codec, the number of audio channels, the duration of the audio stream, and
         *        the sample rate. Audio metadata is returned in each page of information returned by
         *        <code>GetSegmentDetection</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioMetadata(Collection<AudioMetadata> audioMetadata);

        /**
         * <p>
         * An array of objects. There can be multiple audio streams. Each <code>AudioMetadata</code> object contains
         * metadata for a single audio stream. Audio information in an <code>AudioMetadata</code> objects includes the
         * audio codec, the number of audio channels, the duration of the audio stream, and the sample rate. Audio
         * metadata is returned in each page of information returned by <code>GetSegmentDetection</code>.
         * </p>
         * 
         * @param audioMetadata
         *        An array of objects. There can be multiple audio streams. Each <code>AudioMetadata</code> object
         *        contains metadata for a single audio stream. Audio information in an <code>AudioMetadata</code>
         *        objects includes the audio codec, the number of audio channels, the duration of the audio stream, and
         *        the sample rate. Audio metadata is returned in each page of information returned by
         *        <code>GetSegmentDetection</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioMetadata(AudioMetadata... audioMetadata);

        /**
         * <p>
         * An array of objects. There can be multiple audio streams. Each <code>AudioMetadata</code> object contains
         * metadata for a single audio stream. Audio information in an <code>AudioMetadata</code> objects includes the
         * audio codec, the number of audio channels, the duration of the audio stream, and the sample rate. Audio
         * metadata is returned in each page of information returned by <code>GetSegmentDetection</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AudioMetadata>.Builder} avoiding the need
         * to create one manually via {@link List<AudioMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AudioMetadata>.Builder#build()} is called immediately and
         * its result is passed to {@link #audioMetadata(List<AudioMetadata>)}.
         * 
         * @param audioMetadata
         *        a consumer that will call methods on {@link List<AudioMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audioMetadata(List<AudioMetadata>)
         */
        Builder audioMetadata(Consumer<AudioMetadata.Builder>... audioMetadata);

        /**
         * <p>
         * If the previous response was incomplete (because there are more labels to retrieve), Amazon Rekognition Video
         * returns a pagination token in the response. You can use this pagination token to retrieve the next set of
         * text.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was incomplete (because there are more labels to retrieve), Amazon
         *        Rekognition Video returns a pagination token in the response. You can use this pagination token to
         *        retrieve the next set of text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of segments detected in a video.
         * </p>
         * 
         * @param segments
         *        An array of segments detected in a video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segments(Collection<SegmentDetection> segments);

        /**
         * <p>
         * An array of segments detected in a video.
         * </p>
         * 
         * @param segments
         *        An array of segments detected in a video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segments(SegmentDetection... segments);

        /**
         * <p>
         * An array of segments detected in a video.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SegmentDetection>.Builder} avoiding the
         * need to create one manually via {@link List<SegmentDetection>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SegmentDetection>.Builder#build()} is called immediately and
         * its result is passed to {@link #segments(List<SegmentDetection>)}.
         * 
         * @param segments
         *        a consumer that will call methods on {@link List<SegmentDetection>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segments(List<SegmentDetection>)
         */
        Builder segments(Consumer<SegmentDetection.Builder>... segments);

        /**
         * <p>
         * An array containing the segment types requested in the call to <code>StartSegmentDetection</code>.
         * </p>
         * 
         * @param selectedSegmentTypes
         *        An array containing the segment types requested in the call to <code>StartSegmentDetection</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedSegmentTypes(Collection<SegmentTypeInfo> selectedSegmentTypes);

        /**
         * <p>
         * An array containing the segment types requested in the call to <code>StartSegmentDetection</code>.
         * </p>
         * 
         * @param selectedSegmentTypes
         *        An array containing the segment types requested in the call to <code>StartSegmentDetection</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedSegmentTypes(SegmentTypeInfo... selectedSegmentTypes);

        /**
         * <p>
         * An array containing the segment types requested in the call to <code>StartSegmentDetection</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SegmentTypeInfo>.Builder} avoiding the need
         * to create one manually via {@link List<SegmentTypeInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SegmentTypeInfo>.Builder#build()} is called immediately and
         * its result is passed to {@link #selectedSegmentTypes(List<SegmentTypeInfo>)}.
         * 
         * @param selectedSegmentTypes
         *        a consumer that will call methods on {@link List<SegmentTypeInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectedSegmentTypes(List<SegmentTypeInfo>)
         */
        Builder selectedSegmentTypes(Consumer<SegmentTypeInfo.Builder>... selectedSegmentTypes);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private String jobStatus;

        private String statusMessage;

        private List<VideoMetadata> videoMetadata = DefaultSdkAutoConstructList.getInstance();

        private List<AudioMetadata> audioMetadata = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private List<SegmentDetection> segments = DefaultSdkAutoConstructList.getInstance();

        private List<SegmentTypeInfo> selectedSegmentTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSegmentDetectionResponse model) {
            super(model);
            jobStatus(model.jobStatus);
            statusMessage(model.statusMessage);
            videoMetadata(model.videoMetadata);
            audioMetadata(model.audioMetadata);
            nextToken(model.nextToken);
            segments(model.segments);
            selectedSegmentTypes(model.selectedSegmentTypes);
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(VideoJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Collection<VideoMetadata.Builder> getVideoMetadata() {
            return videoMetadata != null ? videoMetadata.stream().map(VideoMetadata::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder videoMetadata(Collection<VideoMetadata> videoMetadata) {
            this.videoMetadata = VideoMetadataListCopier.copy(videoMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder videoMetadata(VideoMetadata... videoMetadata) {
            videoMetadata(Arrays.asList(videoMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder videoMetadata(Consumer<VideoMetadata.Builder>... videoMetadata) {
            videoMetadata(Stream.of(videoMetadata).map(c -> VideoMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVideoMetadata(Collection<VideoMetadata.BuilderImpl> videoMetadata) {
            this.videoMetadata = VideoMetadataListCopier.copyFromBuilder(videoMetadata);
        }

        public final Collection<AudioMetadata.Builder> getAudioMetadata() {
            return audioMetadata != null ? audioMetadata.stream().map(AudioMetadata::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder audioMetadata(Collection<AudioMetadata> audioMetadata) {
            this.audioMetadata = AudioMetadataListCopier.copy(audioMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioMetadata(AudioMetadata... audioMetadata) {
            audioMetadata(Arrays.asList(audioMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioMetadata(Consumer<AudioMetadata.Builder>... audioMetadata) {
            audioMetadata(Stream.of(audioMetadata).map(c -> AudioMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAudioMetadata(Collection<AudioMetadata.BuilderImpl> audioMetadata) {
            this.audioMetadata = AudioMetadataListCopier.copyFromBuilder(audioMetadata);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<SegmentDetection.Builder> getSegments() {
            return segments != null ? segments.stream().map(SegmentDetection::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder segments(Collection<SegmentDetection> segments) {
            this.segments = SegmentDetectionsCopier.copy(segments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segments(SegmentDetection... segments) {
            segments(Arrays.asList(segments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segments(Consumer<SegmentDetection.Builder>... segments) {
            segments(Stream.of(segments).map(c -> SegmentDetection.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSegments(Collection<SegmentDetection.BuilderImpl> segments) {
            this.segments = SegmentDetectionsCopier.copyFromBuilder(segments);
        }

        public final Collection<SegmentTypeInfo.Builder> getSelectedSegmentTypes() {
            return selectedSegmentTypes != null ? selectedSegmentTypes.stream().map(SegmentTypeInfo::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder selectedSegmentTypes(Collection<SegmentTypeInfo> selectedSegmentTypes) {
            this.selectedSegmentTypes = SegmentTypesInfoCopier.copy(selectedSegmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedSegmentTypes(SegmentTypeInfo... selectedSegmentTypes) {
            selectedSegmentTypes(Arrays.asList(selectedSegmentTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedSegmentTypes(Consumer<SegmentTypeInfo.Builder>... selectedSegmentTypes) {
            selectedSegmentTypes(Stream.of(selectedSegmentTypes).map(c -> SegmentTypeInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSelectedSegmentTypes(Collection<SegmentTypeInfo.BuilderImpl> selectedSegmentTypes) {
            this.selectedSegmentTypes = SegmentTypesInfoCopier.copyFromBuilder(selectedSegmentTypes);
        }

        @Override
        public GetSegmentDetectionResponse build() {
            return new GetSegmentDetectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
