/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCollectionsResponse extends RekognitionResponse implements
        ToCopyableBuilder<ListCollectionsResponse.Builder, ListCollectionsResponse> {
    private static final SdkField<List<String>> COLLECTION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListCollectionsResponse::collectionIds))
            .setter(setter(Builder::collectionIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCollectionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<String>> FACE_MODEL_VERSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListCollectionsResponse::faceModelVersions))
            .setter(setter(Builder::faceModelVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceModelVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_IDS_FIELD,
            NEXT_TOKEN_FIELD, FACE_MODEL_VERSIONS_FIELD));

    private final List<String> collectionIds;

    private final String nextToken;

    private final List<String> faceModelVersions;

    private ListCollectionsResponse(BuilderImpl builder) {
        super(builder);
        this.collectionIds = builder.collectionIds;
        this.nextToken = builder.nextToken;
        this.faceModelVersions = builder.faceModelVersions;
    }

    /**
     * Returns true if the CollectionIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCollectionIds() {
        return collectionIds != null && !(collectionIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of collection IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCollectionIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of collection IDs.
     */
    public List<String> collectionIds() {
        return collectionIds;
    }

    /**
     * <p>
     * If the result is truncated, the response provides a <code>NextToken</code> that you can use in the subsequent
     * request to fetch the next set of collection IDs.
     * </p>
     * 
     * @return If the result is truncated, the response provides a <code>NextToken</code> that you can use in the
     *         subsequent request to fetch the next set of collection IDs.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the FaceModelVersions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasFaceModelVersions() {
        return faceModelVersions != null && !(faceModelVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Version numbers of the face detection models associated with the collections in the array
     * <code>CollectionIds</code>. For example, the value of <code>FaceModelVersions[2]</code> is the version number for
     * the face detection model used by the collection in <code>CollectionId[2]</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFaceModelVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Version numbers of the face detection models associated with the collections in the array
     *         <code>CollectionIds</code>. For example, the value of <code>FaceModelVersions[2]</code> is the version
     *         number for the face detection model used by the collection in <code>CollectionId[2]</code>.
     */
    public List<String> faceModelVersions() {
        return faceModelVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collectionIds());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(faceModelVersions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollectionsResponse)) {
            return false;
        }
        ListCollectionsResponse other = (ListCollectionsResponse) obj;
        return Objects.equals(collectionIds(), other.collectionIds()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(faceModelVersions(), other.faceModelVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListCollectionsResponse").add("CollectionIds", collectionIds()).add("NextToken", nextToken())
                .add("FaceModelVersions", faceModelVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionIds":
            return Optional.ofNullable(clazz.cast(collectionIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "FaceModelVersions":
            return Optional.ofNullable(clazz.cast(faceModelVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCollectionsResponse, T> g) {
        return obj -> g.apply((ListCollectionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCollectionsResponse> {
        /**
         * <p>
         * An array of collection IDs.
         * </p>
         * 
         * @param collectionIds
         *        An array of collection IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionIds(Collection<String> collectionIds);

        /**
         * <p>
         * An array of collection IDs.
         * </p>
         * 
         * @param collectionIds
         *        An array of collection IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionIds(String... collectionIds);

        /**
         * <p>
         * If the result is truncated, the response provides a <code>NextToken</code> that you can use in the subsequent
         * request to fetch the next set of collection IDs.
         * </p>
         * 
         * @param nextToken
         *        If the result is truncated, the response provides a <code>NextToken</code> that you can use in the
         *        subsequent request to fetch the next set of collection IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Version numbers of the face detection models associated with the collections in the array
         * <code>CollectionIds</code>. For example, the value of <code>FaceModelVersions[2]</code> is the version number
         * for the face detection model used by the collection in <code>CollectionId[2]</code>.
         * </p>
         * 
         * @param faceModelVersions
         *        Version numbers of the face detection models associated with the collections in the array
         *        <code>CollectionIds</code>. For example, the value of <code>FaceModelVersions[2]</code> is the version
         *        number for the face detection model used by the collection in <code>CollectionId[2]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceModelVersions(Collection<String> faceModelVersions);

        /**
         * <p>
         * Version numbers of the face detection models associated with the collections in the array
         * <code>CollectionIds</code>. For example, the value of <code>FaceModelVersions[2]</code> is the version number
         * for the face detection model used by the collection in <code>CollectionId[2]</code>.
         * </p>
         * 
         * @param faceModelVersions
         *        Version numbers of the face detection models associated with the collections in the array
         *        <code>CollectionIds</code>. For example, the value of <code>FaceModelVersions[2]</code> is the version
         *        number for the face detection model used by the collection in <code>CollectionId[2]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceModelVersions(String... faceModelVersions);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<String> collectionIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private List<String> faceModelVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollectionsResponse model) {
            super(model);
            collectionIds(model.collectionIds);
            nextToken(model.nextToken);
            faceModelVersions(model.faceModelVersions);
        }

        public final Collection<String> getCollectionIds() {
            return collectionIds;
        }

        @Override
        public final Builder collectionIds(Collection<String> collectionIds) {
            this.collectionIds = CollectionIdListCopier.copy(collectionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectionIds(String... collectionIds) {
            collectionIds(Arrays.asList(collectionIds));
            return this;
        }

        public final void setCollectionIds(Collection<String> collectionIds) {
            this.collectionIds = CollectionIdListCopier.copy(collectionIds);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getFaceModelVersions() {
            return faceModelVersions;
        }

        @Override
        public final Builder faceModelVersions(Collection<String> faceModelVersions) {
            this.faceModelVersions = FaceModelVersionListCopier.copy(faceModelVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceModelVersions(String... faceModelVersions) {
            faceModelVersions(Arrays.asList(faceModelVersions));
            return this;
        }

        public final void setFaceModelVersions(Collection<String> faceModelVersions) {
            this.faceModelVersions = FaceModelVersionListCopier.copy(faceModelVersions);
        }

        @Override
        public ListCollectionsResponse build() {
            return new ListCollectionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
