/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectLabelsRequest extends RekognitionRequest implements
        ToCopyableBuilder<DetectLabelsRequest.Builder, DetectLabelsRequest> {
    private static final SdkField<Image> IMAGE_FIELD = SdkField.<Image> builder(MarshallingType.SDK_POJO)
            .getter(getter(DetectLabelsRequest::image)).setter(setter(Builder::image)).constructor(Image::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()).build();

    private static final SdkField<Integer> MAX_LABELS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DetectLabelsRequest::maxLabels)).setter(setter(Builder::maxLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxLabels").build()).build();

    private static final SdkField<Float> MIN_CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .getter(getter(DetectLabelsRequest::minConfidence)).setter(setter(Builder::minConfidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinConfidence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_FIELD, MAX_LABELS_FIELD,
            MIN_CONFIDENCE_FIELD));

    private final Image image;

    private final Integer maxLabels;

    private final Float minConfidence;

    private DetectLabelsRequest(BuilderImpl builder) {
        super(builder);
        this.image = builder.image;
        this.maxLabels = builder.maxLabels;
        this.minConfidence = builder.minConfidence;
    }

    /**
     * <p>
     * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition
     * operations, passing image bytes is not supported. Images stored in an S3 Bucket do not need to be base64-encoded.
     * </p>
     * <p>
     * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed
     * using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.
     * </p>
     * 
     * @return The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon
     *         Rekognition operations, passing image bytes is not supported. Images stored in an S3 Bucket do not need
     *         to be base64-encoded.</p>
     *         <p>
     *         If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
     *         passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition
     *         developer guide.
     */
    public Image image() {
        return image;
    }

    /**
     * <p>
     * Maximum number of labels you want the service to return in the response. The service returns the specified number
     * of highest confidence labels.
     * </p>
     * 
     * @return Maximum number of labels you want the service to return in the response. The service returns the
     *         specified number of highest confidence labels.
     */
    public Integer maxLabels() {
        return maxLabels;
    }

    /**
     * <p>
     * Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't return any labels
     * with confidence lower than this specified value.
     * </p>
     * <p>
     * If <code>MinConfidence</code> is not specified, the operation returns labels with a confidence values greater
     * than or equal to 55 percent.
     * </p>
     * 
     * @return Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't return any
     *         labels with confidence lower than this specified value.</p>
     *         <p>
     *         If <code>MinConfidence</code> is not specified, the operation returns labels with a confidence values
     *         greater than or equal to 55 percent.
     */
    public Float minConfidence() {
        return minConfidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(maxLabels());
        hashCode = 31 * hashCode + Objects.hashCode(minConfidence());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectLabelsRequest)) {
            return false;
        }
        DetectLabelsRequest other = (DetectLabelsRequest) obj;
        return Objects.equals(image(), other.image()) && Objects.equals(maxLabels(), other.maxLabels())
                && Objects.equals(minConfidence(), other.minConfidence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DetectLabelsRequest").add("Image", image()).add("MaxLabels", maxLabels())
                .add("MinConfidence", minConfidence()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Image":
            return Optional.ofNullable(clazz.cast(image()));
        case "MaxLabels":
            return Optional.ofNullable(clazz.cast(maxLabels()));
        case "MinConfidence":
            return Optional.ofNullable(clazz.cast(minConfidence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectLabelsRequest, T> g) {
        return obj -> g.apply((DetectLabelsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, DetectLabelsRequest> {
        /**
         * <p>
         * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition
         * operations, passing image bytes is not supported. Images stored in an S3 Bucket do not need to be
         * base64-encoded.
         * </p>
         * <p>
         * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
         * passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition
         * developer guide.
         * </p>
         * 
         * @param image
         *        The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon
         *        Rekognition operations, passing image bytes is not supported. Images stored in an S3 Bucket do not
         *        need to be base64-encoded.</p>
         *        <p>
         *        If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image
         *        bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon
         *        Rekognition developer guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(Image image);

        /**
         * <p>
         * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition
         * operations, passing image bytes is not supported. Images stored in an S3 Bucket do not need to be
         * base64-encoded.
         * </p>
         * <p>
         * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
         * passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition
         * developer guide.
         * </p>
         * This is a convenience that creates an instance of the {@link Image.Builder} avoiding the need to create one
         * manually via {@link Image#builder()}.
         *
         * When the {@link Consumer} completes, {@link Image.Builder#build()} is called immediately and its result is
         * passed to {@link #image(Image)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link Image.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(Image)
         */
        default Builder image(Consumer<Image.Builder> image) {
            return image(Image.builder().applyMutation(image).build());
        }

        /**
         * <p>
         * Maximum number of labels you want the service to return in the response. The service returns the specified
         * number of highest confidence labels.
         * </p>
         * 
         * @param maxLabels
         *        Maximum number of labels you want the service to return in the response. The service returns the
         *        specified number of highest confidence labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLabels(Integer maxLabels);

        /**
         * <p>
         * Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't return any labels
         * with confidence lower than this specified value.
         * </p>
         * <p>
         * If <code>MinConfidence</code> is not specified, the operation returns labels with a confidence values greater
         * than or equal to 55 percent.
         * </p>
         * 
         * @param minConfidence
         *        Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't return any
         *        labels with confidence lower than this specified value.</p>
         *        <p>
         *        If <code>MinConfidence</code> is not specified, the operation returns labels with a confidence values
         *        greater than or equal to 55 percent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minConfidence(Float minConfidence);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private Image image;

        private Integer maxLabels;

        private Float minConfidence;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectLabelsRequest model) {
            super(model);
            image(model.image);
            maxLabels(model.maxLabels);
            minConfidence(model.minConfidence);
        }

        public final Image.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        public final Integer getMaxLabels() {
            return maxLabels;
        }

        @Override
        public final Builder maxLabels(Integer maxLabels) {
            this.maxLabels = maxLabels;
            return this;
        }

        public final void setMaxLabels(Integer maxLabels) {
            this.maxLabels = maxLabels;
        }

        public final Float getMinConfidence() {
            return minConfidence;
        }

        @Override
        public final Builder minConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
            return this;
        }

        public final void setMinConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetectLabelsRequest build() {
            return new DetectLabelsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
