/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProjectVersionsRequest extends RekognitionRequest implements
        ToCopyableBuilder<DescribeProjectVersionsRequest.Builder, DescribeProjectVersionsRequest> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeProjectVersionsRequest::projectArn)).setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectArn").build()).build();

    private static final SdkField<List<String>> VERSION_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeProjectVersionsRequest::versionNames))
            .setter(setter(Builder::versionNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeProjectVersionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeProjectVersionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD,
            VERSION_NAMES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String projectArn;

    private final List<String> versionNames;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeProjectVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.versionNames = builder.versionNames;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the project that contains the models you want to describe.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the project that contains the models you want to describe.
     */
    public String projectArn() {
        return projectArn;
    }

    /**
     * Returns true if the VersionNames property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasVersionNames() {
        return versionNames != null && !(versionNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of model version names that you want to describe. You can add up to 10 model version names to the list. If
     * you don't specify a value, all model descriptions are returned. A version name is part of a model
     * (ProjectVersion) ARN. For example, <code>my-model.2020-01-21T09.10.15</code> is the version name in the following
     * ARN.
     * <code>arn:aws:rekognition:us-east-1:123456789012:project/getting-started/version/<i>my-model.2020-01-21T09.10.15</i>/1234567890123</code>
     * .
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVersionNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of model version names that you want to describe. You can add up to 10 model version names to the
     *         list. If you don't specify a value, all model descriptions are returned. A version name is part of a
     *         model (ProjectVersion) ARN. For example, <code>my-model.2020-01-21T09.10.15</code> is the version name in
     *         the following ARN.
     *         <code>arn:aws:rekognition:us-east-1:123456789012:project/getting-started/version/<i>my-model.2020-01-21T09.10.15</i>/1234567890123</code>
     *         .
     */
    public List<String> versionNames() {
        return versionNames;
    }

    /**
     * <p>
     * If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom
     * Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of
     * results.
     * </p>
     * 
     * @return If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition
     *         Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve
     *         the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return per paginated call. The largest value you can specify is 100. If you
     * specify a value greater than 100, a ValidationException error occurs. The default value is 100.
     * </p>
     * 
     * @return The maximum number of results to return per paginated call. The largest value you can specify is 100. If
     *         you specify a value greater than 100, a ValidationException error occurs. The default value is 100.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(versionNames());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProjectVersionsRequest)) {
            return false;
        }
        DescribeProjectVersionsRequest other = (DescribeProjectVersionsRequest) obj;
        return Objects.equals(projectArn(), other.projectArn()) && Objects.equals(versionNames(), other.versionNames())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeProjectVersionsRequest").add("ProjectArn", projectArn())
                .add("VersionNames", versionNames()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        case "VersionNames":
            return Optional.ofNullable(clazz.cast(versionNames()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProjectVersionsRequest, T> g) {
        return obj -> g.apply((DescribeProjectVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeProjectVersionsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the project that contains the models you want to describe.
         * </p>
         * 
         * @param projectArn
         *        The Amazon Resource Name (ARN) of the project that contains the models you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * A list of model version names that you want to describe. You can add up to 10 model version names to the
         * list. If you don't specify a value, all model descriptions are returned. A version name is part of a model
         * (ProjectVersion) ARN. For example, <code>my-model.2020-01-21T09.10.15</code> is the version name in the
         * following ARN.
         * <code>arn:aws:rekognition:us-east-1:123456789012:project/getting-started/version/<i>my-model.2020-01-21T09.10.15</i>/1234567890123</code>
         * .
         * </p>
         * 
         * @param versionNames
         *        A list of model version names that you want to describe. You can add up to 10 model version names to
         *        the list. If you don't specify a value, all model descriptions are returned. A version name is part of
         *        a model (ProjectVersion) ARN. For example, <code>my-model.2020-01-21T09.10.15</code> is the version
         *        name in the following ARN.
         *        <code>arn:aws:rekognition:us-east-1:123456789012:project/getting-started/version/<i>my-model.2020-01-21T09.10.15</i>/1234567890123</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNames(Collection<String> versionNames);

        /**
         * <p>
         * A list of model version names that you want to describe. You can add up to 10 model version names to the
         * list. If you don't specify a value, all model descriptions are returned. A version name is part of a model
         * (ProjectVersion) ARN. For example, <code>my-model.2020-01-21T09.10.15</code> is the version name in the
         * following ARN.
         * <code>arn:aws:rekognition:us-east-1:123456789012:project/getting-started/version/<i>my-model.2020-01-21T09.10.15</i>/1234567890123</code>
         * .
         * </p>
         * 
         * @param versionNames
         *        A list of model version names that you want to describe. You can add up to 10 model version names to
         *        the list. If you don't specify a value, all model descriptions are returned. A version name is part of
         *        a model (ProjectVersion) ARN. For example, <code>my-model.2020-01-21T09.10.15</code> is the version
         *        name in the following ARN.
         *        <code>arn:aws:rekognition:us-east-1:123456789012:project/getting-started/version/<i>my-model.2020-01-21T09.10.15</i>/1234567890123</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNames(String... versionNames);

        /**
         * <p>
         * If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition
         * Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the
         * next set of results.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was incomplete (because there is more results to retrieve), Amazon
         *        Rekognition Custom Labels returns a pagination token in the response. You can use this pagination
         *        token to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return per paginated call. The largest value you can specify is 100. If you
         * specify a value greater than 100, a ValidationException error occurs. The default value is 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per paginated call. The largest value you can specify is 100.
         *        If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String projectArn;

        private List<String> versionNames = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProjectVersionsRequest model) {
            super(model);
            projectArn(model.projectArn);
            versionNames(model.versionNames);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        public final Collection<String> getVersionNames() {
            return versionNames;
        }

        @Override
        public final Builder versionNames(Collection<String> versionNames) {
            this.versionNames = VersionNamesCopier.copy(versionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versionNames(String... versionNames) {
            versionNames(Arrays.asList(versionNames));
            return this;
        }

        public final void setVersionNames(Collection<String> versionNames) {
            this.versionNames = VersionNamesCopier.copy(versionNames);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeProjectVersionsRequest build() {
            return new DescribeProjectVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
