/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectProtectiveEquipmentResponse extends RekognitionResponse implements
        ToCopyableBuilder<DetectProtectiveEquipmentResponse.Builder, DetectProtectiveEquipmentResponse> {
    private static final SdkField<String> PROTECTIVE_EQUIPMENT_MODEL_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProtectiveEquipmentModelVersion")
            .getter(getter(DetectProtectiveEquipmentResponse::protectiveEquipmentModelVersion))
            .setter(setter(Builder::protectiveEquipmentModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectiveEquipmentModelVersion")
                    .build()).build();

    private static final SdkField<List<ProtectiveEquipmentPerson>> PERSONS_FIELD = SdkField
            .<List<ProtectiveEquipmentPerson>> builder(MarshallingType.LIST)
            .memberName("Persons")
            .getter(getter(DetectProtectiveEquipmentResponse::persons))
            .setter(setter(Builder::persons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Persons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProtectiveEquipmentPerson> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProtectiveEquipmentPerson::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProtectiveEquipmentSummary> SUMMARY_FIELD = SdkField
            .<ProtectiveEquipmentSummary> builder(MarshallingType.SDK_POJO).memberName("Summary")
            .getter(getter(DetectProtectiveEquipmentResponse::summary)).setter(setter(Builder::summary))
            .constructor(ProtectiveEquipmentSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROTECTIVE_EQUIPMENT_MODEL_VERSION_FIELD, PERSONS_FIELD, SUMMARY_FIELD));

    private final String protectiveEquipmentModelVersion;

    private final List<ProtectiveEquipmentPerson> persons;

    private final ProtectiveEquipmentSummary summary;

    private DetectProtectiveEquipmentResponse(BuilderImpl builder) {
        super(builder);
        this.protectiveEquipmentModelVersion = builder.protectiveEquipmentModelVersion;
        this.persons = builder.persons;
        this.summary = builder.summary;
    }

    /**
     * <p>
     * The version number of the PPE detection model used to detect PPE in the image.
     * </p>
     * 
     * @return The version number of the PPE detection model used to detect PPE in the image.
     */
    public String protectiveEquipmentModelVersion() {
        return protectiveEquipmentModelVersion;
    }

    /**
     * Returns true if the Persons property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPersons() {
        return persons != null && !(persons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of persons detected in the image (including persons not wearing PPE).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPersons()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of persons detected in the image (including persons not wearing PPE).
     */
    public List<ProtectiveEquipmentPerson> persons() {
        return persons;
    }

    /**
     * <p>
     * Summary information for the types of PPE specified in the <code>SummarizationAttributes</code> input parameter.
     * </p>
     * 
     * @return Summary information for the types of PPE specified in the <code>SummarizationAttributes</code> input
     *         parameter.
     */
    public ProtectiveEquipmentSummary summary() {
        return summary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(protectiveEquipmentModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(persons());
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectProtectiveEquipmentResponse)) {
            return false;
        }
        DetectProtectiveEquipmentResponse other = (DetectProtectiveEquipmentResponse) obj;
        return Objects.equals(protectiveEquipmentModelVersion(), other.protectiveEquipmentModelVersion())
                && Objects.equals(persons(), other.persons()) && Objects.equals(summary(), other.summary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DetectProtectiveEquipmentResponse")
                .add("ProtectiveEquipmentModelVersion", protectiveEquipmentModelVersion()).add("Persons", persons())
                .add("Summary", summary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProtectiveEquipmentModelVersion":
            return Optional.ofNullable(clazz.cast(protectiveEquipmentModelVersion()));
        case "Persons":
            return Optional.ofNullable(clazz.cast(persons()));
        case "Summary":
            return Optional.ofNullable(clazz.cast(summary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectProtectiveEquipmentResponse, T> g) {
        return obj -> g.apply((DetectProtectiveEquipmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DetectProtectiveEquipmentResponse> {
        /**
         * <p>
         * The version number of the PPE detection model used to detect PPE in the image.
         * </p>
         * 
         * @param protectiveEquipmentModelVersion
         *        The version number of the PPE detection model used to detect PPE in the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectiveEquipmentModelVersion(String protectiveEquipmentModelVersion);

        /**
         * <p>
         * An array of persons detected in the image (including persons not wearing PPE).
         * </p>
         * 
         * @param persons
         *        An array of persons detected in the image (including persons not wearing PPE).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder persons(Collection<ProtectiveEquipmentPerson> persons);

        /**
         * <p>
         * An array of persons detected in the image (including persons not wearing PPE).
         * </p>
         * 
         * @param persons
         *        An array of persons detected in the image (including persons not wearing PPE).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder persons(ProtectiveEquipmentPerson... persons);

        /**
         * <p>
         * An array of persons detected in the image (including persons not wearing PPE).
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProtectiveEquipmentPerson>.Builder}
         * avoiding the need to create one manually via {@link List<ProtectiveEquipmentPerson>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProtectiveEquipmentPerson>.Builder#build()} is called
         * immediately and its result is passed to {@link #persons(List<ProtectiveEquipmentPerson>)}.
         * 
         * @param persons
         *        a consumer that will call methods on {@link List<ProtectiveEquipmentPerson>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #persons(List<ProtectiveEquipmentPerson>)
         */
        Builder persons(Consumer<ProtectiveEquipmentPerson.Builder>... persons);

        /**
         * <p>
         * Summary information for the types of PPE specified in the <code>SummarizationAttributes</code> input
         * parameter.
         * </p>
         * 
         * @param summary
         *        Summary information for the types of PPE specified in the <code>SummarizationAttributes</code> input
         *        parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(ProtectiveEquipmentSummary summary);

        /**
         * <p>
         * Summary information for the types of PPE specified in the <code>SummarizationAttributes</code> input
         * parameter.
         * </p>
         * This is a convenience that creates an instance of the {@link ProtectiveEquipmentSummary.Builder} avoiding the
         * need to create one manually via {@link ProtectiveEquipmentSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProtectiveEquipmentSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #summary(ProtectiveEquipmentSummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link ProtectiveEquipmentSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(ProtectiveEquipmentSummary)
         */
        default Builder summary(Consumer<ProtectiveEquipmentSummary.Builder> summary) {
            return summary(ProtectiveEquipmentSummary.builder().applyMutation(summary).build());
        }
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private String protectiveEquipmentModelVersion;

        private List<ProtectiveEquipmentPerson> persons = DefaultSdkAutoConstructList.getInstance();

        private ProtectiveEquipmentSummary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectProtectiveEquipmentResponse model) {
            super(model);
            protectiveEquipmentModelVersion(model.protectiveEquipmentModelVersion);
            persons(model.persons);
            summary(model.summary);
        }

        public final String getProtectiveEquipmentModelVersion() {
            return protectiveEquipmentModelVersion;
        }

        @Override
        public final Builder protectiveEquipmentModelVersion(String protectiveEquipmentModelVersion) {
            this.protectiveEquipmentModelVersion = protectiveEquipmentModelVersion;
            return this;
        }

        public final void setProtectiveEquipmentModelVersion(String protectiveEquipmentModelVersion) {
            this.protectiveEquipmentModelVersion = protectiveEquipmentModelVersion;
        }

        public final Collection<ProtectiveEquipmentPerson.Builder> getPersons() {
            return persons != null ? persons.stream().map(ProtectiveEquipmentPerson::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder persons(Collection<ProtectiveEquipmentPerson> persons) {
            this.persons = ProtectiveEquipmentPersonsCopier.copy(persons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder persons(ProtectiveEquipmentPerson... persons) {
            persons(Arrays.asList(persons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder persons(Consumer<ProtectiveEquipmentPerson.Builder>... persons) {
            persons(Stream.of(persons).map(c -> ProtectiveEquipmentPerson.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPersons(Collection<ProtectiveEquipmentPerson.BuilderImpl> persons) {
            this.persons = ProtectiveEquipmentPersonsCopier.copyFromBuilder(persons);
        }

        public final ProtectiveEquipmentSummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        @Override
        public final Builder summary(ProtectiveEquipmentSummary summary) {
            this.summary = summary;
            return this;
        }

        public final void setSummary(ProtectiveEquipmentSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public DetectProtectiveEquipmentResponse build() {
            return new DetectProtectiveEquipmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
