/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filters applied to the technical cue or shot detection segments. For more information, see
 * <a>StartSegmentDetection</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSegmentDetectionFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<StartSegmentDetectionFilters.Builder, StartSegmentDetectionFilters> {
    private static final SdkField<StartTechnicalCueDetectionFilter> TECHNICAL_CUE_FILTER_FIELD = SdkField
            .<StartTechnicalCueDetectionFilter> builder(MarshallingType.SDK_POJO).memberName("TechnicalCueFilter")
            .getter(getter(StartSegmentDetectionFilters::technicalCueFilter)).setter(setter(Builder::technicalCueFilter))
            .constructor(StartTechnicalCueDetectionFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TechnicalCueFilter").build())
            .build();

    private static final SdkField<StartShotDetectionFilter> SHOT_FILTER_FIELD = SdkField
            .<StartShotDetectionFilter> builder(MarshallingType.SDK_POJO).memberName("ShotFilter")
            .getter(getter(StartSegmentDetectionFilters::shotFilter)).setter(setter(Builder::shotFilter))
            .constructor(StartShotDetectionFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShotFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TECHNICAL_CUE_FILTER_FIELD,
            SHOT_FILTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final StartTechnicalCueDetectionFilter technicalCueFilter;

    private final StartShotDetectionFilter shotFilter;

    private StartSegmentDetectionFilters(BuilderImpl builder) {
        this.technicalCueFilter = builder.technicalCueFilter;
        this.shotFilter = builder.shotFilter;
    }

    /**
     * <p>
     * Filters that are specific to technical cues.
     * </p>
     * 
     * @return Filters that are specific to technical cues.
     */
    public StartTechnicalCueDetectionFilter technicalCueFilter() {
        return technicalCueFilter;
    }

    /**
     * <p>
     * Filters that are specific to shot detections.
     * </p>
     * 
     * @return Filters that are specific to shot detections.
     */
    public StartShotDetectionFilter shotFilter() {
        return shotFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(technicalCueFilter());
        hashCode = 31 * hashCode + Objects.hashCode(shotFilter());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSegmentDetectionFilters)) {
            return false;
        }
        StartSegmentDetectionFilters other = (StartSegmentDetectionFilters) obj;
        return Objects.equals(technicalCueFilter(), other.technicalCueFilter())
                && Objects.equals(shotFilter(), other.shotFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartSegmentDetectionFilters").add("TechnicalCueFilter", technicalCueFilter())
                .add("ShotFilter", shotFilter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TechnicalCueFilter":
            return Optional.ofNullable(clazz.cast(technicalCueFilter()));
        case "ShotFilter":
            return Optional.ofNullable(clazz.cast(shotFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSegmentDetectionFilters, T> g) {
        return obj -> g.apply((StartSegmentDetectionFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StartSegmentDetectionFilters> {
        /**
         * <p>
         * Filters that are specific to technical cues.
         * </p>
         * 
         * @param technicalCueFilter
         *        Filters that are specific to technical cues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder technicalCueFilter(StartTechnicalCueDetectionFilter technicalCueFilter);

        /**
         * <p>
         * Filters that are specific to technical cues.
         * </p>
         * This is a convenience that creates an instance of the {@link StartTechnicalCueDetectionFilter.Builder}
         * avoiding the need to create one manually via {@link StartTechnicalCueDetectionFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link StartTechnicalCueDetectionFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #technicalCueFilter(StartTechnicalCueDetectionFilter)}.
         * 
         * @param technicalCueFilter
         *        a consumer that will call methods on {@link StartTechnicalCueDetectionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #technicalCueFilter(StartTechnicalCueDetectionFilter)
         */
        default Builder technicalCueFilter(Consumer<StartTechnicalCueDetectionFilter.Builder> technicalCueFilter) {
            return technicalCueFilter(StartTechnicalCueDetectionFilter.builder().applyMutation(technicalCueFilter).build());
        }

        /**
         * <p>
         * Filters that are specific to shot detections.
         * </p>
         * 
         * @param shotFilter
         *        Filters that are specific to shot detections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shotFilter(StartShotDetectionFilter shotFilter);

        /**
         * <p>
         * Filters that are specific to shot detections.
         * </p>
         * This is a convenience that creates an instance of the {@link StartShotDetectionFilter.Builder} avoiding the
         * need to create one manually via {@link StartShotDetectionFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link StartShotDetectionFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #shotFilter(StartShotDetectionFilter)}.
         * 
         * @param shotFilter
         *        a consumer that will call methods on {@link StartShotDetectionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shotFilter(StartShotDetectionFilter)
         */
        default Builder shotFilter(Consumer<StartShotDetectionFilter.Builder> shotFilter) {
            return shotFilter(StartShotDetectionFilter.builder().applyMutation(shotFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StartTechnicalCueDetectionFilter technicalCueFilter;

        private StartShotDetectionFilter shotFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSegmentDetectionFilters model) {
            technicalCueFilter(model.technicalCueFilter);
            shotFilter(model.shotFilter);
        }

        public final StartTechnicalCueDetectionFilter.Builder getTechnicalCueFilter() {
            return technicalCueFilter != null ? technicalCueFilter.toBuilder() : null;
        }

        @Override
        public final Builder technicalCueFilter(StartTechnicalCueDetectionFilter technicalCueFilter) {
            this.technicalCueFilter = technicalCueFilter;
            return this;
        }

        public final void setTechnicalCueFilter(StartTechnicalCueDetectionFilter.BuilderImpl technicalCueFilter) {
            this.technicalCueFilter = technicalCueFilter != null ? technicalCueFilter.build() : null;
        }

        public final StartShotDetectionFilter.Builder getShotFilter() {
            return shotFilter != null ? shotFilter.toBuilder() : null;
        }

        @Override
        public final Builder shotFilter(StartShotDetectionFilter shotFilter) {
            this.shotFilter = shotFilter;
            return this;
        }

        public final void setShotFilter(StartShotDetectionFilter.BuilderImpl shotFilter) {
            this.shotFilter = shotFilter != null ? shotFilter.build() : null;
        }

        @Override
        public StartSegmentDetectionFilters build() {
            return new StartSegmentDetectionFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
