/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Pose
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Pose> {
    private static final SdkField<Float> ROLL_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Roll").getter(Pose.getter(Pose::roll)).setter(Pose.setter(Builder::roll)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Roll").build()}).build();
    private static final SdkField<Float> YAW_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Yaw").getter(Pose.getter(Pose::yaw)).setter(Pose.setter(Builder::yaw)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Yaw").build()}).build();
    private static final SdkField<Float> PITCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Pitch").getter(Pose.getter(Pose::pitch)).setter(Pose.setter(Builder::pitch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pitch").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLL_FIELD, YAW_FIELD, PITCH_FIELD));
    private static final long serialVersionUID = 1L;
    private final Float roll;
    private final Float yaw;
    private final Float pitch;

    private Pose(BuilderImpl builder) {
        this.roll = builder.roll;
        this.yaw = builder.yaw;
        this.pitch = builder.pitch;
    }

    public Float roll() {
        return this.roll;
    }

    public Float yaw() {
        return this.yaw;
    }

    public Float pitch() {
        return this.pitch;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roll());
        hashCode = 31 * hashCode + Objects.hashCode(this.yaw());
        hashCode = 31 * hashCode + Objects.hashCode(this.pitch());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pose)) {
            return false;
        }
        Pose other = (Pose)obj;
        return Objects.equals(this.roll(), other.roll()) && Objects.equals(this.yaw(), other.yaw()) && Objects.equals(this.pitch(), other.pitch());
    }

    public String toString() {
        return ToString.builder((String)"Pose").add("Roll", (Object)this.roll()).add("Yaw", (Object)this.yaw()).add("Pitch", (Object)this.pitch()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Roll": {
                return Optional.ofNullable(clazz.cast(this.roll()));
            }
            case "Yaw": {
                return Optional.ofNullable(clazz.cast(this.yaw()));
            }
            case "Pitch": {
                return Optional.ofNullable(clazz.cast(this.pitch()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Pose, T> g) {
        return obj -> g.apply((Pose)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float roll;
        private Float yaw;
        private Float pitch;

        private BuilderImpl() {
        }

        private BuilderImpl(Pose model) {
            this.roll(model.roll);
            this.yaw(model.yaw);
            this.pitch(model.pitch);
        }

        public final Float getRoll() {
            return this.roll;
        }

        @Override
        public final Builder roll(Float roll) {
            this.roll = roll;
            return this;
        }

        public final void setRoll(Float roll) {
            this.roll = roll;
        }

        public final Float getYaw() {
            return this.yaw;
        }

        @Override
        public final Builder yaw(Float yaw) {
            this.yaw = yaw;
            return this;
        }

        public final void setYaw(Float yaw) {
            this.yaw = yaw;
        }

        public final Float getPitch() {
            return this.pitch;
        }

        @Override
        public final Builder pitch(Float pitch) {
            this.pitch = pitch;
            return this;
        }

        public final void setPitch(Float pitch) {
            this.pitch = pitch;
        }

        public Pose build() {
            return new Pose(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Pose> {
        public Builder roll(Float var1);

        public Builder yaw(Float var1);

        public Builder pitch(Float var1);
    }
}

