/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies summary attributes to return from a call to <a>DetectProtectiveEquipment</a>. You can specify which types
 * of PPE to summarize. You can also specify a minimum confidence value for detections. Summary information is returned
 * in the <code>Summary</code> (<a>ProtectiveEquipmentSummary</a>) field of the response from
 * <code>DetectProtectiveEquipment</code>. The summary includes which persons in an image were detected wearing the
 * requested types of person protective equipment (PPE), which persons were detected as not wearing PPE, and the persons
 * in which a determination could not be made. For more information, see <a>ProtectiveEquipmentSummary</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectiveEquipmentSummarizationAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtectiveEquipmentSummarizationAttributes.Builder, ProtectiveEquipmentSummarizationAttributes> {
    private static final SdkField<Float> MIN_CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("MinConfidence").getter(getter(ProtectiveEquipmentSummarizationAttributes::minConfidence))
            .setter(setter(Builder::minConfidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinConfidence").build()).build();

    private static final SdkField<List<String>> REQUIRED_EQUIPMENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RequiredEquipmentTypes")
            .getter(getter(ProtectiveEquipmentSummarizationAttributes::requiredEquipmentTypesAsStrings))
            .setter(setter(Builder::requiredEquipmentTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiredEquipmentTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_CONFIDENCE_FIELD,
            REQUIRED_EQUIPMENT_TYPES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float minConfidence;

    private final List<String> requiredEquipmentTypes;

    private ProtectiveEquipmentSummarizationAttributes(BuilderImpl builder) {
        this.minConfidence = builder.minConfidence;
        this.requiredEquipmentTypes = builder.requiredEquipmentTypes;
    }

    /**
     * <p>
     * The minimum confidence level for which you want summary information. The confidence level applies to person
     * detection, body part detection, equipment detection, and body part coverage. Amazon Rekognition doesn't return
     * summary information with a confidence than this specified value. There isn't a default value.
     * </p>
     * <p>
     * Specify a <code>MinConfidence</code> value that is between 50-100% as <code>DetectProtectiveEquipment</code>
     * returns predictions only where the detection confidence is between 50% - 100%. If you specify a value that is
     * less than 50%, the results are the same specifying a value of 50%.
     * </p>
     * <p>
     * </p>
     * 
     * @return The minimum confidence level for which you want summary information. The confidence level applies to
     *         person detection, body part detection, equipment detection, and body part coverage. Amazon Rekognition
     *         doesn't return summary information with a confidence than this specified value. There isn't a default
     *         value.</p>
     *         <p>
     *         Specify a <code>MinConfidence</code> value that is between 50-100% as
     *         <code>DetectProtectiveEquipment</code> returns predictions only where the detection confidence is between
     *         50% - 100%. If you specify a value that is less than 50%, the results are the same specifying a value of
     *         50%.
     *         </p>
     *         <p>
     */
    public Float minConfidence() {
        return minConfidence;
    }

    /**
     * <p>
     * An array of personal protective equipment types for which you want summary information. If a person is detected
     * wearing a required requipment type, the person's ID is added to the <code>PersonsWithRequiredEquipment</code>
     * array field returned in <a>ProtectiveEquipmentSummary</a> by <code>DetectProtectiveEquipment</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRequiredEquipmentTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of personal protective equipment types for which you want summary information. If a person is
     *         detected wearing a required requipment type, the person's ID is added to the
     *         <code>PersonsWithRequiredEquipment</code> array field returned in <a>ProtectiveEquipmentSummary</a> by
     *         <code>DetectProtectiveEquipment</code>.
     */
    public List<ProtectiveEquipmentType> requiredEquipmentTypes() {
        return ProtectiveEquipmentTypesCopier.copyStringToEnum(requiredEquipmentTypes);
    }

    /**
     * Returns true if the RequiredEquipmentTypes property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRequiredEquipmentTypes() {
        return requiredEquipmentTypes != null && !(requiredEquipmentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of personal protective equipment types for which you want summary information. If a person is detected
     * wearing a required requipment type, the person's ID is added to the <code>PersonsWithRequiredEquipment</code>
     * array field returned in <a>ProtectiveEquipmentSummary</a> by <code>DetectProtectiveEquipment</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRequiredEquipmentTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of personal protective equipment types for which you want summary information. If a person is
     *         detected wearing a required requipment type, the person's ID is added to the
     *         <code>PersonsWithRequiredEquipment</code> array field returned in <a>ProtectiveEquipmentSummary</a> by
     *         <code>DetectProtectiveEquipment</code>.
     */
    public List<String> requiredEquipmentTypesAsStrings() {
        return requiredEquipmentTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minConfidence());
        hashCode = 31 * hashCode + Objects.hashCode(requiredEquipmentTypesAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectiveEquipmentSummarizationAttributes)) {
            return false;
        }
        ProtectiveEquipmentSummarizationAttributes other = (ProtectiveEquipmentSummarizationAttributes) obj;
        return Objects.equals(minConfidence(), other.minConfidence())
                && Objects.equals(requiredEquipmentTypesAsStrings(), other.requiredEquipmentTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProtectiveEquipmentSummarizationAttributes").add("MinConfidence", minConfidence())
                .add("RequiredEquipmentTypes", requiredEquipmentTypesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinConfidence":
            return Optional.ofNullable(clazz.cast(minConfidence()));
        case "RequiredEquipmentTypes":
            return Optional.ofNullable(clazz.cast(requiredEquipmentTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtectiveEquipmentSummarizationAttributes, T> g) {
        return obj -> g.apply((ProtectiveEquipmentSummarizationAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectiveEquipmentSummarizationAttributes> {
        /**
         * <p>
         * The minimum confidence level for which you want summary information. The confidence level applies to person
         * detection, body part detection, equipment detection, and body part coverage. Amazon Rekognition doesn't
         * return summary information with a confidence than this specified value. There isn't a default value.
         * </p>
         * <p>
         * Specify a <code>MinConfidence</code> value that is between 50-100% as <code>DetectProtectiveEquipment</code>
         * returns predictions only where the detection confidence is between 50% - 100%. If you specify a value that is
         * less than 50%, the results are the same specifying a value of 50%.
         * </p>
         * <p>
         * </p>
         * 
         * @param minConfidence
         *        The minimum confidence level for which you want summary information. The confidence level applies to
         *        person detection, body part detection, equipment detection, and body part coverage. Amazon Rekognition
         *        doesn't return summary information with a confidence than this specified value. There isn't a default
         *        value.</p>
         *        <p>
         *        Specify a <code>MinConfidence</code> value that is between 50-100% as
         *        <code>DetectProtectiveEquipment</code> returns predictions only where the detection confidence is
         *        between 50% - 100%. If you specify a value that is less than 50%, the results are the same specifying
         *        a value of 50%.
         *        </p>
         *        <p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minConfidence(Float minConfidence);

        /**
         * <p>
         * An array of personal protective equipment types for which you want summary information. If a person is
         * detected wearing a required requipment type, the person's ID is added to the
         * <code>PersonsWithRequiredEquipment</code> array field returned in <a>ProtectiveEquipmentSummary</a> by
         * <code>DetectProtectiveEquipment</code>.
         * </p>
         * 
         * @param requiredEquipmentTypes
         *        An array of personal protective equipment types for which you want summary information. If a person is
         *        detected wearing a required requipment type, the person's ID is added to the
         *        <code>PersonsWithRequiredEquipment</code> array field returned in <a>ProtectiveEquipmentSummary</a> by
         *        <code>DetectProtectiveEquipment</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredEquipmentTypesWithStrings(Collection<String> requiredEquipmentTypes);

        /**
         * <p>
         * An array of personal protective equipment types for which you want summary information. If a person is
         * detected wearing a required requipment type, the person's ID is added to the
         * <code>PersonsWithRequiredEquipment</code> array field returned in <a>ProtectiveEquipmentSummary</a> by
         * <code>DetectProtectiveEquipment</code>.
         * </p>
         * 
         * @param requiredEquipmentTypes
         *        An array of personal protective equipment types for which you want summary information. If a person is
         *        detected wearing a required requipment type, the person's ID is added to the
         *        <code>PersonsWithRequiredEquipment</code> array field returned in <a>ProtectiveEquipmentSummary</a> by
         *        <code>DetectProtectiveEquipment</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredEquipmentTypesWithStrings(String... requiredEquipmentTypes);

        /**
         * <p>
         * An array of personal protective equipment types for which you want summary information. If a person is
         * detected wearing a required requipment type, the person's ID is added to the
         * <code>PersonsWithRequiredEquipment</code> array field returned in <a>ProtectiveEquipmentSummary</a> by
         * <code>DetectProtectiveEquipment</code>.
         * </p>
         * 
         * @param requiredEquipmentTypes
         *        An array of personal protective equipment types for which you want summary information. If a person is
         *        detected wearing a required requipment type, the person's ID is added to the
         *        <code>PersonsWithRequiredEquipment</code> array field returned in <a>ProtectiveEquipmentSummary</a> by
         *        <code>DetectProtectiveEquipment</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredEquipmentTypes(Collection<ProtectiveEquipmentType> requiredEquipmentTypes);

        /**
         * <p>
         * An array of personal protective equipment types for which you want summary information. If a person is
         * detected wearing a required requipment type, the person's ID is added to the
         * <code>PersonsWithRequiredEquipment</code> array field returned in <a>ProtectiveEquipmentSummary</a> by
         * <code>DetectProtectiveEquipment</code>.
         * </p>
         * 
         * @param requiredEquipmentTypes
         *        An array of personal protective equipment types for which you want summary information. If a person is
         *        detected wearing a required requipment type, the person's ID is added to the
         *        <code>PersonsWithRequiredEquipment</code> array field returned in <a>ProtectiveEquipmentSummary</a> by
         *        <code>DetectProtectiveEquipment</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredEquipmentTypes(ProtectiveEquipmentType... requiredEquipmentTypes);
    }

    static final class BuilderImpl implements Builder {
        private Float minConfidence;

        private List<String> requiredEquipmentTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectiveEquipmentSummarizationAttributes model) {
            minConfidence(model.minConfidence);
            requiredEquipmentTypesWithStrings(model.requiredEquipmentTypes);
        }

        public final Float getMinConfidence() {
            return minConfidence;
        }

        @Override
        public final Builder minConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
            return this;
        }

        public final void setMinConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
        }

        public final Collection<String> getRequiredEquipmentTypes() {
            return requiredEquipmentTypes;
        }

        @Override
        public final Builder requiredEquipmentTypesWithStrings(Collection<String> requiredEquipmentTypes) {
            this.requiredEquipmentTypes = ProtectiveEquipmentTypesCopier.copy(requiredEquipmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredEquipmentTypesWithStrings(String... requiredEquipmentTypes) {
            requiredEquipmentTypesWithStrings(Arrays.asList(requiredEquipmentTypes));
            return this;
        }

        @Override
        public final Builder requiredEquipmentTypes(Collection<ProtectiveEquipmentType> requiredEquipmentTypes) {
            this.requiredEquipmentTypes = ProtectiveEquipmentTypesCopier.copyEnumToString(requiredEquipmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredEquipmentTypes(ProtectiveEquipmentType... requiredEquipmentTypes) {
            requiredEquipmentTypes(Arrays.asList(requiredEquipmentTypes));
            return this;
        }

        public final void setRequiredEquipmentTypes(Collection<String> requiredEquipmentTypes) {
            this.requiredEquipmentTypes = ProtectiveEquipmentTypesCopier.copy(requiredEquipmentTypes);
        }

        @Override
        public ProtectiveEquipmentSummarizationAttributes build() {
            return new ProtectiveEquipmentSummarizationAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
