/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartFaceDetectionRequest extends RekognitionRequest implements
        ToCopyableBuilder<StartFaceDetectionRequest.Builder, StartFaceDetectionRequest> {
    private static final SdkField<Video> VIDEO_FIELD = SdkField.<Video> builder(MarshallingType.SDK_POJO).memberName("Video")
            .getter(getter(StartFaceDetectionRequest::video)).setter(setter(Builder::video)).constructor(Video::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Video").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken").getter(getter(StartFaceDetectionRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build())
            .build();

    private static final SdkField<NotificationChannel> NOTIFICATION_CHANNEL_FIELD = SdkField
            .<NotificationChannel> builder(MarshallingType.SDK_POJO).memberName("NotificationChannel")
            .getter(getter(StartFaceDetectionRequest::notificationChannel)).setter(setter(Builder::notificationChannel))
            .constructor(NotificationChannel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationChannel").build())
            .build();

    private static final SdkField<String> FACE_ATTRIBUTES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FaceAttributes").getter(getter(StartFaceDetectionRequest::faceAttributesAsString))
            .setter(setter(Builder::faceAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceAttributes").build()).build();

    private static final SdkField<String> JOB_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobTag")
            .getter(getter(StartFaceDetectionRequest::jobTag)).setter(setter(Builder::jobTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTag").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIDEO_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, NOTIFICATION_CHANNEL_FIELD, FACE_ATTRIBUTES_FIELD, JOB_TAG_FIELD));

    private final Video video;

    private final String clientRequestToken;

    private final NotificationChannel notificationChannel;

    private final String faceAttributes;

    private final String jobTag;

    private StartFaceDetectionRequest(BuilderImpl builder) {
        super(builder);
        this.video = builder.video;
        this.clientRequestToken = builder.clientRequestToken;
        this.notificationChannel = builder.notificationChannel;
        this.faceAttributes = builder.faceAttributes;
        this.jobTag = builder.jobTag;
    }

    /**
     * <p>
     * The video in which you want to detect faces. The video must be stored in an Amazon S3 bucket.
     * </p>
     * 
     * @return The video in which you want to detect faces. The video must be stored in an Amazon S3 bucket.
     */
    public Video video() {
        return video;
    }

    /**
     * <p>
     * Idempotent token used to identify the start request. If you use the same token with multiple
     * <code>StartFaceDetection</code> requests, the same <code>JobId</code> is returned. Use
     * <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once.
     * </p>
     * 
     * @return Idempotent token used to identify the start request. If you use the same token with multiple
     *         <code>StartFaceDetection</code> requests, the same <code>JobId</code> is returned. Use
     *         <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of
     * the face detection operation.
     * </p>
     * 
     * @return The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion
     *         status of the face detection operation.
     */
    public NotificationChannel notificationChannel() {
        return notificationChannel;
    }

    /**
     * <p>
     * The face attributes you want returned.
     * </p>
     * <p>
     * <code>DEFAULT</code> - The following subset of facial attributes are returned: BoundingBox, Confidence, Pose,
     * Quality and Landmarks.
     * </p>
     * <p>
     * <code>ALL</code> - All facial attributes are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #faceAttributes}
     * will return {@link FaceAttributes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #faceAttributesAsString}.
     * </p>
     * 
     * @return The face attributes you want returned.</p>
     *         <p>
     *         <code>DEFAULT</code> - The following subset of facial attributes are returned: BoundingBox, Confidence,
     *         Pose, Quality and Landmarks.
     *         </p>
     *         <p>
     *         <code>ALL</code> - All facial attributes are returned.
     * @see FaceAttributes
     */
    public FaceAttributes faceAttributes() {
        return FaceAttributes.fromValue(faceAttributes);
    }

    /**
     * <p>
     * The face attributes you want returned.
     * </p>
     * <p>
     * <code>DEFAULT</code> - The following subset of facial attributes are returned: BoundingBox, Confidence, Pose,
     * Quality and Landmarks.
     * </p>
     * <p>
     * <code>ALL</code> - All facial attributes are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #faceAttributes}
     * will return {@link FaceAttributes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #faceAttributesAsString}.
     * </p>
     * 
     * @return The face attributes you want returned.</p>
     *         <p>
     *         <code>DEFAULT</code> - The following subset of facial attributes are returned: BoundingBox, Confidence,
     *         Pose, Quality and Landmarks.
     *         </p>
     *         <p>
     *         <code>ALL</code> - All facial attributes are returned.
     * @see FaceAttributes
     */
    public String faceAttributesAsString() {
        return faceAttributes;
    }

    /**
     * <p>
     * An identifier you specify that's returned in the completion notification that's published to your Amazon Simple
     * Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them
     * in the completion notification.
     * </p>
     * 
     * @return An identifier you specify that's returned in the completion notification that's published to your Amazon
     *         Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and
     *         identify them in the completion notification.
     */
    public String jobTag() {
        return jobTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(video());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(notificationChannel());
        hashCode = 31 * hashCode + Objects.hashCode(faceAttributesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobTag());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartFaceDetectionRequest)) {
            return false;
        }
        StartFaceDetectionRequest other = (StartFaceDetectionRequest) obj;
        return Objects.equals(video(), other.video()) && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(notificationChannel(), other.notificationChannel())
                && Objects.equals(faceAttributesAsString(), other.faceAttributesAsString())
                && Objects.equals(jobTag(), other.jobTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartFaceDetectionRequest").add("Video", video())
                .add("ClientRequestToken", clientRequestToken()).add("NotificationChannel", notificationChannel())
                .add("FaceAttributes", faceAttributesAsString()).add("JobTag", jobTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Video":
            return Optional.ofNullable(clazz.cast(video()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "NotificationChannel":
            return Optional.ofNullable(clazz.cast(notificationChannel()));
        case "FaceAttributes":
            return Optional.ofNullable(clazz.cast(faceAttributesAsString()));
        case "JobTag":
            return Optional.ofNullable(clazz.cast(jobTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartFaceDetectionRequest, T> g) {
        return obj -> g.apply((StartFaceDetectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartFaceDetectionRequest> {
        /**
         * <p>
         * The video in which you want to detect faces. The video must be stored in an Amazon S3 bucket.
         * </p>
         * 
         * @param video
         *        The video in which you want to detect faces. The video must be stored in an Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder video(Video video);

        /**
         * <p>
         * The video in which you want to detect faces. The video must be stored in an Amazon S3 bucket.
         * </p>
         * This is a convenience that creates an instance of the {@link Video.Builder} avoiding the need to create one
         * manually via {@link Video#builder()}.
         *
         * When the {@link Consumer} completes, {@link Video.Builder#build()} is called immediately and its result is
         * passed to {@link #video(Video)}.
         * 
         * @param video
         *        a consumer that will call methods on {@link Video.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #video(Video)
         */
        default Builder video(Consumer<Video.Builder> video) {
            return video(Video.builder().applyMutation(video).build());
        }

        /**
         * <p>
         * Idempotent token used to identify the start request. If you use the same token with multiple
         * <code>StartFaceDetection</code> requests, the same <code>JobId</code> is returned. Use
         * <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once.
         * </p>
         * 
         * @param clientRequestToken
         *        Idempotent token used to identify the start request. If you use the same token with multiple
         *        <code>StartFaceDetection</code> requests, the same <code>JobId</code> is returned. Use
         *        <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status
         * of the face detection operation.
         * </p>
         * 
         * @param notificationChannel
         *        The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion
         *        status of the face detection operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationChannel(NotificationChannel notificationChannel);

        /**
         * <p>
         * The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status
         * of the face detection operation.
         * </p>
         * This is a convenience that creates an instance of the {@link NotificationChannel.Builder} avoiding the need
         * to create one manually via {@link NotificationChannel#builder()}.
         *
         * When the {@link Consumer} completes, {@link NotificationChannel.Builder#build()} is called immediately and
         * its result is passed to {@link #notificationChannel(NotificationChannel)}.
         * 
         * @param notificationChannel
         *        a consumer that will call methods on {@link NotificationChannel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationChannel(NotificationChannel)
         */
        default Builder notificationChannel(Consumer<NotificationChannel.Builder> notificationChannel) {
            return notificationChannel(NotificationChannel.builder().applyMutation(notificationChannel).build());
        }

        /**
         * <p>
         * The face attributes you want returned.
         * </p>
         * <p>
         * <code>DEFAULT</code> - The following subset of facial attributes are returned: BoundingBox, Confidence, Pose,
         * Quality and Landmarks.
         * </p>
         * <p>
         * <code>ALL</code> - All facial attributes are returned.
         * </p>
         * 
         * @param faceAttributes
         *        The face attributes you want returned.</p>
         *        <p>
         *        <code>DEFAULT</code> - The following subset of facial attributes are returned: BoundingBox,
         *        Confidence, Pose, Quality and Landmarks.
         *        </p>
         *        <p>
         *        <code>ALL</code> - All facial attributes are returned.
         * @see FaceAttributes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FaceAttributes
         */
        Builder faceAttributes(String faceAttributes);

        /**
         * <p>
         * The face attributes you want returned.
         * </p>
         * <p>
         * <code>DEFAULT</code> - The following subset of facial attributes are returned: BoundingBox, Confidence, Pose,
         * Quality and Landmarks.
         * </p>
         * <p>
         * <code>ALL</code> - All facial attributes are returned.
         * </p>
         * 
         * @param faceAttributes
         *        The face attributes you want returned.</p>
         *        <p>
         *        <code>DEFAULT</code> - The following subset of facial attributes are returned: BoundingBox,
         *        Confidence, Pose, Quality and Landmarks.
         *        </p>
         *        <p>
         *        <code>ALL</code> - All facial attributes are returned.
         * @see FaceAttributes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FaceAttributes
         */
        Builder faceAttributes(FaceAttributes faceAttributes);

        /**
         * <p>
         * An identifier you specify that's returned in the completion notification that's published to your Amazon
         * Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and
         * identify them in the completion notification.
         * </p>
         * 
         * @param jobTag
         *        An identifier you specify that's returned in the completion notification that's published to your
         *        Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group
         *        related jobs and identify them in the completion notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTag(String jobTag);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private Video video;

        private String clientRequestToken;

        private NotificationChannel notificationChannel;

        private String faceAttributes;

        private String jobTag;

        private BuilderImpl() {
        }

        private BuilderImpl(StartFaceDetectionRequest model) {
            super(model);
            video(model.video);
            clientRequestToken(model.clientRequestToken);
            notificationChannel(model.notificationChannel);
            faceAttributes(model.faceAttributes);
            jobTag(model.jobTag);
        }

        public final Video.Builder getVideo() {
            return video != null ? video.toBuilder() : null;
        }

        @Override
        public final Builder video(Video video) {
            this.video = video;
            return this;
        }

        public final void setVideo(Video.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final NotificationChannel.Builder getNotificationChannel() {
            return notificationChannel != null ? notificationChannel.toBuilder() : null;
        }

        @Override
        public final Builder notificationChannel(NotificationChannel notificationChannel) {
            this.notificationChannel = notificationChannel;
            return this;
        }

        public final void setNotificationChannel(NotificationChannel.BuilderImpl notificationChannel) {
            this.notificationChannel = notificationChannel != null ? notificationChannel.build() : null;
        }

        public final String getFaceAttributes() {
            return faceAttributes;
        }

        @Override
        public final Builder faceAttributes(String faceAttributes) {
            this.faceAttributes = faceAttributes;
            return this;
        }

        @Override
        public final Builder faceAttributes(FaceAttributes faceAttributes) {
            this.faceAttributes(faceAttributes == null ? null : faceAttributes.toString());
            return this;
        }

        public final void setFaceAttributes(String faceAttributes) {
            this.faceAttributes = faceAttributes;
        }

        public final String getJobTag() {
            return jobTag;
        }

        @Override
        public final Builder jobTag(String jobTag) {
            this.jobTag = jobTag;
            return this;
        }

        public final void setJobTag(String jobTag) {
            this.jobTag = jobTag;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartFaceDetectionRequest build() {
            return new StartFaceDetectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
